<?php
/*
Template Name: Reset Password
*/

/**
 * @package WordPress
 * @subpackage Jobster
 */

global $post;

if (is_user_logged_in()) {
    wp_redirect(home_url());
}

get_header();

$auth_settings = get_option('jobster_authentication_settings');
$restet_pass_img =  isset($auth_settings['jobster_signin_img_field']) 
                    ? $auth_settings['jobster_signin_img_field']
                    : '';
$signin_url = jobster_get_page_link('sign-in.php'); ?>

<section 
    class="pxp-hero vh-100 pxp-reset-pass-page" 
    style="background-color: var(--pxpMainColorLight);"
>
    <div class="row align-items-center pxp-sign-hero-container">
        <div class="col-xl-6 pxp-column">
            <div class="pxp-sign-hero-fig text-center pb-100 pt-100">
                <?php if (!empty($reset_pass_img)) {
                    $reset_pass_fig = wp_get_attachment_image_src($reset_pass_img, 'full');
                    if (is_array($reset_pass_fig)) { ?>
                        <img 
                            src="<?php echo esc_url($reset_pass_fig[0]); ?>" 
                            alt="<?php esc_html_e('Reset Password', 'jobster-plugin'); ?>"
                        >
                    <?php } else { ?>
                        <img 
                            src="<?php echo esc_url(JOBSTER_LOCATION . '/images/password-fig.png'); ?>" 
                            alt="<?php esc_html_e('Reset Password', 'jobster-plugin'); ?>"
                        >
                    <?php }
                } else { ?>
                    <img 
                        src="<?php echo esc_url(JOBSTER_LOCATION . '/images/password-fig.png'); ?>" 
                        alt="<?php esc_html_e('Reset Password', 'jobster-plugin'); ?>"
                    >
                <?php } ?>
                <h1 class="mt-4 mt-lg-5">
                    <?php esc_html_e('Set new password', 'jobster-plugin'); ?>
                </h1>
            </div>
        </div>
        <div class="col-xl-6 pxp-column pxp-is-light">
            <div class="pxp-sign-hero-form pb-100 pt-100">
                <div class="row justify-content-center">
                    <div class="col-lg-6 col-xl-7 col-xxl-6">
                        <div class="pxp-sign-hero-form-content pxp-auth-page">
                            <h5 class="text-center">
                                <?php esc_html_e('Reset Password', 'jobster-plugin'); ?>
                            </h5>

                            <form class="mt-4">
                                <div class="pxp-modal-message pxp-reset-page-message"></div>

                                <div class="form-floating mb-3">
                                    <input 
                                        type="password" 
                                        class="form-control pxp-password-control" 
                                        id="pxp-reset-page-password" 
                                        placeholder="<?php esc_html_e('New password', 'jobster-plugin'); ?>"
                                    >
                                    <label for="pxp-reset-page-password">
                                        <?php esc_html_e('New password', 'jobster-plugin'); ?>
                                    </label>
                                    <span class="fa fa-eye pxp-password-toggle"></span>
                                </div>

                                <?php wp_nonce_field(
                                    'signin_ajax_nonce',
                                    'pxp-reset-page-security',
                                    true
                                ); ?>

                                <a 
                                    href="javascript:void(0);" 
                                    class="btn rounded-pill pxp-modal-cta pxp-reset-page-btn"
                                >
                                    <span class="pxp-reset-page-btn-text">
                                        <?php esc_html_e('Set new password', 'jobster-plugin'); ?>
                                    </span>
                                    <span class="pxp-reset-page-btn-loading pxp-btn-loading">
                                        <img 
                                            src="<?php echo esc_url(JOBSTER_LOCATION . '/images/loader-light.svg'); ?>" 
                                            class="pxp-btn-loader" 
                                            alt="..."
                                        >
                                    </span>
                                </a>
                                <div class="mt-4 text-center pxp-modal-small">
                                    <a href="<?php echo esc_url($signin_url); ?>"><?php esc_html_e('Sign in', 'jobster-plugin'); ?></a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>