<?php
/**
 * @package WordPress
 * @subpackage Jobster
 */

class JobsterPageTemplater {
    private static $instance;
    protected $templates;

    public static function get_instance() {
        if(null == self::$instance) {
            self::$instance = new JobsterPageTemplater();
        }

        return self::$instance;
    }

    private function __construct() {
        $this->templates = array();

        if (version_compare(floatval(get_bloginfo('version')), '4.7', '<')) {
            add_filter('page_attributes_dropdown_pages_args', array($this, 'register_project_templates'));
        } else {
            add_filter('theme_page_templates', array($this, 'add_new_template'));
        }

        add_filter('wp_insert_post_data', array($this, 'register_project_templates'));
        add_filter('template_include', array($this, 'view_project_template'));

        $this->templates = array(
            'full-width.php'                        => __('Full Width', 'jobster-plugin'),
            'job-search.php'                        => __('Job Search', 'jobster-plugin'),
            'job-search-apis.php'                   => __('Job Search External APIs', 'jobster-plugin'),
            'company-search.php'                    => __('Company Search', 'jobster-plugin'),
            'candidate-search.php'                  => __('Candidate Search', 'jobster-plugin'),
            'job-categories.php'                    => __('Job Categories', 'jobster-plugin'),
            'company-dashboard.php'                 => __('Company Dashboard', 'jobster-plugin'),
            'company-dashboard-profile.php'         => __('Company Dashboard - Profile', 'jobster-plugin'),
            'company-dashboard-new-job.php'         => __('Company Dashboard - New Job', 'jobster-plugin'),
            'company-dashboard-jobs.php'            => __('Company Dashboard - Manage Jobs', 'jobster-plugin'),
            'company-dashboard-edit-job.php'        => __('Company Dashboard - Edit Job', 'jobster-plugin'),
            'company-dashboard-candidates.php'      => __('Company Dashboard - Candidates', 'jobster-plugin'),
            'company-dashboard-subscriptions.php'   => __('Company Dashboard - Subscriptions', 'jobster-plugin'),
            'company-dashboard-password.php'        => __('Company Dashboard - Change Password', 'jobster-plugin'),
            'company-dashboard-inbox.php'           => __('Company Dashboard - Inbox', 'jobster-plugin'),
            'company-dashboard-notifications.php'   => __('Company Dashboard - Notifications', 'jobster-plugin'),
            'candidate-dashboard.php'               => __('Candidate Dashboard', 'jobster-plugin'),
            'candidate-dashboard-profile.php'       => __('Candidate Dashboard - Profile', 'jobster-plugin'),
            'candidate-dashboard-apps.php'          => __('Candidate Dashboard - Applications', 'jobster-plugin'),
            'candidate-dashboard-favs.php'          => __('Candidate Dashboard - Favourite Jobs', 'jobster-plugin'),
            'candidate-dashboard-password.php'      => __('Candidate Dashboard - Change Password', 'jobster-plugin'),
            'candidate-dashboard-inbox.php'         => __('Candidate Dashboard - Inbox', 'jobster-plugin'),
            'candidate-dashboard-notifications.php' => __('Candidate Dashboard - Notifications', 'jobster-plugin'),
            'candidate-dashboard-apply.php'         => __('Candidate Dashboard - Apply', 'jobster-plugin'),
            'paypal-processor.php'                  => __('PayPal Processor', 'jobster-plugin'),
            'stripe-processor.php'                  => __('Stripe Processor', 'jobster-plugin'),
            'sign-in.php'                           => __('Sign In', 'jobster-plugin'),
            'sign-up.php'                           => __('Sign Up', 'jobster-plugin'),
            'forgot-pass.php'                       => __('Forgot Password', 'jobster-plugin'),
            'reset-pass.php'                        => __('Reset Password', 'jobster-plugin'),
        );
    }

    public function add_new_template($posts_templates) {
        $posts_templates = array_merge($posts_templates, $this->templates);

        return $posts_templates;
    }

    public function register_project_templates($atts) {
        $cache_key = 'page_templates-' . md5(get_theme_root() . '/' . get_stylesheet());
        $templates = wp_get_theme()->get_page_templates();

        if (empty($templates)) {
            $templates = array();
        }

        wp_cache_delete($cache_key , 'themes');

        $templates = array_merge($templates, $this->templates);

        wp_cache_add($cache_key, $templates, 'themes', 1800);

        return $atts;
    }

    public function view_project_template($template) {
        global $post;

        if (!$post) {
            return $template;
        }

        if (!isset($this->templates[get_post_meta($post->ID, '_wp_page_template', true)])) {
            return $template;
        }

        $file = plugin_dir_path( __FILE__ ) . get_post_meta($post->ID, '_wp_page_template', true);

        if (file_exists($file)) {
            return $file;
        } else {
            echo $file;
        }

        return $template;
    }
}
add_action('plugins_loaded', array('JobsterPageTemplater', 'get_instance'));

/**
 * Get page link by template file
 */
if (!function_exists('jobster_get_page_link')): 
    function jobster_get_page_link($template_file) {
        $pages = get_pages(array(
            'meta_key' => '_wp_page_template',
            'meta_value' => $template_file
        ));

        $page_link = '';
        if ($pages) {
            $page_link = get_permalink($pages[0]->ID);
        }

        return $page_link;
    }
endif;

/**
 * Get page ID by template file
 */
if (!function_exists('jobster_get_page_id_by_template')): 
    function jobster_get_page_id_by_template($template_file) {
        $pages = get_pages(array(
            'meta_key' => '_wp_page_template',
            'meta_value' => $template_file
        ));

        $page_id = '';

        if ($pages) {
            $page_id = $pages[0]->ID;
        }

        return $page_id;
    }
endif;