<?php
/*
* Plugin Name: Jobster Plugin
* Description: Core functionality for Jobster WP Theme.
* Text Domain: jobster-plugin
* Domain Path: /languages
* Version: 2.2
* Author: Pixel Prime
* Author URI: http://pixelprime.co
*/

define('JOBSTER_PLUGIN_PATH', plugin_dir_url( __FILE__ ));
define('JOBSYER_PLUGIN_BASENAME', plugin_basename(__FILE__));

add_action('init', 'jobster_load_plugin_textdomain');
function jobster_load_plugin_textdomain() {
    load_plugin_textdomain('jobster-plugin', false, dirname(plugin_basename( __FILE__ ) ) . '/languages');
}

/**
 * Scripts
 */
require_once 'scripts.php';

/**
 * Custom post types
 */
require_once 'post-types/init.php';

/**
 * Custom meta
 */
require_once 'meta/init.php';

/**
 * Custom Navigation
 */
require_once 'nav/init.php';

/**
 * Blocks
 */
require_once 'blocks/init.php';

/**
 * Widgets
 */
require_once 'widgets/init.php';

/**
 * Page templates
 */
require_once 'page-templates/init.php';

/**
 * Services
 */
require_once 'services/users.php';
require_once 'services/search-jobs.php';
require_once 'services/search-companies.php';
require_once 'services/search-candidates.php';
require_once 'services/favs.php';
require_once 'services/apps.php';
require_once 'services/contact-company.php';
require_once 'services/contact-candidate.php';
require_once 'services/inbox.php';
require_once 'services/notifications.php';
require_once 'services/visitors.php';
require_once 'services/upload-cover.php';
require_once 'services/upload-logo.php';
require_once 'services/upload-cv.php';
require_once 'services/upload-file.php';
require_once 'services/upload-gallery.php';
require_once 'services/update-company-profile.php';
require_once 'services/save-job.php';
require_once 'services/update-candidate-profile.php';
require_once 'services/subscription.php';
require_once 'services/contact-block.php';
require_once 'services/paypal.php';
require_once 'services/stripe.php';
require_once 'services/upload-doc.php';
require_once 'services/alerts.php';

/**
 * Views
 */
require_once 'views/init.php';
require_once 'views/user-nav.php';
require_once 'views/search-jobs-form.php';
require_once 'views/search-jobs-form-hero.php';
require_once 'views/filter-jobs-form.php';
require_once 'views/search-companies-form.php';
require_once 'views/search-candidates-form.php';
require_once 'views/social.php';
require_once 'views/similar-jobs.php';
require_once 'views/contact-company-form.php';
require_once 'views/company-jobs.php';
require_once 'views/contact-candidate-form.php';
require_once 'views/company-dashboard-side.php';
require_once 'views/company-dashboard-top.php';
require_once 'views/candidate-dashboard-side.php';
require_once 'views/candidate-dashboard-top.php';
require_once 'views/share-post.php';
require_once 'views/youtube-video.php';
require_once 'views/search-jobs-form-section.php';

/**
 * Admin
 */
require_once 'admin/settings.php';

/**
 * Elementor
 */
require_once 'elementor/init.php';

/**
 * Stripe
 */
$membership_settings = get_option('jobster_membership_settings', '');
$payment_type  =    isset($membership_settings['jobster_payment_type_field'])
                    ? $membership_settings['jobster_payment_type_field']
                    : '';
if ($payment_type == 'listing' || $payment_type == 'plan') {
    $payment_system =   isset($membership_settings['jobster_payment_system_field'])
                        ? $membership_settings['jobster_payment_system_field']
                        : '';
    if ($payment_system == 'stripe') {
        require_once 'libs/stripe-php-9.0.0/init.php';
        $stripe_sk =    isset($membership_settings['jobster_stripe_secret_key_field'])
                        ? $membership_settings['jobster_stripe_secret_key_field']
                        : '';
        if ($stripe_sk != '') {
            \Stripe\Stripe::setApiKey($stripe_sk);
        }
    }
}

/**
 * Job Board External APIs
 */

$apis_settings = get_option('jobster_apis_settings', '');
$api  = isset($apis_settings['jobster_api_field'])
        ? $apis_settings['jobster_api_field']
        : '';
if ($api == 'careerjet') {
    require_once 'libs/Careerjet_API.php';
    require_once 'services/search-jobs-careerjet.php';
}

/**
 * Custom colors
 */
if (!function_exists('jobster_add_custom_colors')): 
    function jobster_add_custom_colors() {
        echo '<style>';
        require_once 'services/colors.php';
        echo '</style>';
    }
endif;
add_action('wp_head', 'jobster_add_custom_colors');

if (!function_exists('jobster_sanitize_multi_array')) :
    function jobster_sanitize_multi_array(&$item, $key) {
        $item = sanitize_text_field($item);
    }
endif;

if (!function_exists('jobster_sanitize_array')) :
    function jobster_sanitize_array($array) {
        $new_array = array();

        foreach ($array as $value) {
            array_push($new_array, sanitize_text_field($value));
        }

        return $new_array;
    }
endif;

if (!function_exists('jobster_get_attachment')) :
    function jobster_get_attachment($id) {
        $attachment = get_post($id);

        if ($attachment) {
            return array(
                'alt'         => get_post_meta($attachment->ID, '_wp_attachment_image_alt', true),
                'caption'     => $attachment->post_excerpt,
                'description' => $attachment->post_content,
                'title'       => $attachment->post_title
            );
        } else {
            return false;
        }
    }
endif;

/**
 * Custom 2nd logo
 */
if (!function_exists('jobster_add_second_logo_setting')): 
    function jobster_add_second_logo_setting($wp_customize) {
        $wp_customize->add_setting('jobster_second_logo');

        $wp_customize->add_control(
            new WP_Customize_Cropped_Image_Control(
                $wp_customize, 
                'jobster_second_logo', 
                array(
                    'label'      => __('Transparent Header Logo', 'jobster-plugin'),
                    'section'    => 'title_tagline',
                    'settings'   => 'jobster_second_logo',
                    'priority'   => 10,
                    'height'     => 300,
                    'width'      => 300,
                    'flex-width' => true,
                )
            )
        );
    }
endif;
add_action('customize_register', 'jobster_add_second_logo_setting');

/**
 * Function used for custom sorting of arrays
 */
if (!function_exists('jobster_compare_position')) :
    function jobster_compare_position($a, $b) {
        return intval($a["position"]) - intval($b["position"]);
    }
endif;

/**
 * Subscribers must have media library access only to their files
 */
if (!function_exists('jobster_filter_media_library_for_subscribers')) :
    function jobster_filter_media_library_for_subscribers($query) {
        $current_user = wp_get_current_user();

        if (current_user_can('subscriber')) {
            $query['author'] = get_current_user_id();
        }

        return $query;
    }
endif;
add_filter('ajax_query_attachments_args', 'jobster_filter_media_library_for_subscribers');

/**
 * Allow subscribers to attach media files to new/edit job page
 */
if (!function_exists('jobster_meta_cap_for_media_library')) :
    function jobster_meta_cap_for_media_library($caps, $cap, $user_id, $args) {
        if ('edit_post' == $cap) {
            $post_id = $args[0];

            $new_job_page_id = jobster_get_page_id_by_template('company-dashboard-new-job.php');
            $edit_job_page_id = jobster_get_page_id_by_template('company-dashboard-edit-job.php');

            if (($post_id == $new_job_page_id || $post_id == $edit_job_page_id) 
                    && current_user_can('upload_files')) {
                $caps = [];
            }
        }

        return $caps;
    }
endif;
add_filter('map_meta_cap', 'jobster_meta_cap_for_media_library', 10, 4);

/**
 * Redirect subscribers when trying to access the new/edit job admin page
 */
if (!function_exists('jobster_redirect_new_edit_job_page')) :
    function jobster_redirect_new_edit_job_page() {
        $new_job_page_id = jobster_get_page_id_by_template('company-dashboard-new-job.php');
        $edit_job_page_id = jobster_get_page_id_by_template('company-dashboard-edit-job.php');

        if (current_user_can('subscriber')
            && isset($_GET['action']) 
            && $_GET['action'] == 'edit' 
            && isset($_GET['post']) 
            && ($_GET['post'] == $new_job_page_id 
                || $_GET['post'] == $edit_job_page_id)
        ) {
            wp_redirect(home_url());
            exit();
        }
    }
endif;
add_action('init', 'jobster_redirect_new_edit_job_page');

/**
 * Remove edit page option from admin bar for subscribers
 */
if (!function_exists('jobster_remove_admin_bar_edit_page_option')) :
    function jobster_remove_admin_bar_edit_page_option() {
        global $wp_admin_bar;

        if (current_user_can('subscriber')) {
            $wp_admin_bar->remove_menu('edit');
        }
    }
endif;
add_action('wp_before_admin_bar_render', 'jobster_remove_admin_bar_edit_page_option');
?>