<?php
/**
 * @package WordPress
 * @subpackage Jobster
 */

if (!function_exists('jobster_admin_email')): 
    function jobster_admin_email() {
        add_settings_section(
            'jobster_email_section',
            __('Email Templates', 'jobster-plugin'),
            'jobster_email_section_callback',
            'jobster_email_settings'
        );
        add_settings_field(
            'jobster_email_app_notify_field',
            __('Job Application Notification', 'jobster-plugin'),
            'jobster_email_app_notify_field_render',
            'jobster_email_settings',
            'jobster_email_section'
        );
        add_settings_field(
            'jobster_email_contact_form_section_field',
            __('Contact Form Section', 'jobster-plugin'),
            'jobster_email_contact_form_section_field_render',
            'jobster_email_settings',
            'jobster_email_section'
        );
        add_settings_field(
            'jobster_email_contact_candidate_field',
            __('Contact Candidate', 'jobster-plugin'),
            'jobster_email_contact_candidate_field_render',
            'jobster_email_settings',
            'jobster_email_section'
        );
        add_settings_field(
            'jobster_email_contact_company_field',
            __('Contact Company', 'jobster-plugin'),
            'jobster_email_contact_company_field_render',
            'jobster_email_settings',
            'jobster_email_section'
        );
        add_settings_field(
            'jobster_email_signup_notify_admin_field',
            __('Sign Up Notify Admin', 'jobster-plugin'),
            'jobster_email_signup_notify_admin_field_render',
            'jobster_email_settings',
            'jobster_email_section'
        );
        add_settings_field(
            'jobster_email_signup_notify_user_field',
            __('Sign Up Notify User', 'jobster-plugin'),
            'jobster_email_signup_notify_user_field_render',
            'jobster_email_settings',
            'jobster_email_section'
        );
        add_settings_field(
            'jobster_email_reset_pass_field',
            __('Password Reset', 'jobster-plugin'),
            'jobster_email_reset_pass_field_render',
            'jobster_email_settings',
            'jobster_email_section'
        );
        add_settings_field(
            'jobster_email_activation_notify_user_field',
            __('User Account Activation Notification', 'jobster-plugin'),
            'jobster_email_activation_notify_user_field_render',
            'jobster_email_settings',
            'jobster_email_section'
        );
        add_settings_field(
            'jobster_email_job_alerts_field',
            __('Job Alerts', 'jobster-plugin'),
            'jobster_email_job_alerts_field_render',
            'jobster_email_settings',
            'jobster_email_section'
        );
        add_settings_field(
            'jobster_email_job_expiration_alerts_field',
            __('Job Expiration Alerts', 'jobster-plugin'),
            'jobster_email_job_expiration_alerts_field_render',
            'jobster_email_settings',
            'jobster_email_section'
        );
        add_settings_field(
            'jobster_email_membership_plan_activated_field',
            __('Membership Plan Activated', 'jobster-plugin'),
            'jobster_email_membership_plan_activated_field_render',
            'jobster_email_settings',
            'jobster_email_section'
        );
    }
endif;

if (!function_exists('jobster_email_section_callback')): 
    function jobster_email_section_callback() {
        echo '';
    }
endif;

if (!function_exists('jobster_email_app_notify_field_render')): 
    function jobster_email_app_notify_field_render() { 
        $options = get_option('jobster_email_settings'); ?>

        <p style="font-size: 12px;">
            <i>
                <?php esc_html_e('Variables to use: ','jobster-plugin'); ?>
                {JOB_TITLE}, {CANDIDATE_NAME}, {CANDIDATE_EMAIL}, {CANDIDATE_PHONE}, {CANDIDATE_MESSAGE}
            </i>
        </p>
        <br>

        <textarea 
            rows="5" 
            name="jobster_email_settings[jobster_email_app_notify_field]" 
            id="jobster_email_settings[jobster_email_app_notify_field]" 
            class="widefat textarea pxp-email-app-notify-field"
        ><?php if (isset($options['jobster_email_app_notify_field'])) {
            echo wp_unslash($options['jobster_email_app_notify_field']);
        } ?></textarea>
    <?php }
endif;

if (!function_exists('jobster_email_contact_form_section_field_render')): 
    function jobster_email_contact_form_section_field_render() { 
        $options = get_option('jobster_email_settings'); ?>

        <p style="font-size: 12px;">
            <i>
                <?php esc_html_e('Variables to use: ','jobster-plugin'); ?>
                {CLIENT_NAME}, {CLIENT_EMAIL}, {CLIENT_MESSAGE}
            </i>
        </p>
        <br>

        <textarea 
            rows="5" 
            name="jobster_email_settings[jobster_email_contact_form_section_field]" 
            id="jobster_email_settings[jobster_email_contact_form_section_field]" 
            class="widefat textarea pxp-email-contact-form-section-field"
        ><?php if (isset($options['jobster_email_contact_form_section_field'])) {
            echo wp_unslash($options['jobster_email_contact_form_section_field']);
        } ?></textarea>
    <?php }
endif;

if (!function_exists('jobster_email_contact_candidate_field_render')): 
    function jobster_email_contact_candidate_field_render() { 
        $options = get_option('jobster_email_settings'); ?>

        <p style="font-size: 12px;">
            <i>
                <?php esc_html_e('Variables to use: ','jobster-plugin'); ?>
                {CLIENT_NAME}, {CLIENT_EMAIL}, {CLIENT_MESSAGE}
            </i>
        </p>
        <br>

        <textarea 
            rows="5" 
            name="jobster_email_settings[jobster_email_contact_candidate_field]" 
            id="jobster_email_settings[jobster_email_contact_candidate_field]" 
            class="widefat textarea pxp-email-contact-candidate-field"
        ><?php if (isset($options['jobster_email_contact_candidate_field'])) {
            echo wp_unslash($options['jobster_email_contact_candidate_field']);
        } ?></textarea>
    <?php }
endif;

if (!function_exists('jobster_email_contact_company_field_render')): 
    function jobster_email_contact_company_field_render() { 
        $options = get_option('jobster_email_settings'); ?>

        <p style="font-size: 12px;">
            <i>
                <?php esc_html_e('Variables to use: ','jobster-plugin'); ?>
                {CLIENT_NAME}, {CLIENT_EMAIL}, {CLIENT_MESSAGE}
            </i>
        </p>
        <br>

        <textarea 
            rows="5" 
            name="jobster_email_settings[jobster_email_contact_company_field]" 
            id="jobster_email_settings[jobster_email_contact_company_field]" 
            class="widefat textarea pxp-email-contact-company-field"
        ><?php if (isset($options['jobster_email_contact_company_field'])) {
            echo wp_unslash($options['jobster_email_contact_company_field']);
        } ?></textarea>
    <?php }
endif;

if (!function_exists('jobster_email_signup_notify_admin_field_render')): 
    function jobster_email_signup_notify_admin_field_render() { 
        $options = get_option('jobster_email_settings'); ?>

        <p style="font-size: 12px;">
            <i>
                <?php esc_html_e('Variables to use: ','jobster-plugin'); ?>
                {USER_NAME}, {USER_EMAIL}
            </i>
        </p>
        <br>

        <textarea 
            rows="5" 
            name="jobster_email_settings[jobster_email_signup_notify_admin_field]" 
            id="jobster_email_settings[jobster_email_signup_notify_admin_field]" 
            class="widefat textarea pxp-signup-notify-admin-field"
        ><?php if (isset($options['jobster_email_signup_notify_admin_field'])) {
            echo wp_unslash($options['jobster_email_signup_notify_admin_field']);
        } ?></textarea>
    <?php }
endif;

if (!function_exists('jobster_email_signup_notify_user_field_render')): 
    function jobster_email_signup_notify_user_field_render() { 
        $options = get_option('jobster_email_settings'); ?>

        <p style="font-size: 12px;">
            <i>
                <?php esc_html_e('Variables to use: ','jobster-plugin'); ?>
                {USER_FIRSTNAME}, {USER_NAME}, {USER_PASSWORD}
            </i>
        </p>
        <br>

        <textarea 
            rows="5" 
            name="jobster_email_settings[jobster_email_signup_notify_user_field]" 
            id="jobster_email_settings[jobster_email_signup_notify_user_field]" 
            class="widefat textarea pxp-signup-notify-user-field"
        ><?php if (isset($options['jobster_email_signup_notify_user_field'])) {
            echo wp_unslash($options['jobster_email_signup_notify_user_field']);
        } ?></textarea>
    <?php }
endif;

if (!function_exists('jobster_email_reset_pass_field_render')): 
    function jobster_email_reset_pass_field_render() { 
        $options = get_option('jobster_email_settings'); ?>

        <p style="font-size: 12px;">
            <i>
                <?php esc_html_e('Variables to use: ','jobster-plugin'); ?>
                {WEBSITE_URL}, {USER_NAME}, {RESET_URL}
            </i>
        </p>
        <br>

        <textarea 
            rows="5" 
            name="jobster_email_settings[jobster_email_reset_pass_field]" 
            id="jobster_email_settings[jobster_email_reset_pass_field]" 
            class="widefat textarea pxp-reset-pass-field"
        ><?php if (isset($options['jobster_email_reset_pass_field'])) {
            echo wp_unslash($options['jobster_email_reset_pass_field']);
        } ?></textarea>
    <?php }
endif;

if (!function_exists('jobster_email_activation_notify_user_field_render')): 
    function jobster_email_activation_notify_user_field_render() { 
        $options = get_option('jobster_email_settings'); ?>

        <p style="font-size: 12px;">
            <i>
                <?php esc_html_e('Variables to use: ','jobster-plugin'); ?>
                {USER_NAME}, {WEBSITE_NAME}, {ACTIVATION_URL}
            </i>
        </p>
        <br>

        <textarea 
            rows="5" 
            name="jobster_email_settings[jobster_email_activation_notify_user_field]" 
            id="jobster_email_settings[jobster_email_activation_notify_user_field]" 
            class="widefat textarea pxp-activation-notify-user-field"
        ><?php if (isset($options['jobster_email_activation_notify_user_field'])) {
            echo wp_unslash($options['jobster_email_activation_notify_user_field']);
        } ?></textarea>
    <?php }
endif;

if (!function_exists('jobster_email_job_alerts_field_render')): 
    function jobster_email_job_alerts_field_render() { 
        $options = get_option('jobster_email_settings'); ?>

        <p style="font-size: 12px;">
            <i>
                <?php esc_html_e('Variables to use: ','jobster-plugin'); ?>
                {CANDIDATE_NAME}, {JOB_TITLE}, {JOB_URL}, {COMPANY_NAME}
            </i>
        </p>
        <br>

        <textarea 
            rows="5" 
            name="jobster_email_settings[jobster_email_job_alerts_field]" 
            id="jobster_email_settings[jobster_email_job_alerts_field]" 
            class="widefat textarea pxp-email-job-alerts-field"
        ><?php if (isset($options['jobster_email_job_alerts_field'])) {
            echo wp_unslash($options['jobster_email_job_alerts_field']);
        } ?></textarea>
    <?php }
endif;

if (!function_exists('jobster_email_job_expiration_alerts_field_render')): 
    function jobster_email_job_expiration_alerts_field_render() { 
        $options = get_option('jobster_email_settings'); ?>

        <p style="font-size: 12px;">
            <i>
                <?php esc_html_e('Variables to use: ','jobster-plugin'); ?>
                {JOB_TITLE}, {JOB_URL}, {JOB_POST_DATE}, {JOB_EXPIRY_DATE}, {COMPANY_NAME}
            </i>
        </p>
        <br>

        <textarea 
            rows="5" 
            name="jobster_email_settings[jobster_email_job_expiration_alerts_field]" 
            id="jobster_email_settings[jobster_email_job_expiration_alerts_field]" 
            class="widefat textarea pxp-email-job-expiration-alerts-field"
        ><?php if (isset($options['jobster_email_job_expiration_alerts_field'])) {
            echo wp_unslash($options['jobster_email_job_expiration_alerts_field']);
        } ?></textarea>
    <?php }
endif;

if (!function_exists('jobster_email_membership_plan_activated_field_render')): 
    function jobster_email_membership_plan_activated_field_render() { 
        $options = get_option('jobster_email_settings'); ?>

        <p style="font-size: 12px;">
            <i>
                <?php esc_html_e('Variables to use: ','jobster-plugin'); ?>
                {PLAN_TITLE}, {WEBSITE_NAME}
            </i>
        </p>
        <br>

        <textarea 
            rows="5" 
            name="jobster_email_settings[jobster_email_membership_plan_activated_field]" 
            id="jobster_email_settings[jobster_email_membership_plan_activated_field]" 
            class="widefat textarea pxp-email-membership-plan-activated-field"
        ><?php if (isset($options['jobster_email_membership_plan_activated_field'])) {
            echo wp_unslash($options['jobster_email_membership_plan_activated_field']);
        } ?></textarea>
    <?php }
endif;
?>