<?php

class PxlTextEditor_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_text_editor';
    protected $title = 'PXL Text Editor';
    protected $icon = 'eicon-text';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"editor_section","label":"Text Editor","tab":"content","controls":[{"name":"text_editor","label":"","type":"wysiwyg","default":"Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo."}]},{"name":"section_style_content","label":"Style","tab":"style","controls":[{"name":"max_width","label":"Max Width (px)","type":"slider","control_type":"responsive","range":{"px":{"min":100,"max":1920}},"selectors":{"{{WRAPPER}} .pxl-text-editor":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"align","label":"Alignment","type":"choose","control_type":"responsive","options":{"start":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"end":{"title":"Right","icon":"eicon-text-align-right"}},"selectors":{"{{WRAPPER}} .pxl-text-editor-wrap":"justify-content: {{VALUE}};","{{WRAPPER}} .pxl-text-editor":"text-align: {{VALUE}};"}},{"name":"text_color","label":"Text Color","type":"color","default":"","control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-text-editor":"color: {{VALUE}};","{{WRAPPER}} .border-left .pxl-text-editor:before":"background-color: {{VALUE}};"}},{"name":"link_color","label":"Link Color","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-text-editor a":"color: {{VALUE}};","{{WRAPPER}} .pxl-text-editor a.link-underline":"border-color: {{VALUE}};"}},{"name":"link_color_hover","label":"Link Color Hover","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-text-editor a:hover":"color: {{VALUE}};"}},{"name":"typography","type":"typography","label":"Text Typography","selector":"{{WRAPPER}} .pxl-text-editor, {{WRAPPER}} .pxl-text-editor h1, {{WRAPPER}} .pxl-text-editor h2, {{WRAPPER}} .pxl-text-editor h3, {{WRAPPER}} .pxl-text-editor h4, {{WRAPPER}} .pxl-text-editor h5, {{WRAPPER}} .pxl-text-editor h6","control_type":"group"},{"name":"link_typography","type":"typography","label":"Link Typography","selector":"{{WRAPPER}} .pxl-text-editor a","control_type":"group"},{"name":"border_left","label":"Border Left","type":"switcher","default":"false"}]},{"name":"stroke_section","label":"Stroke Settings","tab":"style","controls":[{"name":"text_stroke","label":"Text Stroke","type":"switcher"},{"name":"text_stroke_width","label":"Text Stroke Width","type":"number","control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-text-editor":"-webkit-text-stroke-width: {{VALUE}}px;"},"default":"","condition":{"text_stroke":"true"}},{"name":"stroke_color","label":"Stroke Color","type":"color","default":"","control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-text-editor":"-webkit-text-stroke-color: {{VALUE}};"},"condition":{"text_stroke":"true"}}]},{"name":"parallax_section","label":"Parallax Settings","tab":"style","controls":[{"name":"pxl_parallax","label":"Parallax Type","type":"select","options":{"":"None","x":"Transform X","y":"Transform Y","z":"Transform Z","rotateX":"RotateX","rotateY":"RotateY","rotateZ":"RotateZ","scaleX":"ScaleX","scaleY":"ScaleY","scaleZ":"ScaleZ","scale":"Scale"}},{"name":"parallax_value","label":"Value","type":"text","default":"","condition":{"pxl_parallax!":""}}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}