<?php

class PxlSocials_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_socials';
    protected $title = 'PXL Social';
    protected $icon = 'eicon-social-icons';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"layout_section","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/demo.casethemes.net\/adsett\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_socials-1.jpg"},"2":{"label":"Layout 2","image":"https:\/\/demo.casethemes.net\/adsett\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_socials-2.jpg"},"3":{"label":"Layout 3","image":"https:\/\/demo.casethemes.net\/adsett\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_socials-3.jpg"}},"prefix_class":"pxl-socials-layout-"}]},{"name":"social_section","label":"Socials Settings","tab":"content","controls":[{"name":"social_list","label":"Social Lists","type":"repeater","controls":[{"name":"social_name","label":"Name","type":"text","label_block":true},{"name":"social_link","label":"Link","type":"url","placeholder":"https:\/\/your-link.com","label_block":true},{"name":"social_icon","label":"Icon","type":"icons","fa4compatibility":"social","default":[]}],"default":[{"social_name":"Facebook","social_link":{"url":"https:\/\/facebook.com","is_external":"on"},"social_icon":{"value":"pxli-facebook-f","library":"pxli"}},{"social_name":"Twitter","social_link":{"url":"https:\/\/twitter.com","is_external":"on"},"social_icon":{"value":"pxli-twitter","library":"pxli"}},{"social_name":"Linkedin","social_link":{"url":"https:\/\/linkedin.com","is_external":"on"},"social_icon":{"value":"pxli-linkedin-in","library":"pxli"}},{"social_name":"Pinterest","social_link":{"url":"https:\/\/pinterest.com","is_external":"on"},"social_icon":{"value":"pxli-pinterest-p","library":"pxli"}}],"title_field":"{{{ elementor.helpers.renderIcon( this, social_icon, {}, \"i\", \"panel\" ) || \'<i class=\"{{ icon }}\" aria-hidden=\"true\"><\/i>\' }}} {{{ social_name }}}"}]},{"name":"style_section","label":"Style","tab":"style","controls":[{"name":"align","label":"Alignment","type":"choose","control_type":"responsive","default":"","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"}},"selectors":{"{{WRAPPER}} .pxl-socials-wrap":"text-align: {{VALUE}};"}},{"name":"social_item_space","label":"Item Space","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-socials-wrap":"margin-left: calc({{SIZE}}{{UNIT}} \/ -2); margin-right: calc({{SIZE}}{{UNIT}} \/ -2);","{{WRAPPER}} .pxl-socials-wrap >*":"margin-left: calc({{SIZE}}{{UNIT}} \/ 2); margin-right: calc({{SIZE}}{{UNIT}} \/ 2);"}},{"name":"social_icon_size","label":"Icon Font Size","type":"slider","range":{"px":{"min":10,"max":50}},"default":{"size":""},"selectors":{"{{WRAPPER}} .social-item":"font-size: {{SIZE}}{{UNIT}};"}},{"name":"social_item_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .social-item":"color: {{VALUE}};"}},{"name":"social_color_hover","label":"Color Hover","type":"color","selectors":{"{{WRAPPER}} .social-item:hover":"color: {{VALUE}};"}},{"name":"social_bg_color","label":"Background Color","type":"color","selectors":{"{{WRAPPER}} .social-item":"background-color: {{VALUE}};"}},{"name":"social_bg_color_hover","label":"Background Color Hover","type":"color","selectors":{"{{WRAPPER}} .social-item:hover":"background-color: {{VALUE}};"}}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}