<?php

class PxlSliderItem_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_slider_item';
    protected $title = 'PXL Slider Item';
    protected $icon = 'eicon-slideshow';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"layout_section","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/demo.casethemes.net\/adsett\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_slide_item-1.jpg"}},"prefix_class":"pxl-slider-item-"}]},{"name":"slide_settings","label":"Slider Settings","tab":"settings","controls":[{"label":"Slider Height","name":"slider_height","type":"number","control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-slide-item-wrap, {{WRAPPER}} .slide-content-wrap > div":"height:{{VALUE}}px"},"default":"922"},{"name":"ken_burns","label":"Ken Burns Effect","type":"switcher","frontend_available":true},{"name":"ken_burns_direction","label":"Direction","type":"select","default":"in","options":{"in":"In","out":"Out"},"frontend_available":true},{"name":"content_margin","label":"Content Margin","type":"dimensions","size_units":["px","%"],"selectors":{"{{WRAPPER}} .sl-content-inner":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive"},{"name":"bg_image","label":"Slide Background Image","type":"media","label_block":true},{"name":"overlay_bg_image","label":"Overlay Background Image","type":"media","label_block":true},{"name":"bg_color","label":"Background Overlay Color","type":"color","control_type":"responsive","selectors":{"{{WRAPPER}} .mask-ovl, {{WRAPPER}} .overlay-color":"background-color:{{VALUE}};"}},{"name":"overlay_bg_animation","label":"Overlay Motion Effect","type":"animation"},{"name":"overlay_bg_animation_delay","label":"Overlay Transition Delay","type":"text"}]},{"name":"slide_large_heading","label":"Heading","tab":"content","controls":[{"name":"large_heading","label":"Heading","type":"textarea","placeholder":"Enter your text","label_block":true},{"name":"large_heading_color","label":"Color","type":"color","control_type":"responsive","selectors":{"{{WRAPPER}} .large-heading":"color:{{VALUE}};"}},{"name":"large_heading_width","label":"Width","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":270,"max":1600},"%":{"min":10,"max":100}},"selectors":{"{{WRAPPER}} .large-heading":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"large_heading_typo","type":"typography","control_type":"group","selector":"{{WRAPPER}} .large-heading"},{"name":"large_heading_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .large-heading"},{"name":"large_heading_space","label":"Heading Margin(px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .large-heading":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"large_heading_animation","label":"Motion Effect","type":"animation"},{"name":"large_heading_animation_delay","label":"Transition Delay","type":"text"}]},{"name":"slide_small_heading","label":"Sub Heading","tab":"content","controls":[{"name":"small_heading","label":"Sub Heading","type":"textarea","placeholder":"Enter your text","label_block":true},{"name":"small_heading_color","label":"Color","type":"color","control_type":"responsive","selectors":{"{{WRAPPER}} .small-heading":"color:{{VALUE}};"}},{"name":"small_heading_stroke_color","label":"Stroke Color","type":"color","control_type":"responsive","selectors":{"{{WRAPPER}} .small-heading":"-webkit-text-stroke-color:{{VALUE}};"}},{"name":"small_heading_typo","type":"typography","control_type":"group","selector":"{{WRAPPER}} .small-heading"},{"name":"small_heading_space","label":"Sub Heading Margin(px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .small-heading":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"small_heading_animation","label":"Motion Effect","type":"animation","label_block":false},{"name":"small_heading_animation_delay","label":"Transition Delay","type":"text"},{"name":"small_heading_custom_cls","label":"Custom Class","type":"text"}]},{"name":"slide_desc","label":"Description","tab":"content","controls":[{"name":"desc","label":"Description","type":"textarea","placeholder":"Enter your text","label_block":true},{"name":"desc_color","label":"Color","type":"color","control_type":"responsive","selectors":{"{{WRAPPER}} .desc":"color:{{VALUE}};"}},{"name":"desc_width","label":"Description Width","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":270,"max":1600},"%":{"min":10,"max":100}},"selectors":{"{{WRAPPER}} .desc":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"description_typo","type":"typography","control_type":"group","selector":"{{WRAPPER}} .desc"},{"name":"desc_space","label":"Description Margin(px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .desc":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"desc_animation","label":"Motion Effect","type":"animation"},{"name":"desc_animation_delay","label":"Transition Delay","type":"text"}]},{"name":"slide_btn1","label":"Button 1","tab":"content","controls":[{"name":"btn1_type","label":"Button type","type":"select","default":"default","options":{"default":"Default","outline-under":"Border outline under","outline-above":"Border outline above","outline-around":"Border outline around"}},{"name":"btn1_hover_style","label":"Border Hover Style","type":"select","default":"transform","options":{"transform":"Transform","draw":"Draw"}},{"name":"btn1_text","label":"Button text","type":"text","default":"About us"},{"name":"btn1_link","label":"Button Link","type":"url","placeholder":"https:\/\/your-link.com","default":{"url":""}},{"name":"btn1_icon","label":"Button Icon","type":"icons","default":[]},{"name":"btn1_icon_align","label":"Icon Position","type":"select","default":"right","options":{"right":"After","left":"Before"}},{"name":"btn1_padding","label":"Padding","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .sl-content-inner .btn1":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive"},{"name":"btn1_margin","label":"Margin(px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .sl-content-inner .btn1":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"btn1_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .sl-content-inner .btn1"},{"name":"btn1_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .sl-content-inner .btn1":"color: {{VALUE}} !important;"}},{"name":"btn1_color_hover","label":"Text Color Hover","type":"color","selectors":{"{{WRAPPER}} .sl-content-inner .btn1:hover":"color: {{VALUE}} !important;"}},{"name":"btn1_bg_color","label":"Background Color","type":"color","selectors":{"{{WRAPPER}} .sl-content-inner .btn1":"background: {{VALUE}} !important;"}},{"name":"btn1_bg_color_hover","label":"Background Color Hover","type":"color","selectors":{"{{WRAPPER}} .sl-content-inner .btn1:hover, {{WRAPPER}} .sl-content-inner .btn1:focus":"background: {{VALUE}} !important;"}},{"name":"btn1_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .sl-content-inner .btn1.pxl-btn:after":"border-color: {{VALUE}} !important;"}},{"name":"btn1_border_color_hover","label":"Border Color Hover","type":"color","selectors":{"{{WRAPPER}} .sl-content-inner .btn1.pxl-btn.transform:hover:after":"border-color: {{VALUE}} !important;","{{WRAPPER}} .sl-content-inner .btn1.pxl-btn:hover span.draw:before":"background-color: {{VALUE}} !important;","{{WRAPPER}} .sl-content-inner .btn1.pxl-btn:hover span.draw:after":"background-color: {{VALUE}} !important;"}},{"name":"btn1_animation","label":"Motion Effect","type":"animation"},{"name":"btn1_animation_delay","label":"Transition Delay","type":"text"}]},{"name":"slide_btn2","label":"Button 2","tab":"content","controls":[{"name":"btn2_type","label":"Button type","type":"select","default":"default","options":{"default":"Default","outline-under":"Border outline under","outline-above":"Border outline above","outline-around":"Border outline around"}},{"name":"btn2_hover_style","label":"Border Hover Style","type":"select","default":"transform","options":{"transform":"Transform","draw":"Draw"}},{"name":"btn2_text","label":"Button text","type":"text","default":"About us"},{"name":"btn2_link","label":"Button Link","type":"url","placeholder":"https:\/\/your-link.com","default":{"url":""}},{"name":"btn2_icon","label":"Button Icon","type":"icons","default":[]},{"name":"btn2_icon_align","label":"Icon Position","type":"select","default":"right","options":{"right":"After","left":"Before"}},{"name":"btn2_padding","label":"Padding","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .sl-content-inner .btn2":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive"},{"name":"btn2_margin","label":"Margin(px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .sl-content-inner .btn2":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"btn2_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .sl-content-inner .btn2"},{"name":"btn2_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .sl-content-inner .btn2":"color: {{VALUE}} !important;"}},{"name":"btn2_color_hover","label":"Text Color Hover","type":"color","selectors":{"{{WRAPPER}} .sl-content-inner .btn2:hover":"color: {{VALUE}} !important;"}},{"name":"btn2_bg_color","label":"Background Color","type":"color","selectors":{"{{WRAPPER}} .sl-content-inner .btn2":"background: {{VALUE}} !important;"}},{"name":"btn2_bg_color_hover","label":"Background Color Hover","type":"color","selectors":{"{{WRAPPER}} .sl-content-inner .btn2:hover, {{WRAPPER}} .sl-content-inner .btn2:focus":"background: {{VALUE}} !important;"}},{"name":"btn2_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .sl-content-inner .btn2.pxl-btn:after":"border-color: {{VALUE}} !important;"}},{"name":"btn2_border_color_hover","label":"Border Color Hover","type":"color","selectors":{"{{WRAPPER}} .sl-content-inner .btn2.pxl-btn.transform:hover:after":"border-color: {{VALUE}} !important;","{{WRAPPER}} .sl-content-inner .btn2.pxl-btn:hover span.draw:before":"background-color: {{VALUE}} !important;","{{WRAPPER}} .sl-content-inner .btn2.pxl-btn:hover span.draw:after":"background-color: {{VALUE}} !important;"}},{"name":"btn2_animation","label":"Motion Effect","type":"animation"},{"name":"btn2_animation_delay","label":"Transition Delay","type":"text"}]},{"name":"slide_extra_info2","label":"Extra Information","tab":"content","controls":[{"name":"line_mark_color","label":"Line Mark Color","type":"color","control_type":"responsive","selectors":{"{{WRAPPER}} .large-heading .mark-top:before":"background-color:{{VALUE}};","{{WRAPPER}} .large-heading .mark-top:after":"background-color:{{VALUE}};"}}],"condition":{"layout":"2"}},{"name":"dots_grid","label":"Dots Grid","tab":"content","controls":[{"name":"show_dots","label":"Show dots","type":"switcher","default":"true"},{"name":"line_color","label":"Line Color","type":"color","control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-dot-animate .dot-item:before":"background-color:{{VALUE}};"}},{"name":"dots_color","label":"Dots Color","type":"color","control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-dot-animate .dot-item span":"background-color:{{VALUE}};"}}],"condition":{"layout":"2"}},{"name":"video_player","label":"Video Player","tab":"content","controls":[{"name":"video_link","label":"Video URL","description":"(https:\/\/www.youtube.com\/watch?v=r2YbkyYA9Gc)","type":"url","default":{"url":"","is_external":"on"}},{"name":"video_play_bg","label":"Video Button Background","type":"color","condition":{"video_link[url]!":""},"selectors":{"{{WRAPPER}} .pxl-video-btn":"background-color: {{VALUE}};"}},{"name":"video_play_bg_hover","label":"Video Button Background Hover","type":"color","condition":{"video_link[url]!":""},"selectors":{"{{WRAPPER}} .pxl-video-btn:hover":"background-color: {{VALUE}};"}},{"name":"video_play_width","label":"Video Button Width","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":30,"max":200},"%":{"min":1,"max":100}},"condition":{"video_link[url]!":""},"selectors":{"{{WRAPPER}} .btn-video-wrap .pxl-video-btn":"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};"}},{"name":"video_play_font_size","label":"Video Font Size","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":10,"max":50}},"condition":{"video_link[url]!":""},"selectors":{"{{WRAPPER}} .pxl-video-btn":"font-size: {{SIZE}}{{UNIT}};"}},{"name":"play_icon_color","label":"Play Icon Color","type":"color","condition":{"video_link[url]!":""},"selectors":{"{{WRAPPER}} .pxl-video-btn > .pxl-icon":"color: {{VALUE}};"}},{"name":"play_icon_color_hover","label":"Play Icon Color Hover","type":"color","condition":{"video_link[url]!":""},"selectors":{"{{WRAPPER}} .pxl-video-btn:hover > .pxl-icon":"color: {{VALUE}};"}},{"name":"play_icon_animation","label":"Motion Effect","type":"animation","condition":{"video_link[url]!":""}},{"name":"play_icon_animation_duration","label":"Animation Duration","type":"select","default":"normal","options":{"slow":"Slow","normal":"Normal","fast":"Fast"},"condition":{"video_link[url]!":"","play_icon_animation!":""}},{"name":"play_icon_animation_delay","label":"Transition Delay","type":"text","condition":{"video_link[url]!":"","play_icon_animation!":""}},{"name":"video_position","label":"Video  Position","type":"select","control_type":"responsive","default":"","options":{"relative":"Default","absolute":"Absolute"},"selectors":{"{{WRAPPER}} .btn-video-wrap":"position: {{VALUE}}"},"frontend_available":true,"condition":{"video_link[url]!":""}},{"name":"video_pos_offset_left","label":"Left (50px) px,%,vw,auto","type":"text","default":"","control_type":"responsive","selectors":{"{{WRAPPER}} .btn-video-wrap":"left: {{VALUE}}"},"condition":{"video_link[url]!":"","video_position!":""}},{"name":"video_pos_offset_right","label":"Right (50px) px,%,vw,auto","type":"text","default":"","control_type":"responsive","selectors":{"{{WRAPPER}} .btn-video-wrap":"right: {{VALUE}}"},"condition":{"video_link[url]!":"","video_position!":""}},{"name":"video_pos_offset_top","label":"Top (50px) px,%,vh,auto","type":"text","default":"","control_type":"responsive","selectors":{"{{WRAPPER}} .btn-video-wrap":"top: {{VALUE}}"},"condition":{"video_link[url]!":"","video_position!":""}},{"name":"video_pos_offset_bottom","label":"Bottom (50px) px,%,vh,auto","type":"text","default":"","control_type":"responsive","selectors":{"{{WRAPPER}} .btn-video-wrap":"bottom: {{VALUE}}"},"condition":{"video_link[url]!":"","video_position!":""}},{"name":"video_z_index","label":"Video  Z-Index","type":"number","selectors":{"{{WRAPPER}} .btn-video-wrap":"z-index: {{VALUE}};"},"condition":{"video_link[url]!":"","video_position!":""}}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}