<?php

class PxlPostGrid_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_post_grid';
    protected $title = 'PXL Post Grid';
    protected $icon = 'eicon-posts-grid';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"layout_section","label":"Layout","tab":"layout","controls":[{"name":"post_type","label":"Select Post Type","type":"select","multiple":true,"options":{"post":"Post","portfolio":"Portfolio"},"default":"post"},{"name":"layout_post","label":"Select Templates of Post","type":"layoutcontrol","default":"post-1","options":{"post-1":{"label":"Layout 1","image":"https:\/\/demo.casethemes.net\/adsett\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/post_grid-layout1.jpg"},"post-2":{"label":"Layout 2","image":"https:\/\/demo.casethemes.net\/adsett\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/post_grid-layout2.jpg"},"post-3":{"label":"Layout 3","image":"https:\/\/demo.casethemes.net\/adsett\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/post_grid-layout3.jpg"}},"prefix_class":"pxl-post-layout-","condition":{"post_type":["post"]}},{"name":"layout_portfolio","label":"Select Templates of Portfolio","type":"layoutcontrol","default":"post-1","options":{"portfolio-1":{"label":"Layout 1","image":"https:\/\/demo.casethemes.net\/adsett\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/post_grid-portfolio-1.jpg"},"portfolio-2":{"label":"Layout 2","image":"https:\/\/demo.casethemes.net\/adsett\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/post_grid-portfolio-2.jpg"}},"prefix_class":"pxl-post-layout-","condition":{"post_type":["portfolio"]}}]},{"name":"source_section","label":"Source","tab":"content","controls":[{"name":"select_post_by","label":"Select posts by","type":"select","multiple":true,"options":{"term_selected":"Terms selected","post_selected":"Posts selected "},"default":"term_selected"},{"name":"source_post","label":"Select Term","description":"Get all when no term selected","type":"select2","multiple":true,"options":{"architecture|category":"Architecture","construction|category":"Construction","furniture|category":"Furniture","interior-design|category":"Interior Design","renovation|category":"Renovation","uncategorized|category":"Uncategorized"},"condition":{"post_type":["post"],"select_post_by":"term_selected"}},{"name":"source_portfolio","label":"Select Term","description":"Get all when no term selected","type":"select2","multiple":true,"options":{"abstract|portfolio-category":"Abstract","architecture-design|portfolio-category":"Architecture Design","clean-architecture|portfolio-category":"Clean Architecture","food|portfolio-category":"Food","mockup|portfolio-category":"Mockup","office|portfolio-category":"Office","technology|portfolio-category":"Technology"},"condition":{"post_type":["portfolio"],"select_post_by":"term_selected"}},{"name":"source_post_post_ids","label":"Select posts","type":"select2","multiple":true,"options":{"1420":"We incorporate our values","1432":"Beautiful Modern Architecture Building","6061":"Studios Wins Competition to Design Campus","1434":"A Taller, Wider Door Solution","6055":"Convenience for your home","1436":"This school was a part of a complete renovation.","1438":"Soundproof ceiling panels, custom design acoustic panels.","6058":"Architects - Spit The Bone","1440":"Interior Decoration of the House Room","1442":"A Complete Guide To All The Types Of Furniture Styles","1444":"Specialists of the company took part in the program SMART Partner Industry","1446":"Luxury Family Home Transformation for Kitchen Appliance Packages","1448":"Architecture viverra tristique justo","6063":"The project is a foreign contractor","1450":"Interior Design Interior Bibendum","6051":"Modern spiral staircase for villa","1453":"Urban bibendum eros eget lacus"},"condition":{"post_type":["post"],"select_post_by":"post_selected"}},{"name":"source_portfolio_post_ids","label":"Select posts","type":"select2","multiple":true,"options":{"1310":"Smart Home","1307":"Home Decors","1303":"Crown House","1313":"Student Residence Areosa","1316":"Casa El Maqui","1319":"Industrial Apartment","1322":"Mini Apartment","1325":"House Decor","1328":"Frek Int\u00e9rieurs","1331":"Orin Archit\u00e9cture","1334":"Rob Villa","1337":"Century Circuit"},"condition":{"post_type":["portfolio"],"select_post_by":"post_selected"}},{"name":"source_post_post_ids_unselected","label":"Unselected posts","type":"select2","multiple":true,"options":{"1420":"We incorporate our values","1432":"Beautiful Modern Architecture Building","6061":"Studios Wins Competition to Design Campus","1434":"A Taller, Wider Door Solution","6055":"Convenience for your home","1436":"This school was a part of a complete renovation.","1438":"Soundproof ceiling panels, custom design acoustic panels.","6058":"Architects - Spit The Bone","1440":"Interior Decoration of the House Room","1442":"A Complete Guide To All The Types Of Furniture Styles","1444":"Specialists of the company took part in the program SMART Partner Industry","1446":"Luxury Family Home Transformation for Kitchen Appliance Packages","1448":"Architecture viverra tristique justo","6063":"The project is a foreign contractor","1450":"Interior Design Interior Bibendum","6051":"Modern spiral staircase for villa","1453":"Urban bibendum eros eget lacus"},"condition":{"post_type":["post"],"select_post_by":"term_selected"}},{"name":"source_portfolio_post_ids_unselected","label":"Unselected posts","type":"select2","multiple":true,"options":{"1310":"Smart Home","1307":"Home Decors","1303":"Crown House","1313":"Student Residence Areosa","1316":"Casa El Maqui","1319":"Industrial Apartment","1322":"Mini Apartment","1325":"House Decor","1328":"Frek Int\u00e9rieurs","1331":"Orin Archit\u00e9cture","1334":"Rob Villa","1337":"Century Circuit"},"condition":{"post_type":["portfolio"],"select_post_by":"term_selected"}},{"name":"orderby","label":"Order By","type":"select","default":"date","options":{"date":"Date","ID":"ID","author":"Author","title":"Title","rand":"Random"}},{"name":"order","label":"Sort Order","type":"select","default":"desc","options":{"desc":"Descending","asc":"Ascending"}},{"name":"limit","label":"Total items","type":"number","default":"8","condition":{"select_post_by":"term_selected"}}]},{"name":"general_section","label":"General Settings","tab":"content","controls":[{"name":"img_size","label":"Image Size","type":"text","description":"Enter image size (Example: &quot;thumbnail&quot;, &quot;medium&quot;, &quot;large&quot;, &quot;full&quot; or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height))."},{"name":"layout_mode","label":"Layout Mode","type":"select","options":{"fitRows":"Basic Grid","masonry":"Masonry Grid"},"default":"fitRows"},{"name":"filter","label":"Term Filter","type":"select","default":"false","options":{"true":"Enable","false":"Disable"},"condition":{"select_post_by":"term_selected"}},{"name":"filter_default_title","label":"Filter Default Title","type":"text","default":"All","condition":{"select_post_by":"term_selected","filter":"true"}},{"name":"filter_alignment","label":"Filter Alignment","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"end":{"title":"End","icon":"eicon-text-align-right"}},"selectors":{"{{WRAPPER}} .grid-filter-wrap":"justify-content: {{VALUE}};"},"default":"center","condition":{"select_post_by":"term_selected","filter":"true"}},{"name":"pagination_type","label":"Pagination Type","type":"select","default":"false","options":{"pagination":"Pagination","loadmore":"Loadmore","false":"Disable"}},{"name":"loadmore_text","label":"Load More text","type":"text","default":"Load More","condition":{"pagination_type":"loadmore"}},{"name":"loadmore_icon","label":"Loadmore Icon","type":"icons","default":[],"condition":{"pagination_type":"loadmore"}},{"name":"icon_align","label":"Icon Position","type":"select","default":"right","options":{"right":"After","left":"Before"},"condition":{"pagination_type":"loadmore"}},{"name":"pagination_alignment","label":"Pagination Alignment","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"end":{"title":"End","icon":"eicon-text-align-right"}},"selectors":{"{{WRAPPER}} .pxl-grid-pagination, {{WRAPPER}} .pxl-load-more":"justify-content: {{VALUE}};"},"default":"center","condition":{"pagination_type":["pagination","loadmore"]}},{"name":"item_padding","label":"Item Padding","type":"dimensions","size_units":["px"],"default":{"top":"15","right":"15","bottom":"15","left":"15"},"selectors":{"{{WRAPPER}} .pxl-grid-inner":"margin-top: -{{TOP}}{{UNIT}}; margin-right: -{{RIGHT}}{{UNIT}}; margin-bottom: -{{BOTTOM}}{{UNIT}}; margin-left: -{{LEFT}}{{UNIT}};","{{WRAPPER}} .pxl-grid-inner .grid-item":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive"},{"name":"gap_extra","label":"Item Gap Bottom","description":"Add extra space at bottom of each items","type":"number","default":0,"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-grid-inner .grid-item":"margin-bottom: {{VALUE}}px;"}},{"name":"item_animation","label":"Item Motion Effect","type":"animation","condition":[]},{"name":"item_animation_duration","label":"Item Animation Duration","type":"select","default":"normal","options":{"slow":"Slow","normal":"Normal","fast":"Fast"},"condition":{"item_animation!":""}},{"name":"item_animation_delay","label":"Item Animation Delay","type":"number","min":0,"step":100,"condition":{"item_animation!":""}}]},{"name":"grid_section","label":"Grid Settings","tab":"content","controls":[{"name":"col_xs","label":"Extra Small &lt;= 575","type":"select","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1","1.5":"2\/3","":"Default Layout"}},{"name":"col_sm","label":"Small &lt;= 767","type":"select","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1","1.5":"2\/3","":"Default Layout"}},{"name":"col_md","label":"Medium &lt;= 991","type":"select","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1","1.5":"2\/3","":"Default Layout"}},{"name":"col_lg","label":"Large &lt;= 1199","type":"select","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1","1.5":"2\/3","":"Default Layout"}},{"name":"col_xl","label":"XL Devices &gt;= 1200","type":"select","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1","1.5":"2\/3","":"Default Layout"}},{"name":"col_xxl","label":"XXL Devices &gt;= 1400","type":"select","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1","1.5":"2\/3","":"Default Layout"}},{"name":"grid_custom_columns","label":"Custom Items Columns","type":"repeater","condition":{"layout_mode":["masonry"]},"controls":[{"name":"col_xs_c","label":"Extra Small &lt;= 575","type":"select","default":"1","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1","1.5":"2\/3"}},{"name":"col_sm_c","label":"Small &lt;= 767","type":"select","default":"2","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1","1.5":"2\/3"}},{"name":"col_md_c","label":"Medium &lt;= 991","type":"select","default":"2","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1","1.5":"2\/3"}},{"name":"col_lg_c","label":"Large &lt;= 1199","type":"select","default":"3","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1","1.5":"2\/3"}},{"name":"col_xl_c","label":"XL Devices &gt;= 1200","type":"select","default":"4","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1","1.5":"2\/3"}},{"name":"col_xxl_c","label":"XXL Devices &gt;= 1400","type":"select","default":"5","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1","1.5":"2\/3"}},{"name":"img_size_c","label":"Image Size","type":"text","description":"Enter image size (Example: &quot;thumbnail&quot;, &quot;medium&quot;, &quot;large&quot;, &quot;full&quot; or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height))."},{"name":"item_c_animation","label":"Item Motion Effect","type":"animation","condition":[]},{"name":"item_c_animation_duration","label":"Item Animation Duration","type":"select","default":"normal","options":{"slow":"Slow","normal":"Normal","fast":"Fast"},"condition":{"item_c_animation!":""}},{"name":"item_c_animation_delay","label":"Item Animation Delay","type":"number","min":0,"step":100,"condition":{"item_c_animation!":""}}]}]},{"name":"display_section","label":"Display Options","tab":"content","controls":[{"name":"show_author","label":"Show Author","type":"switcher","default":"false","condition":{"post_type":"post"}},{"name":"show_date","label":"Show Date","type":"switcher","default":"true","condition":{"post_type":"post"}},{"name":"show_category","label":"Show Category","type":"switcher","default":"true","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"}]},{"terms":[{"name":"post_type","operator":"==","value":"portfolio"},{"name":"layout_portfolio","operator":"in","value":["portfolio-1","portfolio-2"]}]}]}},{"name":"show_excerpt","label":"Show Excerpt","type":"switcher","default":"true","condition":{"post_type":"post"}},{"name":"num_words","label":"Number of Words","type":"number","default":25,"condition":{"post_type":"post","show_excerpt":"true"}},{"name":"show_button","label":"Show Button Readmore","type":"switcher","default":"true","condition":{"post_type":"post"}},{"name":"button_text","label":"Button Text","type":"text","condition":{"post_type":"post","show_button":"true","layout_post":["post-1","post-3"]}}]},{"name":"style_section","label":"Style Options","tab":"content","controls":[{"name":"content_typography","label":"Content Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-post-grid .item-content"},{"name":"meta_color","label":"Meta Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post-grid .item-post-meta":"color: {{VALUE}};","{{WRAPPER}} .pxl-post-grid .item-post-meta .meta-inner > * + *:before":"background-color: {{VALUE}};"},"condition":{"post_type":"post","layout_post":["post-1","post-2"]}},{"name":"title_color","label":"Title Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post-grid .item-title":"color: {{VALUE}};"},"condition":{"post_type":"post","layout_post":["post-1","post-2"]}},{"name":"title_typography","label":"Title Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-post-grid .item-title, {{WRAPPER}} .pxl-post-grid .item-post-meta .number"},{"name":"excerpt_color","label":"Excerpt Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post-grid .item-excerpt":"color: {{VALUE}};"},"condition":{"post_type":"post","layout_post":["post-2"]}},{"name":"img_bg_hover","label":"Background hover","type":"color","selectors":{"{{WRAPPER}} .pxl-post-grid .item-featured .pxl-overlay":"background-color: {{VALUE}};"},"condition":{"post_type":"post","layout_post":["post-1"]}},{"name":"img_bg_overlay","label":"Background Overlay","type":"color","selectors":{"{{WRAPPER}} .pxl-post-grid .item-featured:before":"background-color: {{VALUE}};"},"condition":{"post_type":"post","layout_post":["post-2"]}},{"name":"content_bg_hover","label":"Background hover","type":"color","selectors":{"{{WRAPPER}} .pxl-post-grid .item-content-hover":"background-color: {{VALUE}};"},"condition":{"post_type":"post","layout_post":["post-1"]}},{"name":"meta_hover_color","label":"Meta Hover Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post-grid .item-content-hover .item-post-meta":"color: {{VALUE}};","{{WRAPPER}} .pxl-post-grid .item-content-hover .item-post-meta .meta-inner > * + *:before":"background-color: {{VALUE}};"},"condition":{"post_type":"post","layout_post":["post-1"]}},{"name":"excerpt_hover_color","label":"Excerpt Hover Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post-grid .item-content-hover .item-excerpt":"color: {{VALUE}};"},"condition":{"post_type":"post","layout_post":["post-1"]}},{"name":"css_filters","label":"CSS Filters","type":"css-filter","control_type":"group","selector":"{{WRAPPER}} .pxl-post-grid .item-featured img","condition":{"post_type":"post","layout_post":["post-1"]}}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'imagesloaded','isotope','adsett-post-grid' );
}