<?php

class PxlImage_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_image';
    protected $title = 'PXL Image';
    protected $icon = 'eicon-image';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"content_section","label":"Image","tab":"content","controls":[{"name":"image","label":"Choose Image","type":"media","dynamic":{"active":true},"default":{"url":"https:\/\/demo.casethemes.net\/adsett\/wp-content\/plugins\/elementor\/assets\/images\/placeholder.png"}},{"name":"image","label":"Image Size","type":"image-size","control_type":"group","default":"full"},{"name":"align","label":"Alignment","type":"choose","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"}},"control_type":"responsive","selectors":{"{{WRAPPER}}":"text-align: {{VALUE}};"}},{"name":"link_to","label":"Link","type":"select","default":"none","options":{"none":"None","file":"Media File","custom":"Custom URL"}},{"name":"link","label":"Link","type":"url","dynamic":{"active":true},"placeholder":"https:\/\/your-link.com","condition":{"link_to":"custom"},"show_label":false},{"name":"open_lightbox","label":"Lightbox","type":"select","default":"default","options":{"default":"Default","yes":"Yes","no":"No"},"condition":{"link_to":"file"}}]},{"name":"parallax_section","label":"Parallax Settings","tab":"content","controls":[{"name":"pxl_parallax","label":"Parallax Type","type":"select","options":{"":"None","x":"Transform X","y":"Transform Y","z":"Transform Z","rotateX":"RotateX","rotateY":"RotateY","rotateZ":"RotateZ","scaleX":"ScaleX","scaleY":"ScaleY","scaleZ":"ScaleZ","scale":"Scale"}},{"name":"parallax_value","label":"Value","type":"text","default":"","condition":{"pxl_parallax!":""}},{"name":"pxl_parallax_screen","label":"Parallax In Screen","type":"select","control_type":"responsive","default":"","options":{"":"Default","no":"No"},"prefix_class":"pxl-parallax%s-","condition":{"pxl_parallax!":""}}]},{"name":"bg_parallax_section","label":"Background Parallax","tab":"content","controls":[{"name":"pxl_bg_parallax","label":"Background Parallax Type","type":"select","options":{"":"None","basic":"Basic","rotate":"Rotate","mouse-move":"Mouse Move","mouse-move-rotate":"Mouse Move Rotate"}},{"name":"bg_parallax_width","label":"Background Width","type":"slider","control_type":"responsive","default":{"unit":"%"},"tablet_default":{"unit":"%"},"mobile_default":{"unit":"%"},"size_units":["%","px","vw"],"range":{"%":{"min":1,"max":100},"px":{"min":1,"max":1920},"vw":{"min":1,"max":100}},"selectors":{"{{WRAPPER}} .pxl-image-wg":"width: {{SIZE}}{{UNIT}};"},"condition":{"pxl_bg_parallax!":""}},{"name":"bg_parallax_height","label":"Background Height","type":"slider","control_type":"responsive","default":{"unit":"px"},"tablet_default":{"unit":"px"},"mobile_default":{"unit":"px"},"size_units":["px","vh"],"range":{"px":{"min":1,"max":1000},"vh":{"min":1,"max":100}},"selectors":{"{{WRAPPER}} .pxl-image-wg":"height: {{SIZE}}{{UNIT}};"},"condition":{"pxl_bg_parallax!":""}}]},{"name":"style_section","label":"Style","tab":"style","controls":[{"name":"width","label":"Width","type":"slider","control_type":"responsive","default":{"unit":"%"},"tablet_default":{"unit":"%"},"mobile_default":{"unit":"%"},"size_units":["%","px","vw"],"range":{"%":{"min":1,"max":100},"px":{"min":1,"max":1000},"vw":{"min":1,"max":100}},"selectors":{"{{WRAPPER}} img":"width: {{SIZE}}{{UNIT}};"}},{"name":"space","label":"Max Width","type":"slider","control_type":"responsive","default":{"unit":"%"},"tablet_default":{"unit":"%"},"mobile_default":{"unit":"%"},"size_units":["%","px","vw"],"range":{"%":{"min":1,"max":100},"px":{"min":1,"max":1000},"vw":{"min":1,"max":100}},"selectors":{"{{WRAPPER}} img":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"height","label":"Height","type":"slider","control_type":"responsive","default":{"unit":"px"},"tablet_default":{"unit":"px"},"mobile_default":{"unit":"px"},"size_units":["px","vh"],"range":{"px":{"min":1,"max":1000},"vh":{"min":1,"max":100}},"selectors":{"{{WRAPPER}} img":"height: {{SIZE}}{{UNIT}};"}},{"name":"object-fit","label":"Object Fit","type":"select","control_type":"responsive","condition":{"height[size]!":""},"options":{"":"Default","fill":"Fill","cover":"Cover","contain":"Contain"},"default":"","selectors":{"{{WRAPPER}} img":"object-fit: {{VALUE}};"}},{"name":"separator_panel_style","type":"divider","style":"thick"},{"name":"image_effects","control_type":"tab","tabs":[{"name":"normal","label":"Normal","type":"tab","controls":[{"name":"opacity","label":"Opacity","type":"slider","range":{"px":{"max":1,"min":0.1000000000000000055511151231257827021181583404541015625,"step":0.01000000000000000020816681711721685132943093776702880859375}},"selectors":{"{{WRAPPER}} img":"opacity: {{SIZE}};"}},{"name":"css_filters","label":"CSS Filters","type":"css-filter","control_type":"group","selector":"{{WRAPPER}} img"}]},{"name":"hover","label":"Hover","type":"tab","controls":[{"name":"opacity_hover","label":"Opacity Hover","type":"slider","range":{"px":{"max":1,"min":0.1000000000000000055511151231257827021181583404541015625,"step":0.01000000000000000020816681711721685132943093776702880859375}},"selectors":{"{{WRAPPER}}:hover img":"opacity: {{SIZE}};"}},{"name":"css_filters_hover","label":"CSS Filters Hover","type":"css-filter","control_type":"group","selector":"{{WRAPPER}}:hover img"},{"name":"background_hover_transition","label":"Transition Duration","type":"slider","range":{"px":{"max":3,"step":0.1000000000000000055511151231257827021181583404541015625}},"selectors":{"{{WRAPPER}} img":"transition-duration: {{SIZE}}s"}},{"name":"hover_animation","label":"Hover Animation","type":"hover_animation"}]}]},{"name":"image_border","type":"border","control_type":"group","selector":"{{WRAPPER}} img, {{WRAPPER}} .pxl-bg-parallax","separator":"before"},{"name":"image_border_radius","label":"Border Radius","type":"dimensions","control_type":"responsive","size_units":["px","%"],"selectors":{"{{WRAPPER}} img":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};","{{WRAPPER}} .pxl-bg-parallax":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"image_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","exclude":["box_shadow_position"],"selector":"{{WRAPPER}} img"}]},{"name":"custom_style_section","label":"Custom Style","tab":"style","controls":[{"name":"custom_style","label":"Style","type":"select","options":{"":"None","bg-halp":"Background Halp","move-from-left":"Move From Left","move-from-right":"Move From Right","skew-in":"Skew In"}},{"name":"bg_color","label":"Background color","type":"color","selectors":{"{{WRAPPER}} .pxl-image-wg.bg-halp:before":"background-color: {{VALUE}};"},"condition":{"custom_style":"bg-halp"}}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}