<?php

class PxlImageText_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_image_text';
    protected $title = 'PXL Image Text';
    protected $icon = 'eicon-image';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"content_section","label":"Content","tab":"content","controls":[{"name":"image","label":"Image","type":"media"},{"name":"img_size","label":"Image Size","type":"text","description":"Enter image size (Example: &quot;thumbnail&quot;, &quot;medium&quot;, &quot;large&quot;, &quot;full&quot; or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height))."},{"name":"img_max_width","label":"Image Max Width","type":"slider","description":"Enter number.","range":{"px":{"min":0,"max":1000}},"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-img-text img":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"text_max_width","label":"Text Max Width","type":"slider","description":"Enter number.","range":{"px":{"min":0,"max":1500}},"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-img-text .title-outer,{{WRAPPER}} .pxl-img-text .title-inner":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"img_align","label":"Alignment","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"end":{"title":"End","icon":"eicon-text-align-right"}},"selectors":{"{{WRAPPER}} .pxl-img-text":"text-align: {{VALUE}};"}},{"name":"title","label":"Title","type":"textarea"},{"name":"text_position","label":"Text  Position","type":"select","control_type":"responsive","default":"","options":{"relative":"Default","absolute":"Absolute"},"selectors":{"{{WRAPPER}} .pxl-img-text .title-outer, {{WRAPPER}} .pxl-img-text .title-inner":"position: {{VALUE}}"},"frontend_available":true,"condition":[]},{"name":"text_pos_offset_left","label":"Left (50px) px,%,vw,auto","type":"text","default":"","control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-img-text .title-outer, {{WRAPPER}} .pxl-img-text .title-inner":"left: {{VALUE}}"},"condition":{"text_position!":""}},{"name":"text_pos_offset_right","label":"Right (50px) px,%,vw,auto","type":"text","default":"","control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-img-text .title-outer, {{WRAPPER}} .pxl-img-text .title-inner":"right: {{VALUE}}"},"condition":{"text_position!":""}},{"name":"text_pos_offset_top","label":"Top (50px) px,%,vh,auto","type":"text","default":"","control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-img-text .title-outer, {{WRAPPER}} .pxl-img-text .title-inner":"top: {{VALUE}}"},"condition":{"text_position!":""}},{"name":"text_pos_offset_bottom","label":"Bottom (50px) px,%,vh,auto","type":"text","default":"","control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-img-text .title-outer, {{WRAPPER}} .pxl-img-text .title-inner":"bottom: {{VALUE}}"},"condition":{"text_position!":""}},{"name":"text_z_index","label":"Text  Z-Index","type":"number","selectors":{"{{WRAPPER}} .pxl-img-text .title-outer, {{WRAPPER}} .pxl-img-text .title-inner":"z-index: {{VALUE}};"},"condition":{"text_position!":""}}]},{"name":"style_section","label":"Style","tab":"style","controls":[{"name":"title_outer_color","label":"Title Outer Color","type":"color","control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-img-text .title-outer":"color: {{VALUE}};"}},{"name":"title_inner_color","label":"Title Inner Color","type":"color","control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-img-text .title-inner":"color: {{VALUE}};"}},{"name":"title_outer_color_typography","label":"Title Outer Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-img-text .title-outer,{{WRAPPER}} .pxl-img-text .title-inner"}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}