<?php

class PxlHeading_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_heading';
    protected $title = 'PXL Heading';
    protected $icon = 'eicon-t-letter';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"layout_section","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Layout","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/demo.casethemes.net\/adsett\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/heading-1.jpg"},"2":{"label":"Layout 2","image":"https:\/\/demo.casethemes.net\/adsett\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/heading-2.jpg"}}}]},{"name":"subtitle_section","label":"Sub Title","tab":"content","controls":[{"name":"sub_title","label":"Sub Title","type":"textarea","label_block":true},{"name":"sub_title_on_bottom","label":"On Bottom","type":"switcher","default":"false"}]},{"name":"title_section","label":"Title","tab":"content","controls":[{"name":"title","label":"Title","type":"textarea","default":"Fine Architect to Build","label_block":true},{"name":"title_tag","label":"Heading HTML Tag","type":"select","options":{"h1":"H1","h2":"H2","h3":"H3","h4":"H4","h5":"H5","h6":"H6","div":"div","span":"span","p":"p"},"default":"h3"}]},{"name":"general_style_section","label":"General Style","tab":"style","controls":[{"name":"text_align","label":"Alignment","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"end":{"title":"End","icon":"eicon-text-align-right"}},"selectors":{"{{WRAPPER}} .pxl-heading-wrap":"justify-content: {{VALUE}};","{{WRAPPER}} .pxl-heading-inner":"text-align: {{VALUE}};"}},{"name":"max_width","label":"Max Width","type":"slider","control_type":"responsive","range":{"px":{"min":100,"max":1920}},"selectors":{"{{WRAPPER}} .pxl-heading-inner":"max-width: {{SIZE}}{{UNIT}};"}}]},{"name":"title_style_section","label":"Title Style","tab":"style","controls":[{"name":"title_color","label":"Title Color","type":"color","control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-heading-wrap .heading-title":"color: {{VALUE}};"}},{"name":"title_typography","label":"Title Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-heading-wrap .heading-title"},{"name":"space_bottom","label":"Bottom Space (px)","type":"slider","description":"Enter number.","size_units":["px"],"range":{"px":{"min":0,"max":500}},"default":{"unit":"px"},"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-heading-wrap .heading-title":"margin-bottom: {{SIZE}}{{UNIT}};"}},{"name":"title_split_text_anm","label":"Split Text Animation","type":"select","options":{"":"None","split-in-fade":"In Fade","split-in-right":"In Right","split-in-left":"In Left","split-in-up":"In Up","split-in-down":"In Down","split-in-rotate":"In Rotate","split-in-scale":"In Scale"},"default":""},{"name":"title_animation","label":" Motion Effect","type":"animation","condition":[]},{"name":"title_animation_duration","label":" Animation Duration","type":"select","default":"normal","options":{"slow":"Slow","normal":"Normal","fast":"Fast"},"condition":{"title_animation!":""}},{"name":"title_animation_delay","label":" Animation Delay","type":"number","min":0,"step":100,"condition":{"title_animation!":""}}]},{"name":"subtitle_style_section","label":"Sub Title Style","tab":"style","controls":[{"name":"sub_title_color","label":"Sub Title Color","type":"color","control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-heading-wrap .heading-subtitle":"color: {{VALUE}};","{{WRAPPER}} .pxl-heading-wrap .heading-subtitle span:before":"background-color: {{VALUE}};","{{WRAPPER}} .pxl-heading-wrap .heading-subtitle span:after":"background-color: {{VALUE}};"},"separator":"before"},{"name":"sub_title_typography","label":"Sub Title Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-heading-wrap .heading-subtitle"},{"name":"sub_title_space","label":"Bottom Space","type":"slider","control_type":"responsive","range":{"px":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-heading-wrap .heading-subtitle":"margin-bottom: {{SIZE}}{{UNIT}};"}},{"name":"subtitle_split_text_anm","label":"Split Text Animation","type":"select","options":{"":"None","split-in-fade":"In Fade","split-in-right":"In Right","split-in-left":"In Left","split-in-up":"In Up","split-in-down":"In Down","split-in-rotate":"In Rotate","split-in-scale":"In Scale"},"default":""},{"name":"sub_title_animation","label":" Motion Effect","type":"animation","condition":[]},{"name":"sub_title_animation_duration","label":" Animation Duration","type":"select","default":"normal","options":{"slow":"Slow","normal":"Normal","fast":"Fast"},"condition":{"sub_title_animation!":""}},{"name":"sub_title_animation_delay","label":" Animation Delay","type":"number","min":0,"step":100,"condition":{"sub_title_animation!":""}}]},{"name":"border_style_section","label":"Border","tab":"style","controls":[{"name":"hd_border","label":"Border","type":"select","options":{"":"None","bd-left":"Border Left","bd-right":"Border Right"},"prefix_class":"pxl-hd-"},{"name":"bd_width","label":"Border Width (px)","type":"slider","control_type":"responsive","range":{"px":{"min":1,"max":100}},"selectors":{"{{WRAPPER}}.pxl-hd-bd-left .elementor-widget-container:before, {{WRAPPER}}.pxl-hd-bd-right .elementor-widget-container:before":"width: {{SIZE}}{{UNIT}};","{{WRAPPER}}.pxl-hd-bd-left .pxl-heading-wrap":"padding-left: calc({{SIZE}}{{UNIT}} + 20px);","{{WRAPPER}}.pxl-hd-bd-right .pxl-heading-wrap":"padding-right: calc({{SIZE}}{{UNIT}} + 20px);"}},{"name":"border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}}.pxl-hd-bd-left .elementor-widget-container:before, {{WRAPPER}}.pxl-hd-bd-right .elementor-widget-container:before":"background-color: {{VALUE}};"}}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'pxl-splitText' );
}