<?php

class PxlVideo_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_video';
    protected $title = 'PXL Video';
    protected $icon = 'eicon-play';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"layout_section","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/testingservertwo.xyz\/dubai-homes\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_video-1.jpg"},"2":{"label":"Layout 2","image":"https:\/\/testingservertwo.xyz\/dubai-homes\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_video-2.jpg"}},"prefix_class":"pxl-video-layout-"},{"name":"max_width","label":"Max Width (px)","type":"slider","control_type":"responsive","range":{"px":{"min":100,"max":1920}},"selectors":{"{{WRAPPER}} .pxl-video-player":"max-width: {{SIZE}}{{UNIT}};"},"separator":"before"},{"name":"video_spacing","label":"Padding (px)","type":"dimensions","default":{"top":"","right":"","bottom":"","left":""},"control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-video-player":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"video_section","label":"Video","tab":"content","controls":[{"name":"video_bt_style","label":"Video Button Style","type":"select","options":{"df":"Default","1":"Round Background"},"default":"df","condition":{"layout":"1"}},{"name":"video_link","label":"Video URL","description":"(https:\/\/www.youtube.com\/watch?v=r2YbkyYA9Gc)","type":"url","default":{"url":"","is_external":"on"}},{"name":"video_text","label":"Text","type":"text","default":"See Demo","condition":{"layout":["2"]}},{"name":"video_bg_image","label":"Background Image","type":"media","dynamic":{"active":true},"default":{"url":"https:\/\/testingservertwo.xyz\/dubai-homes\/wp-content\/plugins\/elementor\/assets\/images\/placeholder.png"},"condition":{"layout":["1"]}},{"name":"bg_color","label":"Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-video-player .pxl-overlay":"background-color:{{VALUE}};"}},{"name":"video_play_bg","label":"Video Button Background","type":"color","condition":{"video_link[url]!":""},"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-video-btn":"background-color: {{VALUE}};"}},{"name":"video_play_bg_hover","label":"Video Button Background Hover","type":"color","condition":{"video_link[url]!":""},"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-video-btn:hover":"background-color: {{VALUE}};"}},{"name":"play_icon_color","label":"Play Icon Color","type":"color","condition":{"video_link[url]!":""},"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-video-btn > .pxl-icon":"color: {{VALUE}};"}},{"name":"play_icon_color_hover","label":"Play Icon Color Hover","type":"color","condition":{"video_link[url]!":""},"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-video-btn:hover > .pxl-icon":"color: {{VALUE}};"}},{"name":"video_play_bg_shadow","label":"Shadow Background Hover","type":"color","condition":{"layout":["2"],"video_link[url]!":""},"selectors":{"{{WRAPPER}} .pxl-video-player.layout-2 .pxl-video-btn:hover":"-webkit-box-shadow: 0 0 0 10px {{VALUE}}; box-shadow: 0 0 0 10px {{VALUE}};"}},{"name":"video_animation","label":"Button Video Effect","type":"animation","condition":{"video_link[url]!":""}},{"name":"video_animation_duration","label":"Animation Duration","type":"select","default":"normal","options":{"slow":"Slow","normal":"Normal","fast":"Fast"},"condition":{"video_link[url]!":"","video_animation!":""}},{"name":"video_animation_delay","label":"Animation Delay","type":"number","min":0,"step":100,"condition":{"video_link[url]!":"","video_animation!":""}}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}