<?php

class PxlQuickcontact_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_quickcontact';
    protected $title = 'PXL Quick Contact';
    protected $icon = 'eicon-mail';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"layout_section","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/testingservertwo.xyz\/dubai-homes\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_quickcontact-1.jpg"},"2":{"label":"Layout 2","image":"https:\/\/testingservertwo.xyz\/dubai-homes\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_quickcontact-2.jpg"}},"prefix_class":"pxl-quick-contact-layout-"}]},{"name":"content_section","label":"Content Settings","tab":"content","controls":[{"name":"title","label":"Title","type":"text","placeholder":"Enter the title:","default":"Call us:","label_block":true,"condition":{"layout":"1"}},{"name":"contact_list","label":"Contact Lists","type":"repeater","controls":[{"name":"pxl_icon","label":"Icon (layout 2)","type":"icons","fa4compatibility":"icon","default":{"value":"pxli pxli-marker-alt","library":"pxli-icon"}},{"name":"item_content","label":"Item Content","type":"textarea","placeholder":"Enter item Content","default":"59 Main Street, USA","label_block":true}],"default":[{"pxl_icon":{"value":"pxli pxli-phone-alt1","library":"pxli-icon"},"item_content":"+012 (345) 56 998"},{"pxl_icon":{"value":"pxli pxli-envelope-regular","library":"pxli-icon"},"item_content":"support@gmail.com"},{"pxl_icon":{"value":"pxli pxli-marker-alt","library":"pxli-icon"},"item_content":"59 Main Street, USA"}]}]},{"name":"qc_style","label":"Style","tab":"style","controls":[{"name":"qc_align","label":"Alignment","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"end":{"title":"End","icon":"eicon-text-align-right"}},"selectors":{"{{WRAPPER}} .pxl-qc-wrap":"justify-content: {{VALUE}};"}},{"name":"item_text_color","label":"Content item Color","type":"color","selectors":{"{{WRAPPER}} .qc-content-wrap":"color: {{VALUE}};"}},{"name":"item_link_color","label":"Item Link Color","type":"color","selectors":{"{{WRAPPER}} .qc-content-wrap a":"color: {{VALUE}};"}},{"name":"item_link_color_hover","label":"Item Link Color Hover","type":"color","selectors":{"{{WRAPPER}} .qc-content-wrap a:hover":"color: {{VALUE}};"}},{"name":"item_icon_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .qc-content-wrap .pxl-icon":"color: {{VALUE}};","{{WRAPPER}} .qc-content-wrap svg path":"fill: {{VALUE}};"}},{"name":"item_typography","label":"Item text Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .qc-content-wrap"},{"name":"icon_size","label":"Icon Size (px)","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":50}},"selectors":{"{{WRAPPER}} .pxl-qc-wrap .qc-item .pxl-icon":"font-size: {{SIZE}}{{UNIT}};","{{WRAPPER}} .pxl-qc-wrap .qc-item svg":"width: {{SIZE}}{{UNIT}};"}},{"name":"icon_space","label":"Icon Space(px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-qc-wrap .qc-item .pxl-icon":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"item_spacing","label":"Item Space (px)","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .qc-content-wrap .qc-item + .qc-item":"margin-top: {{SIZE}}{{UNIT}};"}},{"name":"item_animation","label":"Item Motion Effect","type":"animation","condition":[]},{"name":"item_animation_duration","label":"Item Animation Duration","type":"select","default":"normal","options":{"slow":"Slow","normal":"Normal","fast":"Fast"},"condition":{"item_animation!":""}},{"name":"item_animation_delay","label":"Item Animation Delay","type":"number","min":0,"step":100,"condition":{"item_animation!":""}}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}