<?php

class PxlProgressbar_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_progressbar';
    protected $title = 'PXL Progress Bar';
    protected $icon = 'eicon-skill-bar';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"layout_section","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/testingservertwo.xyz\/dubai-homes\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_progressbar-1.jpg"},"2":{"label":"Layout 2","image":"https:\/\/testingservertwo.xyz\/dubai-homes\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_progressbar-2.jpg"},"3":{"label":"Layout 3","image":"https:\/\/testingservertwo.xyz\/dubai-homes\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_progressbar-3.jpg"},"4":{"label":"Layout 4","image":"https:\/\/testingservertwo.xyz\/dubai-homes\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_progressbar-4.jpg"}},"prefix_class":"pxl-progressbar-layout-"}]},{"name":"source_section","label":"Source Settings","tab":"content","controls":[{"name":"progressbar_list","label":"Progress Bar Lists","type":"repeater","controls":[{"name":"title","label":"Title","type":"text","placeholder":"Enter your title","default":"My Skill","label_block":true},{"name":"percent","label":"Percentage","type":"slider","default":{"size":50,"unit":"%"},"label_block":true},{"name":"item_bar_color","label":"Bar Background Color","type":"color","selectors":{"{{WRAPPER}} {{CURRENT_ITEM}} .pxl-progress-bar":"background-color: {{VALUE}}"}}],"condition":{"layout":["1","2","3"]},"title_field":"{{title}}"},{"name":"circle_size","label":"Size","type":"slider","control_type":"responsive","range":{"px":{"min":50,"max":500,"step":1}},"default":{"size":200},"selectors":{"{{WRAPPER}} .pxl-progressbar-inner":"width: {{SIZE}}px; height: {{SIZE}}px"},"condition":{"layout":"4"}},{"name":"circle_percent","label":"Percentage","type":"slider","default":{"size":50,"unit":"%"},"label_block":true,"condition":{"layout":"4"}},{"name":"circle_speed","label":"Speed (milliseconds)","type":"number","condition":{"layout":"4"}},{"name":"circle_title","label":"Title","type":"text","placeholder":"Enter your title","default":"Page Speed","label_block":true,"condition":{"layout":"4"}},{"name":"circle_number","label":"Number Value","type":"number","default":50,"condition":{"layout":"4"}},{"name":"prefix","label":"Number Prefix","type":"text","default":"","condition":{"layout":"4"}},{"name":"suffix","label":"Number Suffix","type":"text","default":"","condition":{"layout":"4"}}]},{"name":"section_title","label":"Style","tab":"style","controls":[{"name":"title_color","label":"Title Color","type":"color","selectors":{"{{WRAPPER}} .pxl-progressbar .progress-title":"color: {{VALUE}};"}},{"name":"typography","label":"Title Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-progressbar .progress-title"},{"name":"percent_color","label":"Percentage Color","type":"color","selectors":{"{{WRAPPER}} .pxl-progressbar .progress-percentage":"color: {{VALUE}};"}},{"name":"percentage_typography","label":"Percentage Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-progressbar .progress-percentage"},{"name":"bound_color","label":"Bound Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-progressbar .progress-bound":"background-color: {{VALUE}};","{{WRAPPER}} .pxl-progressbar-circle-base":"border-color: {{VALUE}};"}},{"name":"bar_color","label":"Bar Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-progressbar .pxl-progress-bar":"background-color: {{VALUE}};","{{WRAPPER}} .pxl-progressbar-circle div":"border-color: {{VALUE}};"}},{"name":"space_bottom","label":"Item Bottom Space (px)","type":"slider","description":"Enter number.","size_units":["px"],"range":{"px":{"min":0,"max":500}},"default":{"unit":"px"},"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-progressbar .progress-item + .progress-item":"margin-top: {{SIZE}}{{UNIT}};"},"condition":{"layout":["1","2","3"]}},{"name":"item_animation","label":"Item Motion Effect","type":"animation","condition":{"layout":["1","2","3"]}},{"name":"item_animation_duration","label":"Item Animation Duration","type":"select","default":"normal","options":{"slow":"Slow","normal":"Normal","fast":"Fast"},"condition":{"layout":["1","2","3"],"item_animation!":""}},{"name":"item_animation_delay","label":"Item Animation Delay","type":"number","min":0,"step":100,"condition":{"layout":["1","2","3"],"item_animation!":""}}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'pxl-progressbar','adsett-progressbar' );
}