<?php

class PxlCounter_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_counter';
    protected $title = 'PXL Counter';
    protected $icon = 'eicon-counter-circle';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"layout_section","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/testingservertwo.xyz\/dubai-homes\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_counter-1.jpg"},"2":{"label":"Layout 2","image":"https:\/\/testingservertwo.xyz\/dubai-homes\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_counter-2.jpg"},"3":{"label":"Layout 3","image":"https:\/\/testingservertwo.xyz\/dubai-homes\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_counter-3.jpg"},"4":{"label":"Layout 4","image":"https:\/\/testingservertwo.xyz\/dubai-homes\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_counter-4.jpg"},"5":{"label":"Layout 5","image":"https:\/\/testingservertwo.xyz\/dubai-homes\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_counter-5.jpg"}},"separator":"after","prefix_class":"pxl-counter-layout"}]},{"name":"section_counter","label":"Counter","tab":"content","controls":[{"name":"starting_number","label":"Starting Number","type":"number","default":1},{"name":"ending_number","label":"Ending Number","type":"number","default":100},{"name":"prefix","label":"Number Prefix","type":"text","default":""},{"name":"suffix","label":"Number Suffix","type":"text","default":""},{"name":"duration","label":"Animation Duration","type":"number","default":2000,"min":100,"step":100,"selectors":{"{{WRAPPER}} .odometer-ribbon-inner":"transition-duration: {{VALUE}}ms !important;"}},{"name":"thousand_separator","label":"Thousand Separator","type":"switcher","default":"false"},{"name":"thousand_separator_char","label":"Separator","type":"select","condition":{"thousand_separator":"true"},"options":{"":"Default","(.ddd),dd":"Dot","(,ddd).dd":"Comma","(\u202fddd),dd":"Space"},"default":""},{"name":"title","label":"Title","type":"text","label_block":true}]},{"name":"section_general","label":"General","tab":"style","controls":[{"name":"align","label":"Alignment","type":"choose","control_type":"responsive","default":"","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"}},"selectors":{"{{WRAPPER}} .pxl-counter":"text-align: {{VALUE}};","{{WRAPPER}} .counter-number":"justify-content: {{VALUE}};"}},{"name":"border_bottom","label":"Border Bottom","type":"switcher","default":"true","condition":{"layout":["1","3"]}},{"name":"width","label":"Width (px)","type":"slider","control_type":"responsive","range":{"px":{"min":100,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-counter.layout4 .counter-content":"width: {{SIZE}}{{UNIT}};"},"condition":{"layout":["4"]}}]},{"name":"section_number","label":"Number","tab":"style","controls":[{"name":"number_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .counter-number":"color: {{VALUE}};"}},{"name":"number_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .counter-number"}]},{"name":"section_title","label":"Title","tab":"style","controls":[{"name":"title_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .counter-title":"color: {{VALUE}};"}},{"name":"typography_title","type":"typography","control_type":"group","selector":"{{WRAPPER}} .counter-title"},{"name":"title_top_space","label":"Top Spacing","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .counter-title":"margin-top: {{SIZE}}{{UNIT}};"}}]},{"name":"suffix_title","label":"Suffix","tab":"style","controls":[{"name":"suffix_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .counter-number-suffix":"color: {{VALUE}} !important;"}},{"name":"typography_suffix","type":"typography","control_type":"group","selector":"{{WRAPPER}} .counter-number-suffix"}]},{"name":"border_bottom_section","label":"Border Bottom","tab":"style","controls":[{"name":"border_bottom_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .layout1 .pxl-bd-anm":"border-color: {{VALUE}} !important;","{{WRAPPER}} .layout3 .pxl-bd-anm":"background-color: {{VALUE}} !important;"}},{"name":"border_bottom_hover","label":"Border Color Hover","type":"color","selectors":{"{{WRAPPER}} .layout1.border-bottom-true:after":"background-color: {{VALUE}} !important;","{{WRAPPER}} .layout3 .pxl-bd-anm:after":"background-color: {{VALUE}} !important;"}}],"condition":{"layout":["1","3"],"border_bottom":"true"}}]}';
    protected $styles = array( 'odometer' );
    protected $scripts = array( 'odometter' );
}