<?php

class PxlContactInfo_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_contact_info';
    protected $title = 'PXL Contact Info';
    protected $icon = 'eicon-mail';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"layout_section","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/testingservertwo.xyz\/dubai-homes\/wp-content\/themes\/adsett\/elements\/assets\/imgs\/pxl_contact_info-1.jpg"}},"prefix_class":"pxl-contact-info-layout-"}]},{"name":"content_section","label":"Content Settings","tab":"content","controls":[{"name":"heading_text","label":"Heading","type":"text","placeholder":"Enter Heading","default":"Office address","label_block":true},{"name":"desc","label":"Description","type":"textarea","placeholder":"Enter Description","default":"Level 30 130 Lonsdale Street Melbourne VIC 3000 Australia","label_block":true},{"name":"map_img","label":"Map Image","type":"media"},{"name":"map_iframe","label":"Map Iframe","type":"textarea"},{"name":"image_width","label":"Lightbox Width","type":"slider","control_type":"responsive","range":{"px":{"min":0,"max":800,"step":1}},"default":{"unit":"px","size":320},"selectors":{"{{WRAPPER}} .pxl-map-wrap":"width: {{SIZE}}{{UNIT}};"},"conditions":{"relation":"or","terms":[{"name":"map_img[url]","operator":"!=","value":""},{"name":"map_iframe","operator":"!=","value":""}]}},{"name":"image_height","label":"Lightbox Height","type":"slider","control_type":"responsive","range":{"px":{"min":0,"max":800,"step":1}},"default":{"unit":"px","size":320},"selectors":{"{{WRAPPER}} .pxl-map-wrap":"height: {{SIZE}}{{UNIT}};"},"conditions":{"relation":"or","terms":[{"name":"map_img[url]","operator":"!=","value":""},{"name":"map_iframe","operator":"!=","value":""}]}},{"name":"show_popup","label":"Click Show Popup","type":"switcher","default":"true","conditions":{"relation":"or","terms":[{"name":"map_img[url]","operator":"!=","value":""},{"name":"map_iframe","operator":"!=","value":""}]}},{"name":"css_filters","label":"CSS Map Filters","type":"css-filter","control_type":"group","selector":"{{WRAPPER}} .pxl-map-wrap","conditions":{"relation":"or","terms":[{"name":"map_img[url]","operator":"!=","value":""},{"name":"map_iframe","operator":"!=","value":""}]}}]},{"name":"qc_style","label":"Style","tab":"style","controls":[{"name":"max_width","label":"Max Width","type":"slider","control_type":"responsive","range":{"px":{"min":100,"max":800}},"selectors":{"{{WRAPPER}} .pxl-ci-wrap":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"ci_align","label":"Alignment","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"end":{"title":"End","icon":"eicon-text-align-right"}},"selectors":{"{{WRAPPER}} .pxl-ci-wrap":"text-align: {{VALUE}};"}},{"name":"heading_text_color","label":"Heading Color","type":"color","selectors":{"{{WRAPPER}} .ci-title":"color: {{VALUE}};"}},{"name":"desc_text_color","label":"Content item Color","type":"color","selectors":{"{{WRAPPER}} .ci-desc":"color: {{VALUE}};"}},{"name":"heading_typography","label":"Heading Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .ci-title"},{"name":"desc_typography","label":"Description Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .ci-desc"}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}