<?php

class PxlButton_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_button';
    protected $title = 'PXL Button';
    protected $icon = 'eicon-button';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"source_section","label":"Source Settings","tab":"content","controls":[{"name":"style","label":"Button Style","type":"select","default":"default","options":{"default":"Default","outline-under":"Border outline under","outline-above":"Border outline above","outline-around":"Border outline around"},"condition":[]},{"name":"border_hover_style","label":"Border Hover Style","type":"select","default":"transform","options":{"transform":"Transform","draw":"Draw"},"condition":[]},{"name":"text","label":"Text","type":"text","default":"Click Here","placeholder":"Click here"},{"name":"link","label":"Link","type":"url","placeholder":"https:\/\/your-link.com","default":{"url":"#"}}]},{"name":"icon_section","label":"Icon Settings","tab":"content","controls":[{"name":"btn_icon","label":"Icon","type":"icons","label_block":true,"fa4compatibility":"icon"},{"name":"icon_align","label":"Icon Position","type":"select","default":"right","options":{"right":"After","left":"Before"}},{"name":"icon_space_left","label":"Icon Space Left","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-button-wrapper .pxl-button-icon.pxl-align-icon-left":"margin-right: {{SIZE}}{{UNIT}};"},"condition":{"icon_align":["left"]}},{"name":"icon_space_right","label":"Icon Space Right","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-button-wrapper .pxl-button-icon.pxl-align-icon-right":"margin-left: {{SIZE}}{{UNIT}};"},"condition":{"icon_align":["right"]}},{"name":"icon_font_size","label":"Icon Font Size","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-button-wrapper .pxl-icon":"font-size: {{SIZE}}{{UNIT}};"}}]},{"name":"style_section","label":"Style Settings","tab":"style","controls":[{"name":"text_align","label":"Alignment","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"end":{"title":"End","icon":"eicon-text-align-right"}},"prefix_class":"elementor-align-","default":"","selectors":{"{{WRAPPER}} .pxl-button-wrapper":"justify-content: {{VALUE}};"}},{"name":"btn_padding","label":"Padding","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-button-wrapper .pxl-btn":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive"},{"name":"btn_min_width","label":"Min Width (px)","type":"slider","size_units":["px"],"range":{"px":{"min":50,"max":300}},"selectors":{"{{WRAPPER}} .pxl-btn":"min-width: {{SIZE}}{{UNIT}};"}},{"name":"btn_full","label":"Full Width","type":"choose","options":{"auto":{"title":"Auto","icon":"eicon-justify-center-h"},"100%":{"title":"Full","icon":"eicon-justify-space-between-h"}},"selectors":{"{{WRAPPER}} .pxl-button-wrapper .pxl-btn":"width: {{VALUE}};"}},{"name":"in_dark","label":"Is In Dark?","type":"select","default":"","options":{"":"Default","in-dark":"In Dark"}},{"name":"typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-button-wrapper .pxl-btn"},{"name":"btn_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-button-wrapper .pxl-btn":"color: {{VALUE}} !important;"}},{"name":"btn_color_hover","label":"Text Color Hover","type":"color","selectors":{"{{WRAPPER}} .pxl-button-wrapper .pxl-btn:hover":"color: {{VALUE}} !important;"}},{"name":"btn_bg_color","label":"Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-button-wrapper .pxl-btn":"background: {{VALUE}} !important;"}},{"name":"btn_bg_color_hover","label":"Background Color Hover","type":"color","selectors":{"{{WRAPPER}} .pxl-button-wrapper .pxl-btn:hover, {{WRAPPER}} .pxl-button-wrapper .pxl-btn:focus, {{WRAPPER}} .pxl-button-wrapper .pxl-btn:active":"background: {{VALUE}} !important;"}},{"name":"line_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-btn:after":"border-color: {{VALUE}} !important;"},"condition":{"style!":"default"}},{"name":"line_border_color_hover","label":"Border Color Hover","type":"color","selectors":{"{{WRAPPER}} .pxl-btn .draw-top-right:before, {{WRAPPER}} .pxl-btn .draw-top-right:after, {{WRAPPER}} .pxl-btn .draw-bottom-left:before, {{WRAPPER}} .pxl-btn .draw-bottom-left:after":"background-color: {{VALUE}} !important;"},"condition":{"style!":"default"}},{"name":"border_type","label":"Border Type","type":"select","options":{"":"None","solid":"Solid","double":"Double","dotted":"Dotted","dashed":"Dashed","groove":"Groove"},"selectors":{"{{WRAPPER}} .pxl-button-wrapper .pxl-btn":"border-style: {{VALUE}} !important;"},"condition":{"style":"default"}},{"name":"border_width","label":"Border Width","type":"dimensions","selectors":{"{{WRAPPER}} .pxl-button-wrapper .pxl-btn":"border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;"},"responsive":true,"condition":{"style":"default"}},{"name":"border_color","label":"Border Color","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-button-wrapper .pxl-btn":"border-color: {{VALUE}} !important;"},"condition":{"style":"default","border_type!":""}},{"name":"border_color_hover","label":"Border Color Hover","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-button-wrapper .pxl-btn:hover":"border-color: {{VALUE}} !important;"},"condition":{"style":"default","border_type!":""}},{"name":"btn_border_radius","label":"Border Radius","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-button-wrapper .pxl-btn":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"condition":{"style":"default"}},{"name":"btn_square_width","label":"Square Width","type":"slider","size_units":["px"],"range":{"px":{"min":-1000,"max":1000}},"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-button-wrapper .pxl-btn":"width: {{SIZE}}{{UNIT}};min-width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};"},"condition":{"style":"default"}}]},{"name":"parallax_section","label":"Parallax Settings","tab":"style","controls":[{"name":"pxl_parallax","label":"Parallax Type","type":"select","options":{"":"None","x":"Transform X","y":"Transform Y","z":"Transform Z","rotateX":"RotateX","rotateY":"RotateY","rotateZ":"RotateZ","scaleX":"ScaleX","scaleY":"ScaleY","scaleZ":"ScaleZ","scale":"Scale"}},{"name":"parallax_value","label":"Value","type":"text","default":"","condition":{"pxl_parallax!":""}}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}