<?php

// remove page title on archive page
add_filter('woocommerce_show_page_title', function(){ return false;});
  
//Custom products layout on archive page
add_filter( 'loop_shop_columns', 'adsett_loop_shop_columns', 20 ); 
function adsett_loop_shop_columns() {
	$columns = isset($_GET['col']) ? sanitize_text_field($_GET['col']) : adsett()->get_theme_opt('products_columns', 3);
	return $columns;
}
 

// Change number of products that are displayed per page (shop page)
add_filter( 'loop_shop_per_page', 'adsett_loop_shop_per_page', 20 );
function adsett_loop_shop_per_page( $limit ) {
	$limit = adsett()->get_theme_opt('product_per_page', 12);
	return $limit;
}

add_filter( 'woocommerce_product_loop_start', 'adsett_product_loop_start' );
function adsett_product_loop_start(){
	$display_type = isset($_GET['type']) ? sanitize_text_field($_GET['type']) : adsett()->get_theme_opt('shop_display_type', 'grid');
	if( $display_type == 'list')
		return '<ul class="products shop-view-list">';
	else
		return '<ul class="products columns-'. esc_attr( wc_get_loop_prop( 'columns' ) ) .'">';
}

// Loop Thumbnail Size
add_filter( 'woocommerce_get_image_size_thumbnail', function( $size ) {
    $product_image_cropped = adsett()->get_theme_opt('product_image_cropped', '1');
    if($product_image_cropped !='1') return $size;
    return array(
        'width'  => 570,
        'height' => 570,
        'crop'   => 1,
    );
});   

// Loop product title 
if ( ! function_exists( 'woocommerce_template_loop_product_title' ) ) {
	function woocommerce_template_loop_product_title() {
		echo '<span class="pxl-product-title">' . get_the_title() . '</span>';
	}
}

// paginate links
add_filter('woocommerce_pagination_args', 'adsett_woocommerce_pagination_args');
function adsett_woocommerce_pagination_args($default){
	$default = array_merge($default, [
		'prev_text' => '<span class="pxli-long-arrow-left"></span>',
		'next_text' => '<span class="pxli-long-arrow-right"></span>',
		'type'      => 'plain',
	]);
	return $default;
}

// add custom layout for catalog order and result count
if(!function_exists('adsett_woocommerce_catalog_result')){
	// remove
	remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
	remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
	// add back
	add_action('woocommerce_before_shop_loop','adsett_woocommerce_catalog_result', 20);
	add_action('adsett_woocommerce_catalog_ordering', 'woocommerce_catalog_ordering');
	add_action('adsett_woocommerce_result_count', 'woocommerce_result_count');
	function adsett_woocommerce_catalog_result(){
		$columns = isset($_GET['col']) ? sanitize_text_field($_GET['col']) : adsett()->get_theme_opt('products_columns', 3);
		$display_type = isset($_GET['type']) ? sanitize_text_field($_GET['type']) : adsett()->get_theme_opt('shop_display_type', 'grid');

		$active_grid = $active_list = '';
		$active_grid = $display_type == 'grid' ? 'active' : '';
		$active_list = $display_type == 'list' ? 'active' : '';
		 
	?>
		<div class="pxl-shop-topbar-wrap row justify-content-between align-items-center g-30">
			<div class="pxl-view-layout-wrap col-12 col-sm-auto order-md-3">
				<ul class="pxl-view-layout d-flex align-items-center">
					<li class="lbl"><?php echo esc_html__( 'View','adsett' ) ?></li>
					<li class="view-icon view-grid <?php echo esc_attr($active_grid) ?>"><a href="javascript:void(0);" class="pxl-ttip tt-top-left" data-cls="products columns-<?php echo esc_attr($columns)?>" data-col="list"><span class="tt-txt"><?php echo esc_html__('View Grid','adsett') ?></span><span class="pxli-border-all"></span></a></li>
					<li class="view-icon view-list <?php echo esc_attr($active_list) ?>"><a href="javascript:void(0);" class="pxl-ttip tt-top-left" data-cls="products shop-view-list" data-col="list"><span class="tt-txt"><?php echo esc_html__('View List','adsett') ?></span><span class="pxli-list-ul"></span></a></li>
				</ul>
			</div>
			<div class="col-12 col-sm-auto order-md-2">
				<?php do_action('adsett_woocommerce_catalog_ordering'); ?>
			</div>
			<div class="col text-heading number-result">
				<?php do_action('adsett_woocommerce_result_count'); ?>
			</div>
		</div>
	<?php
	}
}    

// add div wrap
add_action('woocommerce_before_shop_loop_item', function(){ echo '<div class="pxl-shop-item-wrap">';}, 0);
add_action('woocommerce_after_shop_loop_item', function(){ echo '</div>';}, 9999);
// remove link on product image
remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);
// add link to product title
add_action('woocommerce_shop_loop_item_title','woocommerce_template_loop_product_link_open', 1 );
add_action('woocommerce_shop_loop_item_title','woocommerce_template_loop_product_link_close', 9999 );
// wrap product image by div
if(!function_exists('adsett_wrap_products_thumbnail_open')){
	add_action('woocommerce_before_shop_loop_item', 'adsett_wrap_products_thumbnail_open', 1);
	function adsett_wrap_products_thumbnail_open(){
		echo '<div class="pxl-products-thumb relative overflow-hidden">';
	}
}
add_action('woocommerce_before_shop_loop_item', 'adsett_woosmart_button', 2);
function adsett_woosmart_button(){
	if( class_exists( 'WPCleverWoosc' ) || class_exists( 'WPCleverWoosq' ) || class_exists( 'WPCleverWoosw' )){
		echo '<div class="pxl-shop-woosmart-wrap">';
			do_action( 'woosc_button_position_archive_woosmart' );
			do_action( 'woosq_button_position_woosmart' );
			do_action( 'woosw_button_position_archive_woosmart' );
		echo '</div>';
	}
}

if(!function_exists('adsett_wrap_products_thumbnail_close')){
	add_action('woocommerce_before_shop_loop_item', 'adsett_wrap_products_thumbnail_close', 999);
	function adsett_wrap_products_thumbnail_close(){
		echo '</div>';
	}
}

// product thumbnail & sale flash
remove_action('woocommerce_before_shop_loop_item_title','woocommerce_show_product_loop_sale_flash', 10);
add_action('woocommerce_before_shop_loop_item','woocommerce_show_product_loop_featured', 8);
add_action('woocommerce_before_shop_loop_item','woocommerce_show_product_loop_sale_flash', 9);
 
function woocommerce_show_product_loop_featured(){
	global $post, $product;
	if ( $product->is_featured() ) {
		echo '<span class="pxl-hot">' . esc_html__( 'Hot', 'adsett' ) . '</span>';
	}
} 

remove_action('woocommerce_before_shop_loop_item_title','woocommerce_template_loop_product_thumbnail', 10);
add_action('woocommerce_before_shop_loop_item','woocommerce_template_loop_product_thumbnail', 10);

// Wrap products infor by div 

add_action('woocommerce_before_shop_loop_item', 'adsett_loop_product_content_open', 1000);
function adsett_loop_product_content_open(){
	echo '<div class="pxl-products-content">';
}
 
add_action('woocommerce_before_shop_loop_item', 'adsett_loop_product_content_inner_list', 1001);
function adsett_loop_product_content_inner_list(){
	echo '<div class="pxl-products-content-list-view d-none">';
		do_action('adsett_loop_product_list_view_content');
	echo '</div>';
}
  
add_action('woocommerce_before_shop_loop_item', 'adsett_loop_product_content_inner_open', 1100);
function adsett_loop_product_content_inner_open(){
	$product_loop_rating = adsett()->get_theme_opt('product_loop_rating', '0');
    $show_rating_cls = $product_loop_rating == '1' ? 'show-rating' : 'hide-rating';
	echo '<div class="pxl-products-content-grid-view '.$show_rating_cls.'">';
}

add_action('woocommerce_after_shop_loop_item', 'adsett_loop_product_content_inner_close', 900);
function adsett_loop_product_content_inner_close(){
	echo '</div>';
}

add_action('woocommerce_after_shop_loop_item', 'adsett_loop_product_content_close', 900);
function adsett_loop_product_content_close(){
	echo '</div>';
}


add_action('woocommerce_after_shop_loop_item', 'adsett_loop_product_content_btn_cart_open', 9);
function adsett_loop_product_content_btn_cart_open(){
	echo '<div class="pxl-loop-cart-wrap">';
} 
add_action('woocommerce_after_shop_loop_item', 'adsett_loop_product_content_btn_cart_close', 11);
function adsett_loop_product_content_btn_cart_close(){
	echo '</div>';
} 

remove_action('woocommerce_after_shop_loop_item_title','woocommerce_template_loop_rating', 5);
remove_action('woocommerce_after_shop_loop_item_title','woocommerce_template_loop_price', 10);
add_action('woocommerce_after_shop_loop_item_title','woocommerce_template_loop_price', 5);
add_action('woocommerce_after_shop_loop_item_title','woocommerce_template_loop_rating', 10);


add_filter('woocommerce_loop_add_to_cart_link', 'adsett_woocommerce_loop_add_to_cart_link', 10, 3);
function adsett_woocommerce_loop_add_to_cart_link($button, $product, $args){
	return sprintf(
		'<a href="%s" data-quantity="%s" class="%s pxl-ttip tt-top-left" %s><span class="tt-txt">%s</span><span class="pxl-btn-text">%s</span>%s</a>',
		esc_url( $product->add_to_cart_url() ),
		esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
		esc_attr( isset( $args['class'] ) ? $args['class'] : 'button' ),
		isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
		esc_html( $product->add_to_cart_text() ),
		esc_html( $product->add_to_cart_text() ),
		'<span class="pxl-icon pxl-addtocart-icon bi-cart-plus-fill"></span>'
	);
}

add_action('adsett_loop_product_list_view_content', 'adsett_loop_product_list_view_content_gender', 16);
function adsett_loop_product_list_view_content_gender(){
	global $product; 
	global $post;
	$short_description = apply_filters( 'woocommerce_short_description', $post->post_excerpt );
	echo '<div class="title-wrap d-flex-wrap align-items-center justify-content-between gx-30">';
		do_action( 'woocommerce_shop_loop_item_title' );
		echo '<div class="price-rating d-flex-wrap align-items-center gxm-30">';
		wc_get_template( 'loop/price.php' );
		wc_get_template( 'loop/rating.php' );
		echo '</div>'; 
	echo '</div>';
    echo '<div class="pxl-loop-product-excerpt">';
		echo ''.$short_description;
    echo '</div>';    
    woocommerce_template_loop_add_to_cart();
}
 
 