<?php
/**
 * @package Adsett
 */

$archive_readmore = adsett()->get_theme_opt('archive_readmore', '1');
$archive_readmore_text = adsett()->get_theme_opt('archive_readmore_text', esc_html__('Read more', 'adsett'));
$archive_sticky_mark = adsett()->get_theme_opt( 'archive_sticky_mark', true );
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('pxl-archive-post wow fadeInUp'); ?> data-wow-duration="0.5s">
    <?php 
    if (has_post_format('quote') ):
        $quote_text = get_post_meta( get_the_ID(), 'featured-quote-text', true );
        $quote_cite = get_post_meta( get_the_ID(), 'featured-quote-cite', true );
        ?>
        <?php if(!empty($quote_text)): ?>
            <div class="quote-inner text-center">
                <div class="quote-icon"><span class="pxl-icon pxli pxli-quote"></span></div>
                <a class="quote-text" href="<?php echo esc_url( get_permalink()); ?>"><?php echo esc_html($quote_text);?></a>
                <p class="quote-cite"><?php echo esc_html($quote_cite);?></p>
            </div>
        <?php endif; ?>
    <?php elseif (has_post_format('video')): ?>
        <?php 
            global $wp_embed;
            $featured_video = get_post_meta( get_the_ID(), 'featured-video-url', true );
            if (!empty($featured_video)) {
                echo '<div class="feature-video">';
                    echo do_shortcode($wp_embed->autoembed($featured_video));
                echo '</div>';
            }
        ?>
    <?php elseif (has_post_format('audio')): ?>
        <?php 
            global $wp_embed;
            $audio_url = get_post_meta( get_the_ID(), 'featured-audio-url', true );
            if (!empty($audio_url)) {
                echo '<div class="feature-audio relative">';
                    echo do_shortcode($wp_embed->autoembed($audio_url));
                    if (has_post_thumbnail()) {
                        $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'medium'); 
                        ?> 
                        <a href="<?php echo esc_url( get_permalink()); ?>">
                            <?php the_post_thumbnail('medium'); ?>
                        </a>
                        <?php 
                    } 
                echo '</div>';
            }
        ?>
    <?php elseif (has_post_format('link')): ?>
        <?php 
            $link_url = get_post_meta( get_the_ID(), 'featured-link-url', true );
            $link_text = get_post_meta( get_the_ID(), 'featured-link-text', true );
 
            if (!empty($link_url) && !empty($link_text)): ?>
                <div class="feature-link text-center">
                    <div class="link-icon">
                        <a href="<?php echo esc_url( $link_url); ?>">
                            <svg version="1.1" viewBox="0 0 77.9 78.2">
                                <g>
                                    <g>
                                        <path d="M30.2,48.1l-16,0c-5.5,0.1-10.1-4.3-10.1-9.8C4,32.7,8.4,28.1,13.9,28c0.1,0,0.2,0,0.3,0l16,0c1.1,0,2-0.9,2-2
                                            c0-1.1-0.9-2-2-2l-16,0c-7.7,0-14,6.2-14,14c0,7.7,6.2,14,14,14l16,0c1.1,0.1,2-0.8,2.1-1.9c0.1-1.1-0.8-2-1.9-2.1
                                            C30.4,48.1,30.3,48.1,30.2,48.1z"/>
                                        <path d="M77.3,38.3c0-7.7-6.2-14-14-14c0,0,0,0,0,0l-16,0c-1.1,0-2,1-1.9,2.1c0,1,0.9,1.9,1.9,1.9l16,0c5.5,0.1,9.9,4.7,9.8,10.2
                                            c-0.1,5.4-4.5,9.7-9.8,9.8l-16,0c-1.1-0.1-2,0.8-2.1,1.9c-0.1,1.1,0.8,2,1.9,2.1c0.1,0,0.1,0,0.2,0l16,0
                                            C71,52.3,77.3,46.1,77.3,38.3C77.3,38.3,77.3,38.3,77.3,38.3z"/>
                                        <path d="M18.8,38.1c0,0.5,0.2,1,0.6,1.4c0.4,0.4,0.9,0.6,1.4,0.6l36,0.1c1.1,0,2-0.9,2-2c0-1.1-0.9-2-2-2l-36-0.1
                                            C19.7,36.1,18.8,37,18.8,38.1C18.8,38.1,18.8,38.1,18.8,38.1z"/>
                                    </g>
                                </g>
                            </svg>
                        </a>
                    </div>
                    <h4 class="link-title"><a href="<?php echo esc_url( $link_url); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h4>
                    <a class="link-text" target="_blank" href="<?php echo esc_url( $link_url); ?>"><?php echo esc_html($link_text);?></a>
                </div>
            <?php endif; ?>
    <?php elseif (has_post_format('gallery')): 
        $gallery_list = [];
        $gallery = get_post_meta( get_the_ID(), 'featured-gallery', true );
        if(!empty($gallery)):
            $galleries = explode(',', $gallery);
            if (!wp_script_is( 'swiper', 'enqueued' ))
                wp_enqueue_script( 'swiper');
            if (has_post_thumbnail()) {
                $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'medium'); 
                $gallery_list[] = $featured_img_url;
            }
            foreach ($galleries as $gal_id) {
                $gal_image_url = wp_get_attachment_image_url( $gal_id, 'medium' );
                $gallery_list[] = $gal_image_url;
            }  
            echo '<div class="feature-gallery relative">'; ?>
                <div class="pxl-swiper-slider post-gallery-slider">
                    <div class="pxl-swiper-slider-wrap pxl-carousel-inner overflow-hidden">
                        <div class="pxl-swiper-container">
                            <div class="pxl-swiper-wrapper swiper-wrapper">
                                <?php foreach ($gallery_list as $value): ?>
                                    <div class="pxl-swiper-slide swiper-slide">
                                        <a href="<?php echo esc_url( get_permalink()); ?>">
                                            <img src="<?php echo esc_url($value)?>" alt="gallery">
                                        </a>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                    <div class="pxl-swiper-arrows">
                        <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><span class="pxl-icon bi bi-arrow-left"></span></div>
                        <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><span class="pxl-icon bi bi-arrow-right"></span></div>
                    </div>
                </div>
            <?php echo '</div>'; ?>
        <?php elseif (has_post_thumbnail()):
            echo '<div class="post-featured relative">'; ?>
                <a href="<?php echo esc_url( get_permalink()); ?>">
                    <?php the_post_thumbnail('medium'); ?>
                </a>
            <?php echo '</div>';
        endif; ?>

    <?php else: ?>
        <?php if (has_post_thumbnail()) {
            echo '<div class="post-featured relative">'; ?>
                <a href="<?php echo esc_url( get_permalink()); ?>">
                    <?php the_post_thumbnail('medium'); ?>
                </a>
            <?php echo '</div>';
        } ?>
    <?php endif; ?>
    <?php if (!has_post_format('link') && !has_post_format('quote')): ?>
        <div class="post-content">
            <?php adsett()->blog->get_archive_meta(); ?>
            <h3 class="post-title">
                <a href="<?php echo esc_url( get_permalink()); ?>" title="<?php the_title_attribute(); ?>">
                    <?php if(is_sticky() && $archive_sticky_mark) { ?>
                        <i class="pxli-thumbtack"></i>
                    <?php } ?>
                    <?php the_title(); ?>
                </a>
            </h3>
            <div class="post-excerpt">
                <?php adsett()->blog->get_excerpt(); ?>
            </div>
            <?php adsett()->page->get_link_pages(); ?>

            <?php if( $archive_readmore == '1'): ?>
                <div class="post-readmore">
                    <a href="<?php echo esc_url( get_permalink()); ?>" class="pxl-btn outline-above draw icon-ps-right">
                        <span class="draw-top-right"></span>
                        <span class="draw-bottom-left"></span>
                        <span class="pxl-button-text"><?php echo adsett_html($archive_readmore_text); ?></span>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>
     
</article>