<?php
/**
 * Template part for displaying posts in loop
 *
 * @package Adsett
 */

if(has_post_thumbnail()){
    $content_inner_cls = 'single-post-inner has-post-thumbnail';
    $meta_class    = ''; 
} else {
    $content_inner_cls = 'single-post-inner  no-post-thumbnail';
    $meta_class = '';
}
 
if(class_exists('\Elementor\Plugin') && \Elementor\Plugin::$instance->documents->get( get_the_ID() )->is_built_with_elementor()){
    $post_content_classes = 'single-elementor-content';
} else {
    $post_content_classes = '';
}

?>
<article id="post-<?php the_ID(); ?>" <?php post_class('pxl-single-post'); ?>>
    <div class="<?php echo esc_attr($content_inner_cls);?>">
        <?php adsett()->blog->get_post_feature();?>
        <?php adsett()->blog->get_post_metas(); ?>
        <?php adsett()->blog->get_post_title(); ?>
        <div class="post-content overflow-hidden">
            <div class="content-inner clearfix <?php echo esc_attr($post_content_classes);?>"><?php
                the_content();
            ?></div>
            <div class="<?php echo trim(implode(' ', ['navigation page-links clearfix empty-none'])); ?>"><?php 
                wp_link_pages(); 
            ?></div>
            <?php adsett()->blog->get_post_content_foot(); ?> 
        </div>
    </div>
    <?php adsett()->blog->get_post_author_info(); ?>
    <?php adsett()->blog->get_post_nav(); ?>
</article>