<?php
/**
 * @package Adsett
 */
?>
<?php 
if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false)){
    $img_id = get_post_thumbnail_id(get_the_ID());
    if($img_id && function_exists('pxl_get_image_by_size')){
        $img = pxl_get_image_by_size( array(
            'attach_id'  => $img_id,
            'thumb_size' => '670x450',
            'class' => 'img-desktop no-lazyload',
        ));
        $thumbnail = $img['thumbnail'];
    }else{  
        $thumbnail = get_the_post_thumbnail(get_the_ID(), 'medium');
    }
}else{
    $thumbnail = '';
}

$the_excerpt = get_post_meta( get_the_ID(), 'extra_desc', true );
 
if(empty($the_excerpt)) {
    $the_excerpt = get_the_excerpt();
}


$col_cls = !empty( $thumbnail ) ? 'col-12 col-lg-5 col-xl-5' : 'col';
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('pxl-portfolio-item'); ?>>
    <div class="grid-item-inner item-inner-wrap row align-items-center gx-xl-70">
        <?php if ( !empty( $thumbnail )): ?>
            <div class="item-featured col-12 col-lg-7 col-xl-7">
                <div class="post-image scale-hover">
                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                        <?php echo wp_kses_post($thumbnail); ?>       
                    </a>
                </div>
            </div>
        <?php endif; ?>
        <div class="item-content <?php echo esc_attr($col_cls) ?>">
            <h3 class="item-title"><a href="<?php echo esc_url( get_permalink()); ?>"><?php echo esc_html(get_the_title()); ?></a></h3>  
            <div class="item-excerpt">
                <?php
                if(!empty($the_excerpt)){
                    echo wp_trim_words( $the_excerpt, 50, null );
                } else{
                    $content = strip_shortcodes( $post->post_content );
                    $content = apply_filters( 'the_content', $content );
                    $content = str_replace(']]>', ']]&gt;', $content);
                    echo wp_trim_words( $content, 50, null );
                }
                ?>
            </div>
             
            <div class="item-readmore">
                <a href="<?php echo esc_url( get_permalink()); ?>" class="pxl-btn outline-under draw">
                    <span class="draw-top-right"></span>
                    <span class="draw-bottom-left"></span>
                    <span class="pxl-button-text"><?php echo esc_html__( 'View Details', 'adsett' ) ?></span>
                </a>
            </div>
             
        </div>
         
    </div>
</article> 