<?php
defined( 'ABSPATH' ) or exit( -1 );

/**
 * Author Information widgets
 *
 */

if(!function_exists('pxl_register_wp_widget')) return;
add_action( 'widgets_init', function(){
    pxl_register_wp_widget( 'PXL_Author_Info_Widget' );
});
class PXL_Author_Info_Widget extends WP_Widget
{

    function __construct()
    {
        parent::__construct(
            'pxl_author_info_widget',
            esc_html__('* Pxl Author Information', 'adsett'),
            array('description' => esc_html__('Show Author Information', 'adsett'),)
        );
    }

    function widget($args, $instance)
    {
        extract($args);
        $author_image_id = !empty($instance['author_image']) ? $instance['author_image'] : '';
        $author_image_url = wp_get_attachment_image_url($author_image_id, '');
        $author_name = !empty($instance['author_name']) ? $instance['author_name'] : '';
        $description = !empty($instance['description']) ? $instance['description'] : '';

        $twitter_like = !empty($instance['author_twitter_like']) ? $instance['author_twitter_like'] : '';
        $facebook_like = !empty($instance['author_facebook_like']) ? $instance['author_facebook_like'] : '';
        $instagram_like = !empty($instance['author_instagram_like']) ? $instance['author_instagram_like'] : '';
        $youtube_like = !empty($instance['author_youtube_like']) ? $instance['author_youtube_like'] : '';
        $linkedin_like = !empty($instance['author_linkedin_like']) ? $instance['author_linkedin_like'] : '';

        $twitter_link = !empty($instance['author_twitter_link']) ? $instance['author_twitter_link'] : '';
        $facebook_link = !empty($instance['author_facebook_link']) ? $instance['author_facebook_link'] : '';
        $instagram_link = !empty($instance['author_instagram_link']) ? $instance['author_instagram_link'] : '';
        $youtube_link = !empty($instance['author_youtube_link']) ? $instance['author_youtube_link'] : '';
        $linkedin_link = !empty($instance['author_linkedin_link']) ? $instance['author_linkedin_link'] : '';
         
        ?>
        <div class="pxl-author-info widget" >
            <div class="content-inner">
                <div class="author-image">
                    <div class="image-wrap flash-hover">
                        <img src="<?php echo esc_url($author_image_url)?>" alt="<?php echo esc_attr__('Author Image', 'adsett');?>">
                    </div>
                </div>
                <?php if (!empty($author_name)): ?>
                    <h4 class="author-name"><?php echo esc_html($author_name);?></h4>
                <?php endif; ?>
                <?php if (!empty($description)): ?>
                    <div class="author-desc"><?php echo adsett_html(nl2br($description)); ?></div>
                <?php endif; ?>
                <?php if ( !empty($twitter_link) || !empty($facebook_link) || !empty($instagram_link) || !empty($youtube_link) || !empty($linkedin_link)): ?>
                    <div class="author-social d-flex-wrap justify-content-center">
                        <?php if(!empty($twitter_link)): ?>
                            <div class="social-item twitter d-flex align-items-center">
                                <a href="<?php echo esc_url($twitter_link); ?>"><span class="icon pxli-twitter"></span>
                                    <?php if(!empty($twitter_like)): ?> <span class="txt-like"><?php echo esc_html($twitter_like) ?></span> <?php endif; ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        <?php if(!empty($facebook_link)): ?>
                            <div class="social-item facebook d-flex align-items-center">
                                <a href="<?php echo esc_url($facebook_link); ?>"><span class="icon pxli-facebook-f"></span>
                                    <?php if(!empty($facebook_like)): ?> <span class="txt-like"><?php echo esc_html($facebook_like) ?></span> <?php endif; ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        <?php if(!empty($instagram_link)): ?>
                            <div class="social-item instagram d-flex align-items-center">
                                <a href="<?php echo esc_url($instagram_link); ?>"><span class="icon pxli-instagram-square"></span>
                                    <?php if(!empty($instagram_like)): ?> <span class="txt-like"><?php echo esc_html($instagram_like) ?></span> <?php endif; ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        <?php if(!empty($youtube_link)): ?>
                            <div class="social-item youtube d-flex align-items-center">
                                <a href="<?php echo esc_url($youtube_link); ?>"><span class="icon pxli-youtube-brands"></span>
                                    <?php if(!empty($youtube_like)): ?> <span class="txt-like"><?php echo esc_html($youtube_like) ?></span> <?php endif; ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        <?php if(!empty($linkedin_link)): ?>
                            <div class="social-item linkedin d-flex align-items-center">
                                <a href="<?php echo esc_url($linkedin_link); ?>"><span class="icon pxli-linkedin-in"></span>
                                    <?php if(!empty($linkedin_like)): ?> <span class="txt-like"><?php echo esc_html($linkedin_like) ?></span> <?php endif; ?>
                                </a>
                            </div>
                        <?php endif; ?>
                         
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <?php
    }

    function update($new_instance, $old_instance)
    {
        $instance = $old_instance;
        $instance['author_image'] = strip_tags($new_instance['author_image']);
        $instance['author_name'] = strip_tags($new_instance['author_name']);
        $instance['description'] = strip_tags($new_instance['description']);

        $instance['author_twitter_like'] = strip_tags($new_instance['author_twitter_like']);
        $instance['author_facebook_like'] = strip_tags($new_instance['author_facebook_like']);
        $instance['author_instagram_like'] = strip_tags($new_instance['author_instagram_like']);
        $instance['author_youtube_like'] = strip_tags($new_instance['author_youtube_like']);
        $instance['author_linkedin_like'] = strip_tags($new_instance['author_linkedin_like']);

        $instance['author_twitter_link'] = strip_tags($new_instance['author_twitter_link']);
        $instance['author_facebook_link'] = strip_tags($new_instance['author_facebook_link']);
        $instance['author_instagram_link'] = strip_tags($new_instance['author_instagram_link']);
        $instance['author_youtube_link'] = strip_tags($new_instance['author_youtube_link']);
        $instance['author_linkedin_link'] = strip_tags($new_instance['author_linkedin_link']);
         
        return $instance;
    }

    function form($instance)
    {
        $author_image = isset($instance['author_image']) ? esc_attr($instance['author_image']) : '';
        $author_name = isset($instance['author_name']) ? esc_html($instance['author_name']) : '';
        $description = isset($instance['description']) ? esc_html($instance['description']) : '';

        $author_twitter_like = isset($instance['author_twitter_like']) ? esc_html($instance['author_twitter_like']) : '';
        $author_facebook_like = isset($instance['author_facebook_like']) ? esc_html($instance['author_facebook_like']) : '';
        $author_instagram_like = isset($instance['author_instagram_like']) ? esc_html($instance['author_instagram_like']) : '';
        $author_youtube_like = isset($instance['author_youtube_like']) ? esc_html($instance['author_youtube_like']) : '';
        $author_linkedin_like = isset($instance['author_linkedin_like']) ? esc_html($instance['author_linkedin_like']) : '';

        $author_twitter_link = isset($instance['author_twitter_link']) ? esc_html($instance['author_twitter_link']) : '';
        $author_facebook_link = isset($instance['author_facebook_link']) ? esc_html($instance['author_facebook_link']) : '';
        $author_instagram_link = isset($instance['author_instagram_link']) ? esc_html($instance['author_instagram_link']) : '';
        $author_youtube_link = isset($instance['author_youtube_link']) ? esc_html($instance['author_youtube_link']) : '';
        $author_linkedin_link = isset($instance['author_linkedin_link']) ? esc_html($instance['author_linkedin_link']) : '';
        ?>
        <div class="author-image-wrap">
            <label for="<?php echo esc_url($this->get_field_id('author_image')); ?>"><?php esc_html_e('Author Image', 'adsett'); ?></label>
            <input type="hidden" class="widefat hide-image-url"
                   id="<?php echo esc_attr($this->get_field_id('author_image')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('author_image')); ?>"
                   value="<?php echo esc_attr($author_image) ?>"/>
            <div class="pxl-show-image">
                <?php
                if ($author_image != "") {
                    ?>
                    <img src="<?php echo wp_get_attachment_image_url($author_image) ?>">
                    <?php
                }
                ?>
            </div>
            <?php
            if ($author_image != "") {
                ?>
                <a href="#" class="pxl-select-image pxl-btn" style="display: none;"><?php esc_html_e('Select Image', 'adsett'); ?></a>
                <a href="#" class="pxl-remove-image pxl-btn"><?php esc_html_e('Remove Image', 'adsett'); ?></a>
                <?php
            } else {
                ?>
                <a href="#" class="pxl-select-image pxl-btn"><?php esc_html_e('Select Image', 'adsett'); ?></a>
                <a href="#" class="pxl-remove-image pxl-btn" style="display: none;"><?php esc_html_e('Remove Image', 'adsett'); ?></a>
                <?php
            }
            ?>
        </div>
         
        <p>
            <label for="<?php echo esc_url($this->get_field_id('author_name')); ?>"><?php esc_html_e( 'Author Name', 'adsett' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('author_name') ); ?>" name="<?php echo esc_attr( $this->get_field_name('author_name') ); ?>" type="text" value="<?php echo esc_attr( $author_name ); ?>" />
        </p>

        <p>
            <label for="<?php echo esc_url($this->get_field_id('description')); ?>"><?php esc_html_e('Description', 'adsett'); ?></label>
            <textarea class="widefat" rows="4" cols="20" id="<?php echo esc_attr($this->get_field_id('description')); ?>" name="<?php echo esc_attr($this->get_field_name('description')); ?>"><?php echo wp_kses_post($description); ?></textarea>
        </p>

        <p>
            <label for="<?php echo esc_url($this->get_field_id('author_twitter_like')); ?>"><?php esc_html_e( 'Twitter Like', 'adsett' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('author_twitter_like') ); ?>" name="<?php echo esc_attr( $this->get_field_name('author_twitter_like') ); ?>" type="text" value="<?php echo esc_attr( $author_twitter_like ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_url($this->get_field_id('author_twitter_link')); ?>"><?php esc_html_e( 'Twitter Link', 'adsett' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('author_twitter_link') ); ?>" name="<?php echo esc_attr( $this->get_field_name('author_twitter_link') ); ?>" type="text" value="<?php echo esc_attr( $author_twitter_link ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_url($this->get_field_id('author_facebook_like')); ?>"><?php esc_html_e( 'Facebook Like', 'adsett' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('author_facebook_like') ); ?>" name="<?php echo esc_attr( $this->get_field_name('author_facebook_like') ); ?>" type="text" value="<?php echo esc_attr( $author_facebook_like ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_url($this->get_field_id('author_facebook_link')); ?>"><?php esc_html_e( 'Facebook Link', 'adsett' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('author_facebook_link') ); ?>" name="<?php echo esc_attr( $this->get_field_name('author_facebook_link') ); ?>" type="text" value="<?php echo esc_attr( $author_facebook_link ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_url($this->get_field_id('author_instagram_like')); ?>"><?php esc_html_e( 'Instagram Like', 'adsett' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('author_instagram_like') ); ?>" name="<?php echo esc_attr( $this->get_field_name('author_instagram_like') ); ?>" type="text" value="<?php echo esc_attr( $author_instagram_like ); ?>" />
            
        </p>
        <p>
            <label for="<?php echo esc_url($this->get_field_id('author_instagram_link')); ?>"><?php esc_html_e( 'Instagram Link', 'adsett' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('author_instagram_link') ); ?>" name="<?php echo esc_attr( $this->get_field_name('author_instagram_link') ); ?>" type="text" value="<?php echo esc_attr( $author_instagram_link ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_url($this->get_field_id('author_youtube_like')); ?>"><?php esc_html_e( 'Youtube Like', 'adsett' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('author_youtube_like') ); ?>" name="<?php echo esc_attr( $this->get_field_name('author_youtube_like') ); ?>" type="text" value="<?php echo esc_attr( $author_youtube_like ); ?>" />
            
        </p>
        <p>
            <label for="<?php echo esc_url($this->get_field_id('author_youtube_link')); ?>"><?php esc_html_e( 'Youtube Link', 'adsett' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('author_youtube_link') ); ?>" name="<?php echo esc_attr( $this->get_field_name('author_youtube_link') ); ?>" type="text" value="<?php echo esc_attr( $author_youtube_link ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_url($this->get_field_id('author_linkedin_like')); ?>"><?php esc_html_e( 'Linkedin Like', 'adsett' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('author_linkedin_like') ); ?>" name="<?php echo esc_attr( $this->get_field_name('author_linkedin_like') ); ?>" type="text" value="<?php echo esc_attr( $author_linkedin_like ); ?>" />
            
        </p>
        <p>
            <label for="<?php echo esc_url($this->get_field_id('author_linkedin_link')); ?>"><?php esc_html_e( 'Linkedin Link', 'adsett' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id('author_linkedin_link') ); ?>" name="<?php echo esc_attr( $this->get_field_name('author_linkedin_link') ); ?>" type="text" value="<?php echo esc_attr( $author_linkedin_link ); ?>" />
        </p>
        <?php
    }

} 