<?php
if (!class_exists('ReduxFramework')) {
    return;
}
if (class_exists('ReduxFrameworkPlugin')) {
    remove_action('admin_notices', array(ReduxFrameworkPlugin::instance(), 'admin_notices'));
}

$opt_name = adsett()->get_option_name();
$version = adsett()->get_version();

$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name'             => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name'         => '', //$theme->get('Name'),
    // Name that appears at the top of your panel
    'display_version'      => $version,
    // Version that appears at the top of your panel
    'menu_type'            => 'submenu',  
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu'       => true,
    // Show the sections below the admin menu item or not
    'menu_title'           => esc_html__('Theme Options', 'adsett'),
    'page_title'           => esc_html__('Theme Options', 'adsett'),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_api_key'       => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography'     => false,
    // Use a asynchronous font on the front end or font string
    //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
    'admin_bar'            => false,
    // Show the panel pages on the admin bar
    'admin_bar_icon'       => 'dashicons-admin-generic',
    // Choose an icon for the admin bar menu
    'admin_bar_priority'   => 50,
    // Choose an priority for the admin bar menu
    'global_variable'      => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode'             => true,
    // Show the time the page took to load, etc
    'update_notice'        => true,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer'           => true,
    // Enable basic customizer support
    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field
    'show_options_object' => false,
    // OPTIONAL -> Give you extra features
    'page_priority'        => 80,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent'          => 'pxlart', 
    // For a full list of options, visit: //codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions'     => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon'            => '',
    // Specify a custom URL to an icon
    'last_tab'             => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon'            => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug'            => 'pxlart-theme-options',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults'        => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show'         => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark'         => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export'   => true,
    // Shows the Import/Export panel when not used as a field.

    // CAREFUL -> These options are for advanced use only
    'transient_time'       => 60 * MINUTE_IN_SECONDS,
    'output'               => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag'           => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database'             => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn'              => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

    // HINTS
    'hints'                => array(
        'icon'          => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_color'    => 'lightgray',
        'icon_size'     => 'normal',
        'tip_style'     => array(
            'color'   => 'red',
            'shadow'  => true,
            'rounded' => false,
            'style'   => '',
        ),
        'tip_position'  => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect'    => array(
            'show' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'mouseover',
            ),
            'hide' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'click mouseleave',
            ),
        ),
    ),
);

Redux::SetArgs($opt_name, $args);

/*--------------------------------------------------------------
# General
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('General', 'adsett'),
    'icon'   => 'el-icon-home',
    'fields' => array(
        array(
            'id'       => 'favicon',
            'type'     => 'media',
            'title'    => esc_html__('Favicon', 'adsett'),
            'default' => ''
        ),
        array(
            'id'       => 'site_loader',
            'type'     => 'select',
            'title'    => esc_html__('Site Loader', 'adsett'),
            'options' => array(
                '0'  => esc_html__('Off', 'adsett'),
                '1'  => esc_html__('Upload Gif', 'adsett'),
                '2' => esc_html__('Style 2 dots', 'adsett'),
                '3' => esc_html__('Style charging', 'adsett'),
                '4' => esc_html__('Style 2 dots Rotate', 'adsett'),
            ), 
            'default' => '0',
        ),
        array(
            'id'       => 'loading_img',
            'type'     => 'media',
            'title'    => esc_html__('Loading icon image ', 'adsett'),
            'default' => array(
                'url'=>''
            ),
            'required' => array( 'site_loader' , '=', '1' )
        ),
        array(
            'id'       => 'enable_awesome_pro',
            'type'     => 'button_set',
            'title'    => esc_html__('Enable Font Awesome Pro', 'adsett'),
            'options'  => [
                '1'  => esc_html__('Yes','adsett'),
                '0'  => esc_html__('No','adsett'),
            ],
            'default'  => '0',
        ),
        array(
            'id'       => 'stop_split_text_on_mobile',
            'type'     => 'button_set',
            'title'    => esc_html__('Stop Split Text Animation Heading on Mobile', 'adsett'),
            'options'  => array(
                '0' => esc_html__('No', 'adsett'),
                '1' => esc_html__('Yes', 'adsett'),
            ),
            'default'  => '0'
        )
    )
));
Redux::setSection($opt_name, array(
    'title' => esc_html__('Custom Cursor', 'adsett'),
    'icon'  => '',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'enable_cursor',
            'type'     => 'button_set',
            'title'    => esc_html__('Enable Cursor', 'adsett'),
            'options'  => [
                '1'  => esc_html__('Yes','adsett'),
                '0'  => esc_html__('No','adsett'),
            ],
            'default'  => '0',
        ),
        array(
            'id'       => 'hide_cursor_follower',
            'type'     => 'switch',
            'title'    => esc_html__('Hide Outer Follower circle cursor', 'adsett'),
            'default'  => false,
        ), 
        array(
            'id'    => 'cursor_style',
            'type'  => 'select',
            'title' => esc_html__('Style', 'adsett'),
            'options' => [
                'df'            => esc_html__('Default', 'adsett'), 
                'outline'        => esc_html__('Outline', 'adsett'), 
            ],
            'default' => 'df',
            'required' => [ 'enable_cursor', '!=', '0']
        ),
        array(
            'id'       => 'cursor_circle_size',
            'type'     => 'text',
            'title'    => esc_html__('Cursor circle size', 'adsett'),
            'default'  => '20px',
        ), 
        array(
            'id'       => 'cursor_circle_follower_size',
            'type'     => 'text',
            'title'    => esc_html__('Cursor circle follower size', 'adsett'),
            'default'  => '30px',
        ),
        array(
            'id'       => 'blend_mode',
            'type'     => 'select',
            'title'    => esc_html__('Blend Mode', 'adsett'),
            'options' => array(
                'normal'      => esc_html__('Normal', 'adsett'),
                'multiply'    => esc_html__('Multiply', 'adsett'),
                'screen'      => esc_html__('Screen', 'adsett'),
                'overlay'     => esc_html__('Overlay', 'adsett'),
                'darken'      => esc_html__('Darken', 'adsett'),
                'lighten'     => esc_html__('Lighten', 'adsett'),
                'color-dodge' => esc_html__('Color-dodge', 'adsett'),
                'color-burn'  => esc_html__('Color-burn', 'adsett'),
                'difference'  => esc_html__('Difference', 'adsett'),
                'exclusion'   => esc_html__('Exclusion', 'adsett'),
                'hue'         => esc_html__('Hue', 'adsett'),
                'saturation'  => esc_html__('Saturation', 'adsett'),
                'color'       => esc_html__('Color', 'adsett'),
                'luminosity'  => esc_html__('Luminosity', 'adsett'),
            ), 
            'default' => 'difference',
        ),
        array(
            'id'          => 'cursor_circle_bg',
            'type'        => 'color_rgba',
            'title'       => esc_html__('Cursor Circle Background', 'adsett'),
            'default'   => array(
                'rgba'     => '',
                'alpha'     => 1
            ),
        ), 
        array(
            'id'          => 'cursor_follower_circle_bg',
            'type'        => 'color_rgba',
            'title'       => esc_html__('Cursor Follower Circle Background', 'adsett'),
            'default'   => array(
                'rgba'     => '',
                'alpha'     => 1
            ),
        ), 
        array(
            'id'          => 'cursor_follower_active_bg',
            'type'        => 'color_rgba',
            'title'       => esc_html__('Active Background', 'adsett'),
            'default'   => array(
                'rgba'     => '',
                'alpha'     => 1
            ),
        ), 
        array(
            'id'          => 'cursor_active_text_color',
            'type'        => 'color',
            'title'       => esc_html__('Active Text Color', 'adsett'),
            'default'   => '',
            'transparent' => false,
        ), 
        
    )
));
/*--------------------------------------------------------------
# Colors
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Colors', 'adsett'),
    'icon'   => 'el-icon-file-edit',
    'fields' => array(
        array(
            'id'          => 'primary_color',
            'type'        => 'color',
            'title'       => esc_html__('Primary Color', 'adsett'),
            'transparent' => false,
            'default'     => ''
        ), 
        array(
            'id'          => 'second_color',
            'type'        => 'color',
            'title'       => esc_html__('Secondary Color', 'adsett'),
            'transparent' => false,
            'default'     => ''
        ),
        array(
            'id'      => 'link_color',
            'type'    => 'link_color',
            'title'   => esc_html__('Link Colors', 'adsett'),
            'default' => array(
                'regular' => '',
                'hover'   => '',
                'active'  => ''
            ),
            'output'  => array('a')
        ),
    )
));

/*--------------------------------------------------------------
# Header
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Header', 'adsett'),
    'icon'   => 'el-icon-website',
    'fields' => array_merge(
        adsett_header_opts() 
    )
));
 

/*--------------------------------------------------------------
# Page Title area
--------------------------------------------------------------*/
 
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Page Title', 'adsett'),
    'icon'   => 'el-icon-map-marker',
    'fields' => array_merge(
        adsett_page_title_opts(),
        array(
            array(
                'id'       => 'pt_bg_parallax',
                'title'    => esc_html__('Parallax Background', 'adsett'),
                'subtitle' => esc_html__('Scroll parallax effect', 'adsett'),
                'type'     => 'switch',
                'default'  => false,
                'required' => array( 'pt_mode', '!=', 'none')
            ),
            array(
                'id' => 'pt_parallax',
                'type' => 'select',
                'title' => esc_html__( 'Parallax Type', 'adsett' ),
                'options' => [
                    ''        => esc_html__( 'None', 'adsett' ),
                    'x'       => esc_html__( 'Transform X', 'adsett' ),
                    'y'       => esc_html__( 'Transform Y', 'adsett' ),
                    'z'       => esc_html__( 'Transform Z', 'adsett' ),
                    'rotateX' => esc_html__( 'RotateX', 'adsett' ),
                    'rotateY' => esc_html__( 'RotateY', 'adsett' ),
                    'rotateZ' => esc_html__( 'RotateZ', 'adsett' ),
                    'scaleX'  => esc_html__( 'ScaleX', 'adsett' ),
                    'scaleY'  => esc_html__( 'ScaleY', 'adsett' ),
                    'scaleZ'  => esc_html__( 'ScaleZ', 'adsett' ),
                    'scale'   => esc_html__( 'Scale', 'adsett' ),
                ],
                'default' => '',
                'required' => array( 'pt_bg_parallax', '=', true )
            ),
            array(
                'id' => 'pt_parallax_value',
                'title' => esc_html__('Parallax Value', 'adsett' ),
                'type' => 'text',
                'default' => '',
                'required' => array( 'pt_parallax', '!=', '' )
            ),
        ) 
    )
));


/*--------------------------------------------------------------
# Footer
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Footer', 'adsett'),
    'icon'   => 'el el-website',
    'fields' => array_merge(
        adsett_footer_opts()
    )
    
));

/*--------------------------------------------------------------
# WordPress default content
--------------------------------------------------------------*/
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Content', 'adsett'),
    'icon'   => 'el-icon-pencil',
    'fields' => array(
        array(
            'id'       => 'content_bg_color',
            'type'     => 'color_rgba',
            'title'    => esc_html__('Background Color', 'adsett'),
            'subtitle' => esc_html__('Content background color.', 'adsett'),
            'output'   => array('background-color' => '.pxl-main')
        ),
        array(
            'id'             => 'content_padding',
            'type'           => 'spacing',
            'output'         => array('.pxl-main'),
            'right'          => false,
            'left'           => false,
            'mode'           => 'padding',
            'units'          => array('px'),
            'units_extended' => 'false',
            'title'          => esc_html__('Content Padding', 'adsett'),
            'desc'           => esc_html__('Default: Top-100px, Bottom-100px', 'adsett'),
            'default'        => array(
                'padding-top'    => '',
                'padding-bottom' => '',
                'units'          => 'px',
            )
        ),
        array(
            'id'       => 'sidebar_sticky',
            'type'     => 'button_set',
            'title'    => esc_html__('Sidebar Sticky', 'adsett'),
            'options'  => array(
                '0' => esc_html__('Default', 'adsett'),
                '1' => esc_html__('Sticky', 'adsett'),
            ),
            'default'  => '1'
        )
    )
));
Redux::setSection($opt_name, array(
    'title' => esc_html__('Blog Archive', 'adsett'),
    'icon'  => 'el-icon-list',
    'subsection' => true,
    'fields'     => array_merge(
        array(
            array(
                'id'           => 'archive_custom_sub_title',
                'type'         => 'text',
                'title'        => esc_html__( 'Custom Sub title', 'adsett' ),
                'subtitle'     => esc_html__( 'Add short description for blog page title', 'adsett' ),
                'required' => array( 'pt_mode', '!=', 'none' )
            )
        ),
        adsett_sidebar_pos_opts([ 'prefix' => 'blog_']),
        array(
            array(
                'id'       => 'archive_date',
                'title'    => esc_html__('Date', 'adsett'),
                'subtitle' => esc_html__('Display the Date for each blog post.', 'adsett'),
                'type'     => 'switch',
                'default'  => true,
            ),
            array(
                'id'       => 'archive_category',
                'title'    => esc_html__('Category', 'adsett'),
                'subtitle' => esc_html__('Display the Category for each blog post.', 'adsett'),
                'type'     => 'switch',
                'default'  => true,
            ),
            array(
                'id'       => 'archive_author',
                'title'    => esc_html__('Author', 'adsett'),
                'subtitle' => esc_html__('Display the Author for each blog post.', 'adsett'),
                'type'     => 'switch',
                'default'  => false,
            ),
            array(
                'id'       => 'archive_readmore',
                'title'    => esc_html__('Readmore Button', 'adsett'),
                'subtitle' => esc_html__('Display the Readmore button for each blog post.', 'adsett'),
                'type'     => 'switch',
                'default'  => true,
            ),
            array(
                'id'      => 'archive_readmore_text',
                'type'    => 'text',
                'title'   => esc_html__('Read More Text', 'adsett'),
                'default' => '',
                'subtitle' => esc_html__('Default: Read more', 'adsett'),
                'required' => array('archive_readmore', '=', true)
            ),
            array(
                'id'       => 'archive_sticky_mark',
                'title'    => esc_html__('Show Sticky Mark Icon', 'adsett'),
                'subtitle' => esc_html__('Display icon mark for post sticky', 'adsett'),
                'type'     => 'switch',
                'default'  => true,
            ),
        )
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Single Post', 'adsett'),
    'icon'       => 'el-icon-file-edit',
    'subsection' => true,
    'fields'     => array_merge(
        adsett_sidebar_pos_opts([ 'prefix' => 'post_']),
        array(
            array(
                'id'       => 'post_title_on',
                'title'    => esc_html__('Show Page Title', 'adsett'),
                'subtitle' => esc_html__('Show post title on the top of page title', 'adsett'),
                'type'     => 'switch',
                'default'  => '1'
            ),
            array(
                'id'       => 'post_sub_title_on',
                'title'    => esc_html__('Show Sub Title', 'adsett'),
                'subtitle' => esc_html__('Show sub title on the top of page title', 'adsett'),
                'type'     => 'switch',
                'default'  => '0'
            ),
            array(
                'id'       => 'post_feature_image_on',
                'title'    => esc_html__('Feature Image', 'adsett'),
                'subtitle' => esc_html__('Show feature image on single post.', 'adsett'),
                'type'     => 'switch',
                'default'  => '1'
            ),
            array(
                'id'       => 'post_feature_image_type',
                'type'     => 'button_set',
                'title'    => esc_html__('Feature Image Type', 'adsett'),
                'subtitle' => esc_html__('Feature image Type on single post.', 'adsett'),
                'options' => array(
                    'cropped'  => esc_html__('Cropped Image', 'adsett'),
                    'full'  => esc_html__('Full Image', 'adsett')
                ),
                'default' => 'full',
                'required' => [
                    'post_feature_image_on',
                    'equals',
                    '1'
                ]
            ),
            array(
                'id'       => 'post_date',
                'title'    => esc_html__('Date', 'adsett'),
                'subtitle' => esc_html__('Display the Date for blog post.', 'adsett'),
                'type'     => 'switch',
                'default'  => '1'
            ),
            array(
                'id'       => 'post_author',
                'title'    => esc_html__('Author', 'adsett'),
                'subtitle' => esc_html__('Display the Author for blog post.', 'adsett'),
                'type'     => 'switch',
                'default'  => '0'
            ),
            array(
                'id'       => 'post_category',
                'title'    => esc_html__('Categories', 'adsett'),
                'subtitle' => esc_html__('Display the Category for blog post.', 'adsett'),
                'type'     => 'switch',
                'default'  => '1'
            ),
            array(
                'id'       => 'post_tag',
                'title'    => esc_html__('Tags', 'adsett'),
                'subtitle' => esc_html__('Display the Tag for blog post.', 'adsett'),
                'type'     => 'switch',
                'default'  => '1'
            ),
            array(
                'id'       => 'post_social_share',
                'title'    => esc_html__('Social Share', 'adsett'),
                'subtitle' => esc_html__('Display the Social Share for blog post.', 'adsett'),
                'type'     => 'switch',
                'default'  => '0',
            ),
            array(
                'id'       => 'post_social_share_icon',
                'type'     => 'button_set',
                'title'    => esc_html__('Select Social Share', 'adsett'),
                'subtitle' => esc_html__('Show social share on single post.', 'adsett'),
                'multi'    => '1',
                'options' => array(
                    'facebook'  => esc_html__('Facebook', 'adsett'),
                    'twitter'   => esc_html__('Twitter', 'adsett'),
                    'linkedin'  => esc_html__('Linkedin', 'adsett'),
                    'pinterest' => esc_html__('Pinterest', 'adsett'),
                ), 
                'default' => array('facebook', 'twitter', 'linkedin'),
                'required' => [
                   'post_social_share',
                   'equals',
                   '1' 
                ]
            ),
            array(
                'id'       => 'post_author_info',
                'title'    => esc_html__('Author Information', 'adsett'),
                'subtitle' => esc_html__('Display the Author information.', 'adsett'),
                'type'     => 'switch',
                'default'  => '0',
            ),
            array(
                'id'       => 'post_navigation',
                'title'    => esc_html__('Navigation', 'adsett'),
                'subtitle' => esc_html__('Display the Navigation for blog post.', 'adsett'),
                'type'     => 'switch',
                'default'  => '1',
            ),
            array(
                'id'       => 'post_comment',
                'title'    => esc_html__('Post Comments', 'adsett'),
                'subtitle' => esc_html__('Display the Comment form for blog post.', 'adsett'),
                'type'     => 'switch',
                'default'  => '1',
            ),
        )
    )
));
Redux::setSection($opt_name, array(
    'title'      => esc_html__('Portfolio', 'adsett'),
    'icon'       => 'el-icon-list',
    'subsection' => true,
    'fields'     => array_merge(
        array(
            array(
                'id'       => 'portfolio_slug',
                'title'    => esc_html__('Portfolio Slug', 'adsett'),
                'subtitle' => esc_html__('Enter portfolio slug ', 'adsett'),
                'type'     => 'text',
                'default'  => ''
            ),
            array(
                'id'       => 'portfolio_name',
                'title'    => esc_html__('Portfolio Name', 'adsett'),
                'subtitle' => esc_html__('Enter portfolio name ', 'adsett'),
                'type'     => 'text',
                'default'  => ''
            ),
            array(
                'id'       => 'portfolio_archive_link',
                'title'    => esc_html__('Portfolio Archive Custom Link', 'adsett'),
                'subtitle' => esc_html__('Enter portfolio archive custom link ', 'adsett'),
                'type'     => 'text',
                'default'  => ''
            ),
            array(
                'id'             => 'portfolio_content_padding',
                'type'           => 'spacing',
                'output'         => array('.single-portfolio .pxl-main'),
                'right'          => false,
                'left'           => false,
                'mode'           => 'padding',
                'units'          => array('px'),
                'units_extended' => 'false',
                'title'          => esc_html__('Content Padding', 'adsett'),
                'desc'           => esc_html__('Default: Top-100px, Bottom-100px', 'adsett'),
                'default'        => array(
                    'padding-top'    => '',
                    'padding-bottom' => '',
                    'units'          => 'px',
                )
            ),
        )
    )
));
Redux::setSection($opt_name, array(
    'title'      => esc_html__('404 Page', 'adsett'),
    'icon'       => 'el-cog-alt el',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'      => 'template_404',
            'type'    => 'select',
            'title'   => esc_html__('Select 404 Page Template', 'adsett'),
            'desc'    => sprintf(esc_html__('Please create your template before choosing. %sClick Here%s','adsett'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=page' ) ) . '">','</a>'),
            'options' => adsett_list_post('page'),
            'default' => '' 
        )
    )
));

/*--------------------------------------------------------------
# Static template option
--------------------------------------------------------------*/
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Static Template', 'adsett'),
    'icon'   => 'el-icon-file-edit',
    'fields' => array(
        array(
            'id'     => 'template_id_page',
            'title'    => esc_html__('Select pages', 'adsett'),
            'type'     => 'select',
            'multi'    => true,
            'options'  => adsett_list_post('page', false),
        ),
        array(
            'id'       => 'template_id',
            'type'     => 'text',
            'title'    => esc_html__('Enter the Template ID for Pages selected', 'adsett'),
            'desc'    => sprintf(esc_html__('Please create your layout for get template post id. %sClick Here%s','adsett'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-template' ) ) . '">','</a>'),
            'default'  => '',
            'required' => ['template_id_page', '!=', null]
        ),
        array(
            'id'       => 'project_single_on',
            'title'    => esc_html__('Show at bottom of single project ', 'adsett'),
            'type'     => 'switch',
            'default'  => '1'
        ), 
        array(
            'id'       => 'template_id_project',
            'type'     => 'text',
            'title'    => esc_html__('Enter the Template ID for Single Project', 'adsett'),
            'desc'    => sprintf(esc_html__('Please create your layout for get template post id. %sClick Here%s','adsett'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-template' ) ) . '">','</a>'),
            'default'  => '',
            'required' => ['project_single_on', '=', '1']
        ),
         
    )
));
/*--------------------------------------------------------------
# Woocommerce
--------------------------------------------------------------*/
if(class_exists('Woocommerce')) {
    Redux::setSection($opt_name, array(
        'title' => esc_html__('Woocommerce', 'adsett'),
        'icon'  => 'el el-shopping-cart',
        'fields'     => array_merge(
            array(
                array(
                    'title'     => esc_html__('Shop Full Width', 'adsett'),
                    'id'        => 'shop_full_width',
                    'type'      => 'switch',
                    'default'   => false
                )
            ),
            adsett_sidebar_pos_opts([ 'prefix' => 'shop_','default_value' => '0']),
            array(
                array(
                    'id'       => 'shop_display_type',
                    'type'     => 'button_set',
                    'title'    => esc_html__('Display Type', 'adsett'),
                    'options'  => array(
                        'grid' => esc_html__('Grid', 'adsett'),
                        'list' => esc_html__('List', 'adsett'),
                    ),
                    'default'  => 'grid'
                ),
                array(
                    'title'         => esc_html__('Products displayed per row', 'adsett'),
                    'id'            => 'products_columns',
                    'type'          => 'slider',
                    'subtitle'      => esc_html__('Number product to show per row', 'adsett'),
                    'default'       => 3,
                    'min'           => 2,
                    'step'          => 1,
                    'max'           => 6,
                    'display_value' => 'text'
                ),
                array(
                    'title'         => esc_html__('Products displayed per page', 'adsett'),
                    'id'            => 'product_per_page',
                    'type'          => 'slider',
                    'subtitle'      => esc_html__('Number product to show', 'adsett'),
                    'default'       => 12,
                    'min'           => 3,
                    'step'          => 1,
                    'max'           => 28,
                    'display_value' => 'text'
                ),
                array(
                    'id'       => 'product_loop_rating',
                    'title'    => esc_html__('Show Loop Rating', 'adsett'),
                    'subtitle' => esc_html__('Display rating in product loop', 'adsett'),
                    'type'     => 'switch',
                    'default'  => '0',
                ),
                array(
                    'id'       => 'product_image_cropped',
                    'title'    => esc_html__('Image Cropped', 'adsett'),
                    'subtitle' => esc_html__('Crop image for thumbnail, single, gallery', 'adsett'),
                    'type'     => 'switch',
                    'default'  => '1',
                )
            )
        )
    ));

    Redux::setSection($opt_name, array(
        'title'      => esc_html__('Single Product', 'adsett'),
        'icon'       => 'el el-file-edit',
        'subsection' => true,
        'fields'     => array_merge(
            array(
                array(
                    'title'     => esc_html__('Full Width', 'adsett'),
                    'id'        => 'product_full_width',
                    'type'      => 'switch',
                    'default'   => false
                )
            ),
            adsett_sidebar_pos_opts([ 'prefix' => 'product_', 'default' => '0', 'default_value' => '0']),
            array(
                array(
                    'id'       => 'disable_product_title',
                    'type'     => 'button_set',
                    'title'    => esc_html__('Disable Product title', 'adsett'),
                    'options'  => array(
                        '0' => esc_html__('No', 'adsett'),
                        '1' => esc_html__('Yes', 'adsett'),
                    ),
                    'default'  => '1'
                ),
                array(
                    'id'       => 'gallery_layout',
                    'type'     => 'button_set',
                    'title'    => esc_html__('Gallery Layout', 'adsett'),
                    'options'  => array(
                        'simple' => esc_html__('Simple', 'adsett'),
                        'horizontal' => esc_html__('Horizontal', 'adsett'),
                        'vertical' => esc_html__('Vertical', 'adsett'),
                    ),
                    'default'  => 'simple'
                ),
               
                array(
                    'id'       => 'product_variation_style',
                    'type'     => 'button_set',
                    'title'    => esc_html__('Product Variation Style', 'adsett'),
                    'subtitle' => esc_html__('Dropdown or selected list', 'adsett'),
                    'options' => array(
                        'dropdown'  => esc_html__('Dropdown', 'adsett'),
                        'list' => esc_html__('List', 'adsett')
                    ), 
                    'default' => 'dropdown'
                ),
                array(
                    'id'       => 'product_social_share_on',
                    'title'    => esc_html__('Social Share', 'adsett'),
                    'subtitle' => esc_html__('Show social share on single product.', 'adsett'),
                    'type'     => 'switch',
                    'default'  => '0',
                ),
                array(
                    'id'       => 'product_social_share_icon',
                    'type'     => 'button_set',
                    'title'    => esc_html__('Select Social Share', 'adsett'),
                    'subtitle' => esc_html__('Show social share on single product.', 'adsett'),
                    'multi'    => true,
                    'options' => array(
                        'facebook'  => esc_html__('Facebook', 'adsett'),
                        'twitter'   => esc_html__('Twitter', 'adsett'),
                        'linkedin'  => esc_html__('Linkedin', 'adsett'),
                        'pinterest' => esc_html__('Pinterest', 'adsett'),
                    ), 
                    'default' => array('facebook', 'twitter', 'linkedin', 'pinterest'),
                    'required' => [
                       'product_social_share_on',
                       'equals',
                       '1' 
                    ]
                ),   
            ),
            adsett_product_single_opts_wishlist_compare(),
            array(
                array(
                    'id'       => 'product_related',
                    'title'    => esc_html__('Product Related', 'adsett'),
                    'subtitle' => esc_html__('Show/Hide related product', 'adsett'),
                    'type'     => 'switch',
                    'default'  => '1',
                ),
            )
        )
    ));
    Redux::setSection($opt_name, array(
        'title'      => esc_html__('Cart Page', 'adsett'),
        'icon'       => 'el el-shopping-cart-sign',
        'subsection' => true,
        'fields'     => array_merge(
            array(
                array(
                    'id'       => 'cart_cross_sell',
                    'title'    => esc_html__('Cross Sells', 'adsett'),
                    'subtitle' => esc_html__('Show/Hide Cross Sells product', 'adsett'),
                    'type'     => 'switch',
                    'default'  => '1',
                ),
                array(
                    'id'            => 'cart_cross_sell_total',
                    'title'         => esc_html__('Cross Sells Total', 'adsett'),
                    'subtitle'      => esc_html__('Total cross sell product display', 'adsett'),
                    'type'          => 'slider',
                    'default'       => '4',
                    'min'           => 1,
                    'step'          => 1,
                    'max'           => 12,
                    'display_value' => 'label',
                    'required' => [
                        ['cart_cross_sell', '!=', '0'],
                    ]
                ),
                array(
                    'id'            => 'cart_cross_sell_column',
                    'title'         => esc_html__('Cross Sells Columns', 'adsett'),
                    'subtitle'      => esc_html__('Choose your Columns', 'adsett'),
                    'type'          => 'slider',
                    'default'       => '4',
                    'min'           => 1,
                    'step'          => 1,
                    'max'           => 6,
                    'display_value' => 'label',
                    'required' => [
                        ['cart_cross_sell', '!=', '0'],
                    ]
                )
            )
        )
    ));
}
/*--------------------------------------------------------------
# Typography
--------------------------------------------------------------*/
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Typography', 'adsett'),
    'icon'   => 'el-icon-text-width',
    'fields' => array(
        array(
            'id'          => 'font_body',
            'type'        => 'typography',
            'title'       => esc_html__('Body', 'adsett'),
            'google'      => true,
            'line-height' => true,
            'font-size'   => true,
            'text-align'  => false,
            'letter-spacing' => true,
            'units'       => 'px',
        ),
        array(
            'id'             => 'font_heading',
            'type'           => 'typography',
            'title'          => esc_html__('Heading', 'adsett'),
            'google'         => true,
            'line-height'    => true,
            'font-size'      => false,
            'text-align'     => false,
            'letter-spacing' => true,
            'text-transform' => true,
            'units'          => 'em',
        ),
        array(
            'id'          => 'font_h1',
            'type'        => 'text',
            'title'       => esc_html__('H1 Font Size', 'adsett'),
            'default'     => '',
            'placeholder' => '70px'
        ),
        array(
            'id'          => 'font_h2',
            'type'        => 'text',
            'title'       => esc_html__('H2 Font Size', 'adsett'),
            'default'     => '',
            'placeholder' => '48px'
        ),
        array(
            'id'          => 'font_h3',
            'type'        => 'text',
            'title'       => esc_html__('H3 Font Size', 'adsett'),
            'default'     => '',
            'placeholder' => '36px'
        ),
        array(
            'id'          => 'font_h4',
            'type'        => 'text',
            'title'       => esc_html__('H4 Font Size', 'adsett'),
            'default'     => '',
            'placeholder' => '24px'
        ),
        array(
            'id'          => 'font_h5',
            'type'        => 'text',
            'title'       => esc_html__('H5 Font Size', 'adsett'),
            'default'     => '',
            'placeholder' => '18px'
        ),
        array(
            'id'          => 'font_h6',
            'type'        => 'text',
            'title'       => esc_html__('H6 Font Size', 'adsett'),
            'default'     => '',
            'placeholder' => '16px'
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Custom CSS', 'adsett'),
    'icon'       => 'el-icon-css',
    'fields'     => array(
        array(
            'id'       => 'custom_css',
            'type'     => 'ace_editor',
            'title'    => esc_html__( 'CSS Code', 'adsett'),
            'subtitle' => esc_html__( 'Enter your CSS code in the field below. Do not include any tags or HTML in the field. Custom CSS entered here will override the theme CSS. In some cases, the !important tag may be needed. Don\'t URL encode image or svg paths. Contents of this field will be auto encoded.', 'adsett' ),
            'mode'     => 'css',
            'options' => array( 'minLines' => 20, 'maxLines' => 60 )
        ),    
        
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Custom JS', 'adsett'),
    'icon'       => 'el-icon-edit',
    'fields'     => array(
        array(
            'id'       => 'custom_js',
            'type'     => 'ace_editor',
            'title'    => esc_html__( 'JS Code', 'adsett'),
            'subtitle' => esc_html__( 'Enter your JS code in the field below. You can add your Google Analytics Code here. Do not enter any <script> tags in this field.', 'adsett' ),
            'mode'     => 'javascript',
            'options' => array( 'minLines' => 20, 'maxLines' => 60 )
        ),    
        
    )
));