<?php
 
add_action( 'pxl_post_metabox_register', 'adsett_page_options_register' );
function adsett_page_options_register( $metabox ) {
  
	$panels = [
		'post' => [ //post_type
			'opt_name'            => 'post_option',
			'display_name'        => esc_html__( 'Post Settings', 'adsett' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'post_sidebar_setting' => [
					'title'  => esc_html__( 'Post Sidebar Settings', 'adsett' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
						adsett_sidebar_pos_opts(['prefix' => 'post_', 'default' => true, 'default_value' => '-1']) 
					)
				],
				'post_title_setting' => [
					'title'  => esc_html__( 'Post Title Settings', 'adsett' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        adsett_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    ) 
				],
				'post_format_setting' => [
					'title'  => esc_html__( 'Post Format Settings', 'adsett' ),
					'icon'   => 'el el-indent-left',
					'fields' => array(
                        array(
                            'id'          => 'featured-video-url',
                            'type'        => 'text',
                            'title'       => esc_html__( 'Video URL', 'adsett' ),
                            'description' => esc_html__( 'Video will show when set post format is video', 'adsett' ),
                            'validate'    => 'url',
                            'msg'         => 'Url error!',
                        ),
                        array(
                            'id'          => 'featured-audio-url',
                            'type'        => 'text',
                            'title'       => esc_html__( 'Audio URL', 'adsett' ),
                            'description' => esc_html__( 'Audio that will show when set post format is audio', 'adsett' ),
                            'validate'    => 'url',
                            'msg'         => 'Url error!',
                        ),
                        array(
							'id'       => 'featured-gallery',
							'type'     => 'gallery',
							'title'    => esc_html__( 'Gallery Images ', 'adsett' ),
							'subtitle' => esc_html__( 'Upload images or add from media library.', 'adsett' )
						),
                        array(
							'id'      =>'featured-quote-text',
							'type'    => 'textarea',
							'title'   => esc_html__('Quote Text', 'adsett'),
							'default' => '',
                        ),
                        array(
                            'id'          => 'featured-quote-cite',
                            'type'        => 'text',
                            'title'       => esc_html__( 'Quote Cite', 'adsett' ),
                            'description' => esc_html__( 'Quote will show when set post format is quote', 'adsett' ),
                        ),
                        array(
							'id'          => 'featured-link-url',
							'type'        => 'text',
							'title'       => esc_html__( 'Format Link URL', 'adsett' ),
							'description' => esc_html__( 'Link will show when set post format is link', 'adsett' ),
                        ),
                        array(
                            'id'          => 'featured-link-text',
                            'type'        => 'text',
                            'title'       => esc_html__( 'Format Link Text', 'adsett' ),
                        ), 
					)
				],
				
			]
		],
		'page' => [ //post_type
			'opt_name'            => 'pxl_page_options',
			'display_name'        => esc_html__( 'Page Settings', 'adsett' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'Header', 'adsett' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
					        array(
				                'id'       => 'disable_header',
				                'title'    => esc_html__('Disable', 'adsett'),
				                'type'     => 'switch',
				                'default'  => '0',
				            ),
					    ),
				        adsett_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
					        array(
				                'id'       => 'pd_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu Desktop', 'adsett' ),
				                'options'  => adsett_get_nav_menu_slug(),
				                'default' => '-1',
				            ),
				            array(
				                'id'       => 'pm_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu Mobile', 'adsett' ),
				                'options'  => adsett_get_nav_menu_slug(),
				                'default' => '-1',
				            )
					    )
				    )
				],
				 
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'adsett' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        adsett_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
					 
				],
				'content' => [
					'title'  => esc_html__( 'Content', 'adsett' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						adsett_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
							array(
								'id'             => 'content_padding',
								'type'           => 'spacing',
								'output'         => array( '#pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Padding', 'adsett' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							) 
						)  
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'adsett' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        adsett_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'colors' => [
					'title'  => esc_html__( 'Colors', 'adsett' ),
					'icon'   => 'el el-website',
					'fields' => array(
				        array(
				            'id'          => 'primary_color',
				            'type'        => 'color',
				            'title'       => esc_html__('Primary Color', 'adsett'),
				            'transparent' => false,
				            'default'     => ''
				        ), 
				        array(
				            'id'          => 'second_color',
				            'type'        => 'color',
				            'title'       => esc_html__('Secondary Color', 'adsett'),
				            'transparent' => false,
				            'default'     => ''
				        ),
				        array(
				            'id'          => 'heading_color',
				            'type'        => 'color',
				            'title'       => esc_html__('Heading Color', 'adsett'),
				            'transparent' => false,
				            'default'     => ''
				        ),
				        array(
				            'id'      => 'link_color',
				            'type'    => 'link_color',
				            'title'   => esc_html__('Link Colors', 'adsett'),
				            'default' => array(
				                'regular' => '',
				                'hover'   => '',
				                'active'  => ''
				            ),
				            'output'  => array('a')
				        ),
				    )
				],
				'cursor' => [
					'title'  => esc_html__( 'Cursor', 'adsett' ),
					'icon'   => 'el el-website',
					'fields' => array(
				        array(
				            'id'       => 'enable_cursor',
				            'type'     => 'button_set',
				            'title'    => esc_html__('Enable Cursor', 'adsett'),
				            'subtitle' => esc_html__('Inherit for extend theme option', 'adsett'),
				            'options'  => [
								'-1' => esc_html__('Inherit','adsett'),
				                '1'  => esc_html__('Yes','adsett'),
				                '0'  => esc_html__('No','adsett'),
							],
				            'default'  => '-1',
				        ),
				        array(
							'id'    => 'cursor_style',
							'type'  => 'select',
							'title' => esc_html__('Style', 'adsett'),
				            'options' => [
								'df'            => esc_html__('Inherit', 'adsett'), 
								'outline'        => esc_html__('Outline', 'adsett'), 
				            ],
				            'default' => 'df',
				            'required' => [ 'enable_cursor', '!=', '0']
				        ),
				    )
				],

			]
		],
		'portfolio' => [ //post_type
			'opt_name'            => 'portfolio_option',
			'display_name'        => esc_html__( 'Portfolio Settings', 'adsett' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'post_settings' => [
					'title'  => esc_html__( 'Portfolio Settings', 'adsett' ),
					'icon'   => 'el-icon-website',
					'fields' => array(
					 	array(
				            'id'          => 'client',
				            'type'        => 'text',
				            'title'       => esc_html__('Client', 'adsett'),
				            'default'     => ''
				        ),
				        array(
				            'id'          => 'location',
				            'type'        => 'text',
				            'title'       => esc_html__('Location', 'adsett'),
				            'default'     => ''
				        ),
				        array(
					        'id'          => 'date_start',
					        'type'        => 'date',
					        'title'       => esc_html__('Date Start', 'adsett')
					    ),
				        array(
				            'id'          => 'video',
				            'type'        => 'text',
				            'title'       => esc_html__('Video Url', 'adsett'),
				            'default'     => ''
				        ),
				        array(
				            'id'          => 'extra_desc',
				            'type'        => 'textarea',
				            'title'       => esc_html__('Extra Description', 'adsett'),
				            'default'     => ''
				        ),
					)
				]
			]
		],
		'pxl-template' => [ //post_type
			'opt_name'            => 'pxl_hidden_template_options',
			'display_name'        => esc_html__( 'Template Settings', 'adsett' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'general' => [
					'title'  => esc_html__( 'General', 'adsett' ),
					'icon'   => 'el-icon-website',
					'fields' => array(
						array(
							'id'    => 'template_type',
							'type'  => 'select',
							'title' => esc_html__('Type', 'adsett'),
				            'options' => [
								'df'            => esc_html__('Select Type', 'adsett'), 
								'header'        => esc_html__('Header', 'adsett'), 
								'header-mobile' => esc_html__('Header Mobile', 'adsett'), 
								'footer'        => esc_html__('Footer', 'adsett'), 
								'mega-menu'     => esc_html__('Mega Menu', 'adsett'), 
								'page-title'    => esc_html__('Page Title', 'adsett'), 
								'hidden-panel'  => esc_html__('Hidden Panel', 'adsett'), 
								'tab'           => esc_html__('Tab', 'adsett'), 
				            ],
				            'default' => 'df',
				        ),
				        array(
							'id'       => 'template_position',
							'type'     => 'select',
							'title'    => esc_html__('Display Position', 'adsett'),
							'options'  => [
								'left'   => esc_html__('Left Position', 'adsett'),
								'top'    => esc_html__('Top Position', 'adsett'),
								'center' => esc_html__('Center Position (popup)', 'adsett'),
								'right'  => esc_html__('Right Position', 'adsett'),
								'full'   => esc_html__('Full Screen', 'adsett'),
				            ],
							'default'  => 'left',
							'required' => [ 'template_type', '=', 'hidden-panel']
				        ),
				        array(
							'id'       => 'header_position',
							'type'     => 'select',
							'title'    => esc_html__('Header Position', 'adsett'),
							'options'  => [
								'df'   => esc_html__('Default', 'adsett'),
								'fixed-left'    => esc_html__('Fixed Left', 'adsett'),
								'fixed-right' => esc_html__('Fixed Right', 'adsett')
				            ],
							'default'  => 'df',
							'required' => [ 'template_type', '=', 'header']
				        ),
					),
				    
				],
			]
		],
		'pxl-slider' => [ //post_type
			'opt_name'            => 'slide_option',
			'display_name'        => esc_html__( 'Slide Settings', 'adsett' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'post_settings' => [
					'title'  => esc_html__( 'Slide Settings', 'adsett' ),
					'icon'   => 'el-icon-website',
					'fields' => array(
						array(
				            'id'          => 'sub_title',
				            'type'        => 'text',
				            'title'       => esc_html__('Sub Title', 'adsett'),
				            'default'     => ''
				        ),
					 	array(
				            'id'          => 'custom_title',
				            'type'        => 'text',
				            'title'       => esc_html__('Custom Title', 'adsett'),
				            'default'     => ''
				        ),
					)
				]
			]
		], 
	];
 
	$metabox->add_meta_data( $panels );
}
 