<?php 
/**
 * Get Post List 
*/
if(!function_exists('adsett_list_post')){
    function adsett_list_post($post_type = 'post', $default = false){
        $post_list = array();
        $posts = get_posts(array('post_type' => $post_type, 'orderby' => 'date', 'order' => 'ASC', 'posts_per_page' => '-1'));
        if($default){
        	$post_list[-1] = esc_html__( 'Inherit', 'adsett' );
        }
        foreach($posts as $post){
            $post_list[$post->ID] = $post->post_title;
        }
        return $post_list;
    }
}
 
if(!function_exists('adsett_get_templates_option')){
	function adsett_get_templates_option($meta_value = 'df', $default = false){
        $post_list = array();
        if($default && !is_array($default)){
            $post_list[-1] = esc_html__('Inherit','adsett');
        }
        if(is_array($default)){
        	$key = isset($default['key']) ? $default['key'] : '0';
        	$post_list[$key] = !empty($default['value']) ? $default['value'] : esc_html__('None','adsett');
        }
        $args = array(
            'post_type' => 'pxl-template',
            'posts_per_page' => '-1',
            'orderby' => 'date',
            'order' => 'ASC',
            'meta_query' => array(
                array(
                    'key'       => 'template_type',
                    'value'     => $meta_value,
                    'compare'   => '='
                )
            )
        );

        $posts = get_posts($args);
        
        foreach($posts as $post){  
        	$template_type = get_post_meta( $post->ID, 'template_type', true );
        	if($template_type == 'df') continue;
            $post_list[$post->ID] = $post->post_title;
        }
         
        return $post_list;
    }
}
if(!function_exists('adsett_get_templates_option_slug')){
    function adsett_get_templates_option_slug($meta_value = 'df'){
        $post_list = array();
        $args = array(
            'post_type' => 'pxl-template',
            'posts_per_page' => '-1',
            'orderby' => 'date',
            'order' => 'ASC',
            'meta_query' => array(
                array(
                    'key'       => 'template_type',
                    'value'     => $meta_value,
                    'compare'   => '='
                )
            )
        );

        $posts = get_posts($args);
        
        foreach($posts as $post){  
        	$template_type = get_post_meta( $post->ID, 'template_type', true );
        	if($template_type == 'df') continue;

        	//$template_position = get_post_meta( $post->ID, 'template_position', true );

        	//$pos = !empty($template_position) ? $template_position : '';
        	$keys = [$post->post_name, $post->ID];
        	$key = implode('||', $keys);
            $post_list[$key] = $post->post_title;
        }
        return $post_list;
    }
}

if(!function_exists('adsett_get_slider_option')){
    function adsett_get_slider_option(){
        $post_list = array();
         
        $args = array(
            'post_type' => 'pxl-slider',
            'posts_per_page' => '-1',
            'orderby' => 'date',
            'order' => 'ASC',
        );

        $posts = get_posts($args);
        
        foreach($posts as $post){  
            $post_list[$post->ID] = $post->post_title;
        }
         
        return $post_list;
    }
}

if(!function_exists('adsett_get_templates_slug')){
    function adsett_get_templates_slug($meta_value = 'df'){
        $post_list = array();
        $posts = get_posts(
        	array(
        		'post_type' => 'pxl-template', 
        		'orderby' => 'date', 
        		'order' => 'ASC', 
        		'posts_per_page' => '-1',
        		'meta_query' => array(
	                array(
	                    'key'       => 'template_type',
	                    'value'     => $meta_value,
	                    'compare'   => '='
	                )
	            )
        	)
        );
         
        foreach($posts as $post){
        	$template_type = get_post_meta( $post->ID, 'template_type', true );
        	$template_position = get_post_meta( $post->ID, 'template_position', true );
        	$pos = !empty($template_position) ? $template_position : '';
        	if($template_type == 'df') continue;
        	$value_args = [
        		'post_id' => $post->ID, 
        		'title' => $post->post_title,
        		'slug' => $post->post_name,
        		'position' => $pos
        	];

            $post_list[$post->post_name] = $value_args;
        }
        return $post_list;
    }
}



if(!function_exists('adsett_header_opts')){
	function adsett_header_opts($args=[]){
		$args = wp_parse_args($args,[
			'default'         => false,
			'default_value'   => ''
		]);
		
		if($args['default']){  
			$options = [
				'-1' => esc_html__('Default','adsett'),
                '1'  => esc_html__('Yes','adsett'),
                '0'  => esc_html__('No','adsett'),
			];
			$default_value = '-1';
		} else {
			 
			$options = [
				'1'  => esc_html__('Yes','adsett'),
                '0'  => esc_html__('No','adsett'),
			];
			$default_value = '0';
		} 
		$opts = array(
	        array(
				'id'      => 'header_layout',
				'type'    => 'select',
				'title'   => esc_html__('Header Desktop Layout', 'adsett'),
				'desc'    => sprintf(esc_html__('Please create your layout before choosing. %sClick Here%s','adsett'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-template' ) ) . '">','</a>'),
				'options' => adsett_get_templates_option('header',$args['default']),
				'default' => $args['default_value']  
	        ),
	        array(
	            'id'       => 'header_mobile_layout',
	            'type'     => 'select',
	            'title'    => esc_html__('Header Mobile Layout', 'adsett'),
	            'desc'    => sprintf(esc_html__('Please create your layout before choosing. %sClick Here%s','adsett'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-template' ) ) . '">','</a>'),
	            'options'  => adsett_get_templates_option('header-mobile',$args['default']),
	            'default'  => $args['default_value'],
	            'required' => array( 'header_layout' , '!=', '' )  
	        ),  
	        
	    );
	    if(!$args['default']){  
	    	$opts[] = array(
	            'id'       => 'logo_m',
	            'type'     => 'media',
	            'title'    => esc_html__('Logo Mobile', 'adsett'),
	            'default' => array(
	                'url'=>''
	            ),
	            'required' => array( ['header_layout' , '!=', ''], ['header_mobile_layout' , '=', ''] )
	        );
	        $opts[] = array(
	            'id'       => 'logo_mobile_size',
	            'type'     => 'dimensions',
	            'title'    => esc_html__('Logo Size', 'adsett'),
	            'subtitle' => esc_html__('Enter demensions for your logo', 'adsett'),
	            'height'    => false,
	            'unit'     => 'px',
	            'required' => array( 'header_mobile_layout' , '=', '' )
	        ); 
	    }
 
		return $opts;
	}
}
 
if(!function_exists('adsett_page_title_opts')){
	function adsett_page_title_opts($args=[]){
		$args = wp_parse_args($args,[
			'default'         => false,
			'default_value'   => ''
		]);
		if($args['default']){
			$options = [
				'-1' => esc_html__('Default','adsett'),
                '1'  => esc_html__('Yes','adsett'),
                '0'  => esc_html__('No','adsett'),
			];
			$default_value = '-1';
			
		} else {
			$options = [
				'1'  => esc_html__('Yes','adsett'),
                '0'  => esc_html__('No','adsett'),
			];
			$default_value = '0';
		} 
		
		if($args['default']){
			$pt_mode_options = [
				'-1'  => esc_html__('Inherit', 'adsett'),
	            'bd'   => esc_html__('Builder', 'adsett'),
	            'none'  => esc_html__('Disable', 'adsett')
			];
			$pt_mode_default = '-1';
		}else{
			$pt_mode_options = [
				'df'  => esc_html__('Default', 'adsett'),
	            'bd'   => esc_html__('Builder', 'adsett'),
	            'none'  => esc_html__('Disable', 'adsett')
			];
			$pt_mode_default = 'df';
		}

		$opts = array(
		 	array(
                'id'       => 'pt_mode',
                'type'     => 'button_set',
                'title'    => esc_html__('Select Page title Mode', 'adsett'),
                'options' => $pt_mode_options, 
                'default' => $pt_mode_default
            ),
			array(
	            'id'       => 'ptitle_layout',
	            'type'     => 'select',
	            'title'    => esc_html__('Page Title Layout (not empty)', 'adsett'),
	            'subtitle' => esc_html__('Select a layout for page title.', 'adsett'),
	            'options'  => adsett_get_templates_option('page-title',false),
	            'default'  => $args['default_value'],
	            'required' => array( 'pt_mode', '=', 'bd' )
	        ),
	        array(
				'id'       => 'ptitle_bg',
				'type'     => 'background',
				'title'    => esc_html__('Background', 'adsett'),
				'subtitle' => esc_html__('Page title background.', 'adsett'),
				'output'   => array('.pxl-pagetitle .pxl-page-title-bg'),
				'required' => array( 'pt_mode', '!=', 'none' )
	        ),
	        array(
				'id'       => 'ptitle_overlay_color',
				'type'     => 'color_rgba',
				'title'    => esc_html__('Overlay Background Color', 'adsett'),
				'output'   => array('background-color' => '.pxl-pagetitle .pxl-page-title-overlay'),
				'required' => array( 'pt_mode', '!=', 'none' )
	        )
		);
		if($args['default']){
			$custom_opts = [
				[
	                'id'       => 'custom_title_mode',
	                'type'     => 'button_set',
	                'title'    => esc_html__('Custom Title Mode', 'adsett'),
	                'options' => [
						'-1'  => esc_html__('Inherit', 'adsett'),
			            'custom'  => esc_html__('Custom', 'adsett'),
					], 
	                'default' => '-1',
	                'required' => array( 'pt_mode', '!=', 'none' )
	            ], 
				[
                    'id'           => 'custom_title',
                    'type'         => 'text',
                    'title'        => esc_html__( 'Custom Title', 'adsett' ),
                    'subtitle'     => esc_html__( 'Custom heading text title', 'adsett' ),
                    'required' => array( 'custom_title_mode', '=', 'custom')
                ],
                [
	                'id'       => 'custom_sub_title_mode',
	                'type'     => 'button_set',
	                'title'    => esc_html__('Custom Sub Title Mode', 'adsett'),
	                'options' => [
						'-1'  => esc_html__('Inherit', 'adsett'),
			            'custom'  => esc_html__('Custom', 'adsett'),
					], 
	                'default' => '-1',
	                'required' => array( 'pt_mode', '!=', 'none' )
	            ], 
	            [
	                'id'           => 'custom_sub_page_title',
	                'type'         => 'text',
	                'title'        => esc_html__( 'Custom Sub Title Text', 'adsett' ),
	                'subtitle'     => esc_html__( 'Add short description for page title', 'adsett' ),
	                'required' => array( 'custom_sub_title_mode', '=', 'custom')
	            ],
	            [
                    'id'           => 'custom_title_maxwidth',
                    'type'         => 'text',
                    'title'        => esc_html__( 'Custom Title Max Width (650px)', 'adsett' ),
                    'subtitle'     => esc_html__( 'Custom heading text title Max Width', 'adsett' ),
                    'required' => array( 'pt_mode', '!=', 'none' )
                ],
			];
			$opts = array_merge($opts, $custom_opts);
		}else{
			$custom_theme_extra_opts = [
				[
					'id'           => 'custom_sub_title',
	                'type'         => 'text',
	                'title'        => esc_html__( 'Custom Sub title', 'adsett' ),
	                'subtitle'     => esc_html__( 'Add short description for page title', 'adsett' ),
	                'required' => array( 'pt_mode', '!=', 'none')
	            ]
			];
			$opts = array_merge($opts, $custom_theme_extra_opts);
		}
		 
		return $opts;
	}
	
}

if(!function_exists('adsett_footer_opts')){
	function adsett_footer_opts($args=[]){
		$args = wp_parse_args($args,[
			'default'         => false,
			'default_value'   => ''
		]);
		if($args['default']){
			$options = [
				'-1' => esc_html__('Inherit','adsett'),
                '1'  => esc_html__('Yes','adsett'),
                '0'  => esc_html__('No','adsett'),
			];
			$options_type = [
				'-1' => esc_html__('Inherit','adsett'),
                '1'  => esc_html__('Fixed','adsett'),
                '2'  => esc_html__('Absoluted','adsett'),
                '0'  => esc_html__('Nothing','adsett'),
			];
			$default_value = '-1';
		} else {
			$options = [
				'1'  => esc_html__('Yes','adsett'),
                '0'  => esc_html__('No','adsett'),
			];
			$options_type = [
                '1'  => esc_html__('Fixed','adsett'),
                '2'  => esc_html__('Absoluted','adsett'),
                '0'  => esc_html__('Nothing','adsett'),
			];
			$default_value = '0';
		} 
		
		$footer_layout_opts = adsett_get_templates_option('footer', $args['default']);
		if($args['default'])
			$footer_layout_opts[-2] = esc_html__( 'Disable', 'adsett' );
		$opts = array(
	        array(
	            'id'          => 'footer_layout',
	            'type'        => 'select',
	            'title'       => esc_html__('Footer Layout', 'adsett'),
	            'desc'        => sprintf(esc_html__('Please create your layout before choosing. %sClick Here%s','adsett'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-template' ) ) . '">','</a>'),
	            'options'     => $footer_layout_opts,
	            'default'     => $args['default_value'],
	        ),
	        array(
                'title'    => esc_html__('Footer Position', 'adsett'),
                'subtitle' => esc_html__('Make footer fixed or absoluted at bottom?', 'adsett'),
                'id'       => 'footer_position',
                'type'     => 'button_set',
                'options'  => $options_type,
                'default'  => $default_value,
            ),
            array(
                'id'       => 'back_totop_on',
                'type'     => 'button_set',
                'title'    => esc_html__('Enable Back to Top', 'adsett'),
                'options'  => $options,
                'default'  => $default_value,
            )
	    );
 
		return $opts;
	}
}
if(!function_exists('adsett_sidebar_pos_opts')){
	function adsett_sidebar_pos_opts($args=[]){
		$args = wp_parse_args($args,[
			'prefix'        => 'blog_',
			'default'       => false,
			'default_value' => 'right'
		]);

		if($args['default']){
			$options = [
				'-1'    => esc_html__('Inherit','adsett'),
				'left'  => esc_html__('Left','adsett'),
				'right' => esc_html__('Right','adsett'),
				'0'     => esc_html__('Disabled','adsett'),
			];
			 
		} else {
			$options = [
				'left'  => esc_html__('Left','adsett'),
				'right' => esc_html__('Right','adsett'),
				'0'     => esc_html__('Disabled','adsett'),
			]; 
		}  
		$opts = array(
	        array(
	            'id'       => $args['prefix'].'sidebar_pos',
	            'type'     => 'button_set',
	            'title'    => esc_html__('Sidebar Position', 'adsett'),
	            'subtitle' => esc_html__('Select a sidebar position is displayed.', 'adsett'),
	            'options'  => $options,
	            'default'  => $args['default_value'],
	        ),
	    );
 
		return $opts;
	}
}


/* Get list menu */
function adsett_get_nav_menu_slug(){

    $menus = array(
        '-1' => esc_html__('Inherit', 'adsett')
    );

    $obj_menus = wp_get_nav_menus();

    foreach ($obj_menus as $obj_menu){
        $menus[$obj_menu->slug] = $obj_menu->name;
    }
    return $menus;
}

function adsett_product_single_opts_wishlist_compare(){
	$arr = [];
	if(class_exists('WPCleverWoosw'))
		$arr[] = array(
            'id'       => 'product_wishlist',
            'title'    => esc_html__('Show Wishlist', 'adsett'),
            'type'     => 'switch',
            'default'  => '1',
        );
	if(class_exists('WPCleverWoosc'))
		$arr[] = array(
            'id'       => 'product_compare',
            'title'    => esc_html__('Show compare', 'adsett'),
            'type'     => 'switch',
            'default'  => '1',
        );
	return $arr;
}