<?php
/**
 * Helper functions for the theme
 *
 * @package Adsett
 */
  

function adsett_html($html){
    return $html;
}
 
/**
 * Google Fonts
*/
function adsett_fonts_url() {
    $fonts_url = '';
    $fonts     = array();
    $subsets   = 'latin,latin-ext';
    
    if ( 'off' !== _x( 'on', 'Roboto font: on or off', 'adsett' ) ) {
        $fonts[] = 'Roboto:ital,wght@0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900';
    }
     
    if ( 'off' !== _x( 'on', 'Roboto+Condensed font: on or off', 'adsett' ) ) {
        $fonts[] = 'Roboto+Condensed:ital,wght@0,300;0,400;0,700;1,300;1,400;1,700';
    }

    if ( $fonts ) {
        $fonts_url = add_query_arg( array(
            'family' => implode( '&family=', $fonts ),
            'subset' => urlencode( $subsets ),
        ), '//fonts.googleapis.com/css2' );
    }
    return $fonts_url;
}

/*
 * Get page ID by Slug
*/
function adsett_get_id_by_slug($slug, $post_type){
    $content = get_page_by_path($slug, OBJECT, $post_type);
    $id = $content->ID;
    return $id;
}
 
/**
 * get content by slug
 **/
function adsett_get_content_by_slug($slug, $post_type){
    $contents = get_posts(
        array(
            'name'      => $slug,
            'post_type' => $post_type
        )
    );
    if(!empty($contents)){
        $content = $contents[0]->post_content;
    }
 
    echo apply_filters('the_content',  $content);
}
 

function adsett_get_mega_menu_builder_id(){
    $mn_id = [];
    $menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
    if ( is_array( $menus ) && ! empty( $menus ) ) {
        foreach ( $menus as $menu ) {
            if ( is_object( $menu )){
                $menu_obj = get_term( $menu->term_id, 'nav_menu' );
                $menu = wp_get_nav_menu_object( $menu_obj ) ;
                $menu_items = wp_get_nav_menu_items( $menu->term_id, array( 'update_post_term_cache' => false ) );
                foreach ($menu_items as $menu_item) {
                    if( !empty($menu_item->pxl_megaprofile)){
                        $mn_id[] = (int)$menu_item->pxl_megaprofile;
                    }
                }  
            }
        }
    }
    return $mn_id;
}
 

function adsett_hex_rgb($color) {
 
    $default = '0,0,0';
 
    //Return default if no color provided
    if(empty($color))
        return $default; 
 
    //Sanitize $color if "#" is provided 
    if ($color[0] == '#' ) {
        $color = substr( $color, 1 );
    }

    //Check if color has 6 or 3 characters and get values
    if (strlen($color) == 6) {
        $hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
    } elseif ( strlen( $color ) == 3 ) {
        $hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
    } else {
        return $default;
    }

    //Convert hexadec to rgb
    $rgb =  array_map('hexdec', $hex);

    $output = implode(",",$rgb);

    //Return rgb(a) color string
    return $output;
}

add_action( 'show_user_profile', 'adsett_user_fields' );
add_action( 'edit_user_profile', 'adsett_user_fields' );
function adsett_user_fields($user){

    $pxl_author_image = get_user_meta($user->ID, 'pxl_author_image', true);
 
    $user_facebook = get_user_meta($user->ID, 'user_facebook', true);
    $user_twitter = get_user_meta($user->ID, 'user_twitter', true);
    $user_linkedin = get_user_meta($user->ID, 'user_linkedin', true);
    $user_skype = get_user_meta($user->ID, 'user_skype', true);
    $user_google = get_user_meta($user->ID, 'user_google', true);
    $user_youtube = get_user_meta($user->ID, 'user_youtube', true);
    $user_vimeo = get_user_meta($user->ID, 'user_vimeo', true);
    $user_tumblr = get_user_meta($user->ID, 'user_tumblr', true);
    $user_rss = get_user_meta($user->ID, 'user_rss', true);
    $user_pinterest = get_user_meta($user->ID, 'user_pinterest', true);
    $user_instagram = get_user_meta($user->ID, 'user_instagram', true);
    $user_yelp = get_user_meta($user->ID, 'user_yelp', true);

    ?>
     
    <table class="form-table pxl-profile-upload-options">
        <tr>
            <th><label for="pxl_author_image"><?php esc_html_e('Profile Picture Custom', 'adsett'); ?></label></th>
            <td>
                <div class="author-image-wrap">
                    <input type="hidden" class="hide-image-url"
                           id="pxl_author_image"
                           name="pxl_author_image"
                           value="<?php echo esc_attr($pxl_author_image) ?>"/>
                    <div class="pxl-show-image">
                        <?php
                        if ($pxl_author_image != "") {
                            ?>
                            <img src="<?php echo wp_get_attachment_image_url($pxl_author_image) ?>">
                            <?php
                        }
                        ?>
                    </div>
                    <?php
                    if ($pxl_author_image != "") {
                        ?>
                        <a href="#" class="pxl-select-image pxl-btn" style="display: none;"><?php esc_html_e('Select Image', 'adsett'); ?></a>
                        <a href="#" class="pxl-remove-image pxl-btn"><?php esc_html_e('Remove Image', 'adsett'); ?></a>
                        <?php
                    } else {
                        ?>
                        <a href="#" class="pxl-select-image pxl-btn"><?php esc_html_e('Select Image', 'adsett'); ?></a>
                        <a href="#" class="pxl-remove-image pxl-btn" style="display: none;"><?php esc_html_e('Remove Image', 'adsett'); ?></a>
                        <?php
                    }
                    ?>
                </div>
            </td>
        </tr>
    </table>
    
    <h3><?php esc_html_e('Social', 'adsett'); ?></h3>
    <table class="form-table">
        <tr>
            <th><label for="user_facebook"><?php esc_html_e('Facebook', 'adsett'); ?></label></th>
            <td>
                <input id="user_facebook" name="user_facebook" type="text" value="<?php echo esc_attr(isset($user_facebook) ? $user_facebook : ''); ?>" />
            </td>
        </tr>
        <tr>
            <th><label for="user_twitter"><?php esc_html_e('Twitter', 'adsett'); ?></label></th>
            <td>
                <input id="user_twitter" name="user_twitter" type="text" value="<?php echo esc_attr(isset($user_twitter) ? $user_twitter : ''); ?>" />
            </td>
        </tr>
        <tr>
            <th><label for="user_linkedin"><?php esc_html_e('Linkedin', 'adsett'); ?></label></th>
            <td>
                <input id="user_linkedin" name="user_linkedin" type="text" value="<?php echo esc_attr(isset($user_linkedin) ? $user_linkedin : ''); ?>" />
            </td>
        </tr>
        <tr>
            <th><label for="user_skype"><?php esc_html_e('Skype', 'adsett'); ?></label></th>
            <td>
                <input id="user_skype" name="user_skype" type="text" value="<?php echo esc_attr(isset($user_skype) ? $user_skype : ''); ?>" />
            </td>
        </tr>
        <tr>
            <th><label for="user_google"><?php esc_html_e('Google', 'adsett'); ?></label></th>
            <td>
                <input id="user_google" name="user_google" type="text" value="<?php echo esc_attr(isset($user_google) ? $user_google : ''); ?>" />
            </td>
        </tr>
        <tr>
            <th><label for="user_youtube"><?php esc_html_e('Youtube', 'adsett'); ?></label></th>
            <td>
                <input id="user_youtube" name="user_youtube" type="text" value="<?php echo esc_attr(isset($user_youtube) ? $user_youtube : ''); ?>" />
            </td>
        </tr>
        <tr>
            <th><label for="user_vimeo"><?php esc_html_e('Vimeo', 'adsett'); ?></label></th>
            <td>
                <input id="user_vimeo" name="user_vimeo" type="text" value="<?php echo esc_attr(isset($user_vimeo) ? $user_vimeo : ''); ?>" />
            </td>
        </tr>
        <tr>
            <th><label for="user_tumblr"><?php esc_html_e('Tumblr', 'adsett'); ?></label></th>
            <td>
                <input id="user_tumblr" name="user_tumblr" type="text" value="<?php echo esc_attr(isset($user_tumblr) ? $user_tumblr : ''); ?>" />
            </td>
        </tr>
        <tr>
            <th><label for="user_rss"><?php esc_html_e('Rss', 'adsett'); ?></label></th>
            <td>
                <input id="user_rss" name="user_rss" type="text" value="<?php echo esc_attr(isset($user_rss) ? $user_rss : ''); ?>" />
            </td>
        </tr>
        <tr>
            <th><label for="user_pinterest"><?php esc_html_e('Pinterest', 'adsett'); ?></label></th>
            <td>
                <input id="user_pinterest" name="user_pinterest" type="text" value="<?php echo esc_attr(isset($user_pinterest) ? $user_pinterest : ''); ?>" />
            </td>
        </tr>
        <tr>
            <th><label for="user_instagram"><?php esc_html_e('Instagram', 'adsett'); ?></label></th>
            <td>
                <input id="user_instagram" name="user_instagram" type="text" value="<?php echo esc_attr(isset($user_instagram) ? $user_instagram : ''); ?>" />
            </td>
        </tr>
        <tr>
            <th><label for="user_yelp"><?php esc_html_e('Yelp', 'adsett'); ?></label></th>
            <td>
                <input id="user_yelp" name="user_yelp" type="text" value="<?php echo esc_attr(isset($user_yelp) ? $user_yelp : ''); ?>" />
            </td>
        </tr>
    </table>
    <?php
}
/**
 * Save user custom fields.
 */
add_action( 'personal_options_update', 'adsett_save_user_custom_fields' );
add_action( 'edit_user_profile_update', 'adsett_save_user_custom_fields' );
function adsett_save_user_custom_fields( $user_id ){

    if ( !current_user_can( 'edit_user', $user_id ) )
        return false;
 
    if(isset($_POST['pxl_author_image'])) {
        update_user_meta( $user_id, 'pxl_author_image', sanitize_text_field($_POST['pxl_author_image'] ));
    }

    if(isset($_POST['user_facebook']))
        update_user_meta( $user_id, 'user_facebook', sanitize_text_field($_POST['user_facebook'] ));
    if(isset($_POST['user_twitter']))
        update_user_meta( $user_id, 'user_twitter', sanitize_text_field($_POST['user_twitter'] ));
    if(isset($_POST['user_linkedin']))
        update_user_meta( $user_id, 'user_linkedin', sanitize_text_field($_POST['user_linkedin'] ));
    if(isset($_POST['user_skype']))
        update_user_meta( $user_id, 'user_skype', sanitize_text_field($_POST['user_skype'] ));
    if(isset($_POST['user_google']))
        update_user_meta( $user_id, 'user_google', sanitize_text_field($_POST['user_google'] ));
    if(isset($_POST['user_youtube']))
        update_user_meta( $user_id, 'user_youtube', sanitize_text_field($_POST['user_youtube'] ));
    if(isset($_POST['user_vimeo']))
        update_user_meta( $user_id, 'user_vimeo', sanitize_text_field($_POST['user_vimeo'] ));
    if(isset($_POST['user_rss']))
        update_user_meta( $user_id, 'user_rss', sanitize_text_field($_POST['user_rss'] ));
    if(isset($_POST['user_pinterest']))
        update_user_meta( $user_id, 'user_pinterest', sanitize_text_field($_POST['user_pinterest'] ));
    if(isset($_POST['user_instagram']))
        update_user_meta( $user_id, 'user_instagram', sanitize_text_field($_POST['user_instagram'] ));
     
}
/* Author Social */
function adsett_get_user_social() {
    $user_facebook = get_user_meta(get_the_author_meta( 'ID' ), 'user_facebook', true);
    $user_twitter = get_user_meta(get_the_author_meta( 'ID' ), 'user_twitter', true);
    $user_linkedin = get_user_meta(get_the_author_meta( 'ID' ), 'user_linkedin', true);
    $user_skype = get_user_meta(get_the_author_meta( 'ID' ), 'user_skype', true);
    $user_google = get_user_meta(get_the_author_meta( 'ID' ), 'user_google', true);
    $user_youtube = get_user_meta(get_the_author_meta( 'ID' ), 'user_youtube', true);
    $user_vimeo = get_user_meta(get_the_author_meta( 'ID' ), 'user_vimeo', true);
    $user_rss = get_user_meta(get_the_author_meta( 'ID' ), 'user_rss', true);
    $user_pinterest = get_user_meta(get_the_author_meta( 'ID' ), 'user_pinterest', true);
    $user_instagram = get_user_meta(get_the_author_meta( 'ID' ), 'user_instagram', true);
    
    ?>
    <div class="user-social d-flex align-items-center gxm-30">
        <?php if(!empty($user_facebook)) { ?>
            <a href="<?php echo esc_url($user_facebook); ?>"><?php echo esc_html__( 'Facebook', 'adsett' ) ?></a>
        <?php } ?>
        <?php if(!empty($user_google)) { ?>
            <a href="<?php echo esc_url($user_google); ?>"><?php echo esc_html__( 'Google', 'adsett' ) ?></a>
        <?php } ?>
        <?php if(!empty($user_twitter)) { ?>
            <a href="<?php echo esc_url($user_twitter); ?>"><?php echo esc_html__( 'Twitter', 'adsett' ) ?></a>
        <?php } ?>
        <?php if(!empty($user_linkedin)) { ?>
            <a href="<?php echo esc_url($user_linkedin); ?>"><?php echo esc_html__( 'Linked In', 'adsett' ) ?></a>
        <?php } ?>
        <?php if(!empty($user_rss)) { ?>
            <a href="<?php echo esc_url($user_rss); ?>"><?php echo esc_html__( 'RSS', 'adsett' ) ?></a>
        <?php } ?>
        <?php if(!empty($user_instagram)) { ?>
            <a href="<?php echo esc_url($user_instagram); ?>"><?php echo esc_html__( 'Instagram', 'adsett' ) ?></a>
        <?php } ?>
        <?php if(!empty($user_skype)) { ?>
            <a href="<?php echo esc_url($user_skype); ?>"><?php echo esc_html__( 'Skype', 'adsett' ) ?></a>
        <?php } ?>
        <?php if(!empty($user_pinterest)) { ?>
            <a href="<?php echo esc_url($user_pinterest); ?>"><?php echo esc_html__( 'Pinterest', 'adsett' ) ?></a>
        <?php } ?>
        <?php if(!empty($user_vimeo)) { ?>
            <a href="<?php echo esc_url($user_vimeo); ?>"><?php echo esc_html__( 'Vimeo', 'adsett' ) ?></a>
        <?php } ?>
        <?php if(!empty($user_youtube)) { ?>
            <a href="<?php echo esc_url($user_youtube); ?>"><?php echo esc_html__( 'Youtube', 'adsett' ) ?></a>
        <?php } ?>
           
    </div> <?php
}

