<?php
/**
 * Filters hook for the theme
 *
 * @package Adsett
 */
add_filter( 'pxl_server_info', 'adsett_add_server_info');
function adsett_add_server_info($infos){
	$infos = [
		'api_url' => 'https://api.casethemes.net/',
		'docs_url' => 'https://doc.casethemes.net/adsett/',
		'plugin_url' => 'https://api.casethemes.net/plugins/',
		'demo_url' => 'https://demo.casethemes.net/adsett/',
		'support_url' => 'https://casethemes.ticksy.com/',
		'help_url' => 'https://doc.casethemes.net/',
		'email_support' => '#',
		'video_url' => '#'
	];
  
	return $infos;
}

add_filter( 'pxl_set_dev_mode', 'adsett_set_dev_mode' );
function adsett_set_dev_mode($value){
	$value = true;
	return $value;
}

add_filter( 'body_class', 'adsett_body_classes' );
function adsett_body_classes( $classes ){   
	$enable_cursor          = adsett()->get_opt('enable_cursor', '0');
	$cursor_style           = adsett()->get_opt('cursor_style', 'df');
    $footer_position = adsett()->get_opt('footer_position', '0');
    $stop_split_text_on_mobile = adsett()->get_theme_opt('stop_split_text_on_mobile', '0');


    if (class_exists('Pxltheme_Core')) {
        $classes[] = 'theme-core';
    }
    if($footer_position == '1') 
    	$classes[] = 'footer-fixed';
 	
    if($enable_cursor == '1'){
    	$classes[] = 'enable-cursor';
    }
    if($cursor_style != 'df'){
    	$classes[] = 'cursor-'.$cursor_style;
    }
    if($stop_split_text_on_mobile == '1'){
    	$classes[] = 'stop-splittext-anm';
    }
 
    return $classes;
}
add_filter( 'pxl_page_class', 'adsett_page_classes' );
function adsett_page_classes($str_cls){
	$header_layout	= (int)adsett()->get_opt('header_layout');
	if ($header_layout > 0){
    	$header_position = get_post_meta( $header_layout, 'header_position', true );
    	if(!empty($header_position))
    		$str_cls .= ' header-pos-'.$header_position;
    }
    return $str_cls;
}
 
add_filter('pxl-register-widgets-folder','adsett_register_widgets_path');
function adsett_register_widgets_path($path){
    $path = get_template_directory() . '/elements/register/';
    return $path;
}

/* Post Type Support Elementor*/
add_filter( 'pxl_add_cpt_support', 'adsett_add_cpt_support' );
function adsett_add_cpt_support($cpt_support) { 
    $cpt_support[] = 'portfolio';
    $cpt_support[] = 'pxl-slider';
    return $cpt_support;
}


add_filter( 'pxl_extra_post_types', 'adsett_add_posttype' );
function adsett_add_posttype( $postypes ) {
	$portfolio_slug = adsett()->get_theme_opt('portfolio_slug', 'portfolio'); 
	$portfolio_name = adsett()->get_theme_opt('portfolio_name', esc_html__( 'Portfolio', 'adsett' )); 
	$postypes['portfolio'] = array(
		'status' => true,
		'item_name'  => $portfolio_name,
		'items_name' => $portfolio_name,
		'args'       => array(
			'supports'           => array(
                'title',
                'editor',
                'thumbnail',
                'excerpt',
            ),
			'rewrite'             => array(
                'slug'       => $portfolio_slug,
 		 	)
		),
	);
    $postypes['pxl-slider'] = [
        'status'     => true,
        'item_name'  => esc_html__('Slider Builder', 'adsett'),
		'items_name' => esc_html__('Slider Builder', 'adsett'),
        'args'       => array(
            'supports'           => array(
                'title',
                'editor',
                'thumbnail',
            ),
            'public'             => true,
            'publicly_queryable' => true,
            'show_in_nav_menus'   => false
        ),
        'labels'     => array()
    ]; 
	return $postypes;
}

add_filter( 'pxl_extra_taxonomies', 'adsett_add_tax' );
function adsett_add_tax( $taxonomies ) {
	$taxonomies['portfolio-category'] = array(
		'status'     => true,
		'post_type'  => array( 'portfolio' ),
		'taxonomy'   => 'Portfolio Categories',
		'taxonomies' => 'Portfolio Categories',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'portfolio-category'
 		 	),
		),
		'labels'     => array()
	);
	
	return $taxonomies;
}

add_filter( 'pxl_theme_builder_post_types', 'adsett_theme_builder_post_type' );
function adsett_theme_builder_post_type($postypes){
	//default is pxl-template
	$postypes[] = 'pxl-slider';
	return $postypes;
}

add_filter( 'pxl_theme_builder_layout_ids', 'adsett_theme_builder_layout_id' );
function adsett_theme_builder_layout_id($layout_ids){
	//default [], 
	$header_layout        = (int)adsett()->get_opt('header_layout');
	$header_mobile_layout = (int)adsett()->get_opt('header_mobile_layout');
	$ptitle_layout 	      = (int)adsett()->get_opt('ptitle_layout');
	$footer_layout        = (int)adsett()->get_opt('footer_layout');
	if( $header_layout > 0) 
		$layout_ids[] = $header_layout;
	if( $header_mobile_layout > 0) 
		$layout_ids[] = $header_mobile_layout;
	if( $ptitle_layout > 0) 
		$layout_ids[] = $ptitle_layout;
	if( $footer_layout > 0) 
		$layout_ids[] = $footer_layout;

	$hidden_template = adsett_get_templates_option('hidden-panel');
	if( count($hidden_template) > 0){
		foreach ($hidden_template as $key => $value) {
			$layout_ids[] = $key;
		}
	}
	
	$mega_menu_id = adsett_get_mega_menu_builder_id();
	if(!empty($mega_menu_id))
		$layout_ids = array_merge($layout_ids, $mega_menu_id);

	$template_id = (int)adsett()->get_theme_opt('template_id','');
	$template_id_project = (int)adsett()->get_theme_opt('template_id_project','');

	if( $template_id > 0) 
		$layout_ids[] = $template_id;
	if( $template_id_project > 0) 
		$layout_ids[] = $template_id_project;
	 
	return $layout_ids;
}
 
add_filter( 'pxl_wg_get_source_id_builder', 'adsett_wg_get_source_builder' );
function adsett_wg_get_source_builder($wg_datas){
	$wg_datas['pxl_slider'] = 'slider_source';
	$wg_datas['pxl_tabs'] = ['control_name' => 'tabs_list', 'source_name' => 'content_template'];
	return $wg_datas;
}

 
add_filter( 'pxl_template_type_support', 'adsett_template_type_support' );
function adsett_template_type_support($type){
	//default ['header','footer','mega-menu']
	$extra_type = [
		'header-mobile' => esc_html__('Header Mobile', 'adsett'), 
		'page-title'    => esc_html__('Page Title', 'adsett'), 
		'hidden-panel'  => esc_html__('Hidden Panel', 'adsett'), 
		'tab'           => esc_html__('Tab', 'adsett'), 
	];
	$template_type = array_merge($type,$extra_type); 
	return $template_type;
}
  
add_filter( 'get_the_archive_title', 'adsett_archive_title_remove_label' );
function adsett_archive_title_remove_label( $title ) {
	if ( is_category() ) {
		$title = single_cat_title( '', false );
	} elseif ( is_tag() ) {
		$title = single_tag_title( '', false );
	} elseif ( is_author() ) {
		$title = get_the_author();
	} elseif ( is_post_type_archive() ) {
		$title = post_type_archive_title( '', false );
	} elseif ( is_tax() ) {
		$title = single_term_title( '', false );
	} elseif ( is_home() ) {
		$title = single_post_title( '', false );
	}

	return $title;
}

add_filter( 'pxl_menu_edit', 'adsett_pxl_menu_edit' );
function adsett_pxl_menu_edit( $menu_meta_extra ) {
	$menu_meta_extra['pxl-custom-class'] = [
		'allow_primary' => true,
		'lever_support' => [0],
		'label' => esc_html__( 'Custom Class', 'adsett' ),
		'options' => [
			'' => esc_html__( 'None', 'adsett' ),
			'mn-home-item' => esc_html__( 'Menu Home Item', 'adsett' )
		]
	];  
	return $menu_meta_extra;
}

add_filter( 'comment_reply_link', 'adsett_comment_reply_text' );
function adsett_comment_reply_text( $link ) {
	$link = str_replace( 'Reply', ''.esc_attr__('Reply', 'adsett').'', $link );
	return $link;
}
 

add_filter( 'pxl_enable_megamenu', 'adsett_enable_megamenu' );
function adsett_enable_megamenu() {
	return true;
}
add_filter( 'pxl_enable_onepage', 'adsett_enable_onepage' );
function adsett_enable_onepage() {
	return true;
}

add_filter( 'pxl_support_awesome_pro', 'adsett_support_awesome_pro' );
function adsett_support_awesome_pro() {
	$enable_awesome_pro = adsett()->get_theme_opt('enable_awesome_pro', '0');
	if( $enable_awesome_pro == '1')
		return true;
	return false;
}
 
add_filter( 'redux_pxl_iconpicker_field/get_icons', 'adsett_add_icons_to_pxl_iconpicker_field' );
function adsett_add_icons_to_pxl_iconpicker_field($icons){
	$custom_icons = []; //'Flaticon' => array(array('flaticon-marker' => 'flaticon-marker')),
	$icons = array_merge($custom_icons, $icons);
	return $icons;
}


add_filter("pxl_mega_menu/get_icons", "adsett_add_icons_to_megamenu");
function adsett_add_icons_to_megamenu($icons){
	$custom_icons = []; //'Flaticon' => array(array('flaticon-marker' => 'flaticon-marker')),
	$icons = array_merge($custom_icons, $icons);
	return $icons;
}
 

/**
 * Move comment field to bottom
 */
add_filter( 'comment_form_fields', 'adsett_comment_field_to_bottom' );
function adsett_comment_field_to_bottom( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	$fields['comment'] = $comment_field;
	return $fields;
}

/** 
 * Custom Widget Archive 
 * This code filters the Archive widget to include the post count inside the link 
 * @since 1.0.0
*/
if(!function_exists('adsett_get_archives_link_text')){
    add_filter('get_archives_link', 'adsett_get_archives_link_text', 10, 6);
    function adsett_get_archives_link_text($link_html, $url, $text, $format, $before, $after ){
        $text = wptexturize( $text );
        $url  = esc_url( $url );
     
        if ( 'link' == $format ) {
            $link_html = "\t<link rel='archives' title='" . esc_attr( $text ) . "' href='$url' />\n";
        } elseif ( 'option' == $format ) {
            $link_html = "\t<option value='$url'>$before $text $after</option>\n";
        } elseif ( 'html' == $format ) {
            $link_html = "\t<li>$before<a href='$url'><span class='title'>$text</span></a>$after</li>\n";
        } else { // custom
            $link_html = "\t$before<a href='$url'><span class='title'>$text</span>$after</a>\n";
        }
        return $link_html;
    }
}

if(!function_exists('adsett_archive_count_span')){
    add_filter('get_archives_link', 'adsett_archive_count_span');
    function adsett_archive_count_span($links) {
        $links = str_replace('<li>', '<li class="pxl-list-item pxl-archive-item">', $links);
        $links = str_replace('</a>&nbsp;(', ' <span class="count">', $links);
        $links = str_replace(')</li>', '</span></a></li>', $links);
        return $links;
    }
}
 
function adsett_add_sub_menu_toggle( $output, $item, $depth, $args ) {
	if ( in_array( 'menu-item-has-children', $item->classes, true ) ) {
		$output .= '<span class="main-menu-toggle"></span>';
	}
	return $output;
}
add_filter( 'walker_nav_menu_start_el', 'adsett_add_sub_menu_toggle', 10, 4 );

/* ------Disable Lazy loading---- */
add_filter( 'wp_lazy_loading_enabled', '__return_false' );

//demo data
add_filter( 'pxl_export_wp_settings', 'adsett_export_wp_settings' );
function adsett_export_wp_settings($wp_options){
	$wp_options[] = 'mc4wp_default_form_id';
	return $wp_options;
}


/* start add option for Default Avatar */
if (function_exists('add_allowed_options')) {
    add_filter('allowed_options', 'adsett_whitelist_options', 10);
} else {
    add_filter('whitelist_options', 'adsett_whitelist_options', 10);
}


function adsett_whitelist_options($options){
	$options['discussion'][] = 'pxl_df_avata_image';
    return $options;
}

add_action('admin_init', 'adsett_add_options');
function adsett_add_options(){
	add_option('pxl_df_avata_image', "");
}

add_filter('default_avatar_select', 'adsett_set_theme_avatar_default_opt', 10);
function adsett_set_theme_avatar_default_opt($avatar_list){
	$pxlua_list = "";
	$pxl_df_avata_image = get_option( 'pxl_df_avata_image', '' );
	$pxlua_list .='<div class="author-image-wrap">
		<label for="pxl_author_image">'. esc_html__( 'Default Avatar Image', 'adsett').'</label>
        <input type="hidden" class="hide-image-url"
               id="pxl_df_avata_image"
               name="pxl_df_avata_image"
               value="'. esc_attr($pxl_df_avata_image) .'"/>
        <div class="pxl-show-image">';
            if ($pxl_df_avata_image != "")
                $pxlua_list .='<img src="'. wp_get_attachment_image_url($pxl_df_avata_image) .'">';
        $pxlua_list .='</div>';
        
        if ($pxl_df_avata_image != "") {
            $pxlua_list .='<a href="#" class="pxl-select-image pxl-btn" style="display: none;">'. esc_html__('Select Image', 'adsett') .'</a>';
            $pxlua_list .='<a href="#" class="pxl-remove-image pxl-btn">'. esc_html__('Remove Image', 'adsett') .'</a>';
        } else {
            $pxlua_list .='<a href="#" class="pxl-select-image pxl-btn">'. esc_html__('Select Image', 'adsett') .'</a>';
            $pxlua_list .='<a href="#" class="pxl-remove-image pxl-btn" style="display: none;">'. esc_html__('Remove Image', 'adsett') .'</a>';
        }
         
    $pxlua_list .='</div>';
	return $pxlua_list . '<div id="wp-avatars">' . $avatar_list . '</div>';
}
/* end add option for Default Avatar */ 

/* update user avatar image with pxl_author_image user meta */  
add_filter( 'get_avatar_data', 'adsett_update_custom_user_avatar', 10, 2);
function adsett_update_custom_user_avatar($args, $id_or_email){
	$pxl_author_image = '';
	if(!is_object($id_or_email))  
		$pxl_author_image = get_user_meta($id_or_email, 'pxl_author_image', true);
	if(is_object($id_or_email) && $id_or_email->user_id > 0)
		$pxl_author_image = get_user_meta($id_or_email->user_id, 'pxl_author_image', true);
 	 
	if(!empty($pxl_author_image)){
		$image_url = wp_get_attachment_image_url( $pxl_author_image, 'thumbnail' );
		$args['url'] = $image_url;
	}
	 
	return $args;  
}

/* set comment list default avatar with custom image option pxl_df_avata_image */ 
add_filter( 'get_avatar', 'adsett_get_avatar', 10, 6 );
function adsett_get_avatar($avatar, $id_or_email, $size, $default, $alt, $args){ 
	if( (is_object($id_or_email) && $id_or_email->user_id == 0) ){
		$pxl_df_avata_image = get_option( 'pxl_df_avata_image', '' );
		if( !empty($pxl_df_avata_image) ){
			$avtdfurl = wp_get_attachment_image_url($pxl_df_avata_image);
			$avatar = sprintf(
				"<img alt='%s' src='%s' srcset='%s' class='%s' height='%d' width='%d' %s/>",
				esc_attr( $args['alt'] ),
				esc_url( $avtdfurl ),
				esc_url( $avtdfurl ) . ' 2x',
				esc_attr( 'avatar avatar-df photo' ),
				(int) $args['height'],
				(int) $args['width'],
				''
			);
		}
	}
	return $avatar;
}

add_filter( 'post_type_archive_link', 'adsett_get_post_type_archive_link', 10, 2 );
function adsett_get_post_type_archive_link($link, $post_type){
	if( $post_type == 'portfolio'){
		$port_archive_link = adsett()->get_theme_opt('portfolio_archive_link', '');
        if( !empty($port_archive_link) ){ 
			$link = $port_archive_link;
		}
	}
	return $link;
}

add_filter( 'pxl-e-font-icon-svg-force-inactive', 'adsett_inactive_e_font_icon_svg' );
function adsett_inactive_e_font_icon_svg() {
	return true;
}