<?php
// make some configs
if(!function_exists('adsett_configs')){
    function adsett_configs($value){ 
        $body_font    = '\'Roboto\', sans-serif';
        $heading_font = '\'Roboto Condensed\', sans-serif';
        
        $heading_color = !empty( adsett()->get_page_opt('heading_color','')) ? adsett()->get_page_opt('heading_color','') : adsett()->get_opt('font_heading', ['color' => '#010101'], 'color');  //#313131
        $custom_pagetitle_maxwidth = !empty( adsett()->get_page_opt('custom_title_maxwidth','')) ? adsett()->get_page_opt('custom_title_maxwidth','100%') : '100%';  
        $configs = [
            'theme_colors' => [
                'primary'   => [
                    'title' => esc_html__('Primary', 'adsett').' ('.adsett()->get_opt('primary_color', '#906e49').')', //86673b
                    'value' => adsett()->get_opt('primary_color', '#906e49')
                ],
                'second'   => [
                    'title' => esc_html__('Secondary', 'adsett').' ('.adsett()->get_opt('second_color', '#010101').')', 
                    'value' => adsett()->get_opt('second_color', '#010101')
                ], 
                'body'     => [
                    'title' => esc_html__('Body', 'adsett').' ('.adsett()->get_opt('font_body', ['color' => '#646464'], 'color').')', 
                    'value' => adsett()->get_opt('font_body', ['color' => '#646464'],'color')
                ],
                'heading'     => [
                    'title' => esc_html__('Heading', 'adsett').' ('.$heading_color.')', 
                    'value' => $heading_color
                ],
                'white'     => [
                    'title' => esc_html__('White', 'adsett') . '(#ffffff)',
                    'value' => '#ffffff'
                ],
                'black'     => [
                    'title' => esc_html__('Black', 'adsett'). '(#000000)',
                    'value' => '#000000'
                ]
            ],
            'link' => [
                'color' => adsett()->get_opt('link_color', ['regular' => 'var(--heading-color)'],'regular'),
                'color-hover'   => adsett()->get_opt('link_color', ['hover' => 'var(--primary-color)'],'hover'),
                'color-active'  => adsett()->get_opt('link_color', ['active' => 'var(--primary-color)'],'active'),
            ],
            'thumbnails' => [ 
                'thumbnail'    => [
                    'thumbnail_size_w'    => 300,
                    'thumbnail_size_h'    => 300,
                    'thumbnail_crop'      => 1,
                ], //sidebar gallery
                'medium'       => [
                    'medium_size_w'       => 770,  
                    'medium_size_h'       => 450,
                    'medium_crop'         => 1,
                ], //blog standard    
                'large'        => [
                    'large_size_w'        => 1170,  
                    'large_size_h'        => 570,
                    'large_crop'          => 1, 
                ] //blog single 
            ],
            'custom_sizes' => [
                'size-custom-1'      => [400, 350, true], //blog recent posts widget
                //'size-custom-2'      => [540, 700, true], //blog masonry
            ], 
            'body' => [
                'font-family'       => adsett()->get_theme_opt('font_body',['font-family' => $body_font], 'font-family'),
                'font-size'         => adsett()->get_theme_opt('font_body',['font-size' => '18px'], 'font-size'),
                'font-weight'       => adsett()->get_theme_opt('font_body',['font-weight' => '400'], 'font-weight'),
                'line-height'       => adsett()->get_theme_opt('font_body',['line-height' => '1.66666666667'], 'line-height'),
                'letter-spacing'    => adsett()->get_theme_opt('font_body',['letter-spacing' => '0px'], 'letter-spacing'),
            ],
            'heading' => [
                'font-family'       => adsett()->get_theme_opt('font_heading',['font-family' => $heading_font], 'font-family'),
                'font-weight'       => adsett()->get_theme_opt('font_heading',['font-weight' => '400'], 'font-weight'),
                'line-height'       => adsett()->get_theme_opt('font_heading',['line-height' => '1.14583333333'], 'line-height'),
                'letter-spacing'    => adsett()->get_theme_opt('font_heading',['letter-spacing' => '0.05em'], 'letter-spacing'),
                'color-hover'       => 'var(--primary-color)',
            ],
            'heading_font_size' => [
                'h1' => adsett()->get_theme_opt('font_h1','70px'),
                'h2' => adsett()->get_theme_opt('font_h2','65px'),
                'h3' => adsett()->get_theme_opt('font_h3','48px'),
                'h4' => adsett()->get_theme_opt('font_h4','28px'),
                'h5' => adsett()->get_theme_opt('font_h5','18px'),
                'h6' => adsett()->get_theme_opt('font_h6','16px')
            ], 
            'logo' => [
                'mobile_width' => adsett()->get_opt('logo_mobile_size', ['width' => '132px', 'units' => 'px'])['width'],
            ],
            'header' => [
                'height' => '115px' // use for default header
            ],
            'page_title' => [
                'max-width' => $custom_pagetitle_maxwidth,
            ],
            'border' => [
                'color'          => '#e7e7e7',
                'color2'          => '#d9d9d9',
                'main'           => '1px solid #e7e7e7', 
                'main2'          => '1px solid #d9d9d9',
            ],
         
            // Menu Color
            'menu' => [
                'bg'          => '#fff',
                'regular'     => '#000',
                'hover'       => '#000',
                'active'      => '#000',
                'font_size'   => '16px',
                'font_weight' => 400,
                'letter_spacing' => '0.04em',
                'font_family' => 'var(--heading-font-family)', 
            ] ,
            'submenu' => [
                'bg'            => '#FFFFFF',
                'shadow'        => '0px 15px 30px -10px rgba(27, 26, 26, 0.09)',
                'regular'       => '#1e1e1e',
                'hover'         => 'var(--primary-color)',
                'active'        => 'var(--primary-color)',
                'font_size'     => '16px',  
                'font_weight'   => 400,  
                'item_bg'       => 'transparent',
                'item_bg_hover' => '#ffffff'
            ],
            'mobile_menu' => [
                'regular'        => 'var(--heading-color)',
                'hover'          => 'var(--primary-color)',
                'active'         => 'var(--primary-color)',
                'font_size'      => '17px',
                'font_weight'    => 600,
                'font_family'    => 'var(--body-font-family)', 
                'item_bg'        => 'transparent',
                'item_bg_hover'  => 'transparent',
                'text_transform' => 'capitalize' 
            ],
            'mobile_submenu' => [
                'regular'        => 'var(--heading-color)',
                'hover'          => 'var(--primary-color)',
                'active'         => 'var(--primary-color)',
                'font_size'      => '16px', 
                'font_weight'    => 400, 
                'font_family'    => 'var(--body-font-family)', 
                'item_bg'        => 'transparent',
                'item_bg_hover'  => 'transparent',
                'text_transform' => 'capitalize' 
            ],
            'button' => [
                'font-family'        => 'var(--heading-font-family)',
                'font-size'          => '14px',
                'font-weight'        => '400',
                'line-height'        => '24px',  
                'bg-color'           => 'var(--primary-color)',      
                'color'              => '#ffffff',
                'letter-spacing'     => '0.1em',
                'padding'            => '15px 35px 15px 35px',
                'padding-above'      => '11px 35px 19px 35px',
                'padding-under'      => '20px 35px 10px 35px',
                'border'             => '0 solid var(--primary-color)',
                'radius'             => '0px',     
                'radius-rtl'         => '0px',
                'text-transform'     => 'uppercase',
                'bg-color-hover'     => 'var(--second-color)',
                'color-hover'        => '#ffffff',
                'border-color-hover' => 'var(--primary-color)',
            ],
            'cursor' => [
                'size'               => adsett()->get_theme_opt('cursor_circle_size', '20px'),
                'follower_size'      => adsett()->get_theme_opt('cursor_circle_follower_size', '30px'),
                'blend_mode'         => adsett()->get_theme_opt('blend_mode', 'difference'),
                'circle_bg'          => adsett()->get_theme_opt('cursor_circle_bg', ['rgba'=>'var(--primary-color)'], 'rgba'),
                'follower_circle_bg' => adsett()->get_theme_opt('cursor_follower_circle_bg', ['rgba'=>'rgba(var(--primary-color-rgb),0.2)'], 'rgba'),
                'follower_active_bg' => adsett()->get_theme_opt('cursor_follower_active_bg', ['rgba'=>'rgba(255,255,255,0.6)'], 'rgba'),
                'active_text_color'  => adsett()->get_theme_opt('cursor_active_text_color', '#fff'),
            ]
        ];
        return $configs[$value];
    }
}
if(!function_exists('adsett_inline_styles')){
    function adsett_inline_styles() {  
        $body              = adsett_configs('body');
        $theme_colors      = adsett_configs('theme_colors');
        $link_color        = adsett_configs('link');
        $heading           = adsett_configs('heading');
        $heading_font_size = adsett_configs('heading_font_size');
        $logo              = adsett_configs('logo');
        $page_title        = adsett_configs('page_title');
        ob_start();
        echo ':root{';
            
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color: %2$s;', str_replace('#', '',$color),  $value['value']);
            }
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color-rgb: %2$s;', str_replace('#', '',$color),  adsett_hex_rgb($value['value']));
            }
            foreach ($link_color as $color => $value) {
                printf('--link-%1$s: %2$s;', $color, $value);
            } 
            foreach ($body as $key => $value) {
                printf('--body-%1$s: %2$s;', $key, $value);
            }
            foreach ($heading as $key => $value) {
                printf('--heading-%1$s: %2$s;', $key, $value);
            }
            foreach ($heading_font_size as $key => $value) {
                printf('--heading-font-size-%1$s: %2$s;', $key, $value);
            }
            foreach ($logo as $key => $value) {
                printf('--logo-%1$s: %2$s;', $key, $value);
            }
            foreach ($page_title as $key => $value) {
                printf('--page-title-%1$s: %2$s;', $key, $value);
            }
        echo '}';
        return ob_get_clean();
         
    }
}
 