<?php 
/**
 * Actions Hook for the theme
 *
 * @package Adsett
 */
 
add_action('after_setup_theme', 'adsett_setup');
function adsett_setup(){
    //Set the content width in pixels, based on the theme's design and stylesheet.
    $GLOBALS['content_width'] = apply_filters( 'adsett_content_width', 1200 );

    // Make theme available for translation.
    load_theme_textdomain( 'adsett', get_template_directory() . '/languages' );

    // Custom Header
    add_theme_support( 'custom-header' );

    // Add default posts and comments RSS feed links to head.
    add_theme_support( 'automatic-feed-links' );

    // Let WordPress manage the document title.
    add_theme_support( 'title-tag' );

    // Enable support for Post Thumbnails on posts and pages.
    add_theme_support( 'post-thumbnails' );

    // Set post thumbnail size.
    set_post_thumbnail_size( 1170, 710 );
    $custom_sizes = adsett_configs('custom_sizes'); 
    foreach ($custom_sizes as $option => $values) {
        add_image_size( $option, $values[0], $values[1], $values[2] );
    }
   
    // This theme uses wp_nav_menu() in one location.
    register_nav_menus( array(
        'primary' => esc_html__( 'Primary', 'adsett' ),
    ) );

    // Add theme support for selective refresh for widgets.
    add_theme_support( 'customize-selective-refresh-widgets' );

    // Add support for core custom logo.
    add_theme_support( 'custom-logo', array(
        'height'      => 250,
        'width'       => 250,
        'flex-width'  => true,
        'flex-height' => true,
    ) );
    add_theme_support( 'post-formats', array(
        'video',
        'audio',
        'gallery',
        'quote',
        'link',
    ) );
     
    // Enable support for Post Thumbnails on posts and pages.
    add_theme_support('post-thumbnails');
    add_theme_support( 'woocommerce' );
    add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
    add_theme_support( 'wc-product-gallery-slider' );
    remove_theme_support('widgets-block-editor');

}
 
add_action('after_switch_theme', 'adsett_update');
function adsett_update(){
    /* Change default image thumbnail sizes in wordpress */
    $thumbnail_size = adsett_configs('thumbnails'); 
    foreach ($thumbnail_size as $values) {
        foreach ($values as $option => $value) {
            if( get_option($option, '') != $value){  
                update_option($option, $value);
            }
        }
    }
}
  

/**
 * Register Widgets Position.
 */
add_action( 'widgets_init', 'adsett_widgets_position' );
function adsett_widgets_position() {
	register_sidebar( array(
		'name'          => esc_html__( 'Blog Sidebar', 'adsett' ),
		'id'            => 'sidebar-blog',
		'before_widget' => '<section id="%1$s" class="widget %2$s"><div class="widget-content">',
		'after_widget'  => '</div></section>',
		'before_title'  => '<h4 class="widget-title"><span>',
		'after_title'   => '</span></h4>',
	) );
     
	if (class_exists('ReduxFramework') && class_exists('Pxltheme_Core')) {
		register_sidebar( array(
			'name'          => esc_html__( 'Page Sidebar', 'adsett' ),
			'id'            => 'sidebar-page',
			'before_widget' => '<section id="%1$s" class="widget %2$s"><div class="widget-content">',
			'after_widget'  => '</div></section>',
			'before_title'  => '<h4 class="widget-title"><span>',
			'after_title'   => '</span></h4>',
		) );
	}

	if ( class_exists( 'Woocommerce' ) ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Shop Sidebar', 'adsett' ),
			'id'            => 'sidebar-shop',
			'before_widget' => '<section id="%1$s" class="widget %2$s"><div class="widget-content">',
			'after_widget'  => '</div></section>',
			'before_title'  => '<h4 class="widget-title"><span>',
			'after_title'   => '</span></h4>',
		) );
	}
}

/**
 * Enqueue Styles Scripts : Front-End
 */
add_action( 'wp_enqueue_scripts', 'adsett_scripts', 99 );
function adsett_scripts() {  

    $enable_cursor = adsett()->get_opt('enable_cursor', '0');
    wp_enqueue_style( 'adsett-icon', get_template_directory_uri() . '/assets/fonts/pixelart/style.css', array(), '1.1.0');
    wp_enqueue_style( 'flaticon', get_template_directory_uri() . '/assets/fonts/flaticon/css/flaticon.css', array(), '1.0.0');
	wp_enqueue_style( 'bootstrap-icon', get_template_directory_uri() . '/assets/fonts/bootstrap-icons/bootstrap-icons.css', array(), '1.0.0'); 
    wp_enqueue_style( 'adsett-grid', get_template_directory_uri() . '/assets/css/grid.css', array(), adsett()->get_version() );
	wp_enqueue_style( 'adsett-style', get_template_directory_uri() . '/assets/css/style.css', array(), adsett()->get_version() );
	wp_add_inline_style( 'adsett-style', adsett_inline_styles() );
    wp_enqueue_style( 'adsett-base', get_template_directory_uri() . '/style.css', array(), adsett()->get_version() );
	wp_enqueue_style( 'adsett-google-fonts', adsett_fonts_url(), array(), null );

    wp_enqueue_script( 'gsap', get_template_directory_uri() . '/assets/js/gsap.min.js', array( 'jquery' ), '3.5.0', true );

    if( $enable_cursor == '1')
        wp_enqueue_script( 'adsett-cursor', get_template_directory_uri() . '/assets/js/cursor.js', array( 'jquery' ), adsett()->get_version(), true );
 
    wp_enqueue_script( 'adsett-main', get_template_directory_uri() . '/assets/js/theme.js', array( 'jquery' ), adsett()->get_version(), true );
    wp_localize_script( 'adsett-main', 'main_data', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }

    do_action( 'adsett_scripts');
}

/**
 * Enqueue Styles Scripts : Back-End
 */
add_action('admin_enqueue_scripts', 'adsett_admin_style');
function adsett_admin_style() {
    wp_enqueue_style('adsett-admin', get_template_directory_uri() . '/assets/css/admin.css', array(), '1.0.0');
    wp_enqueue_style('adsett-icon', get_template_directory_uri() . '/assets/fonts/pixelart/style.css', array(), '1.0.0');
    wp_enqueue_style('flaticon', get_template_directory_uri() . '/assets/fonts/flaticon/css/flaticon.css', array(), '1.0.0');
    wp_enqueue_style( 'bootstrap-icon', get_template_directory_uri() . '/assets/fonts/bootstrap-icons/bootstrap-icons.css', array(), '1.0.0');

}

add_action( 'elementor/editor/before_enqueue_scripts', function() {
    wp_enqueue_style( 'adsett-custom-editor', get_template_directory_uri() . '/assets/css/custom-editor.css', array(), '1.0.0' );
    wp_enqueue_style( 'admin-adsett-icon', get_template_directory_uri() . '/assets/fonts/pixelart/style.css', array(), '1.0.0' );
    wp_enqueue_style( 'admin-flaticon', get_template_directory_uri() . '/assets/fonts/flaticon/css/flaticon.css', array(), '1.0.0' );
    wp_enqueue_style( 'bootstrap-icon', get_template_directory_uri() . '/assets/fonts/bootstrap-icons/bootstrap-icons.css', array(), '1.0.0');
 
} );

 

/* Favicon */
add_action('wp_head', 'adsett_site_favicon');
function adsett_site_favicon(){
    $favicon = adsett()->get_theme_opt( 'favicon' );
    if(!empty($favicon['url']))
        echo '<link rel="icon" type="image/png" href="'.esc_url($favicon['url']).'"/>';
}

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
add_action( 'wp_head', 'adsett_pingback_header' );
function adsett_pingback_header(){
    if ( is_singular() && pings_open() )
    {
        echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
    }
}


add_action( 'elementor/preview/enqueue_styles', 'adsett_add_editor_preview_style' );
function adsett_add_editor_preview_style(){
    wp_add_inline_style( 'editor-preview', adsett_editor_preview_inline_styles() );
}
function adsett_editor_preview_inline_styles(){
    $theme_colors = adsett_configs('theme_colors');
    ob_start();
        echo '.elementor-edit-area-active{';
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color: %2$s;', str_replace('#', '',$color),  $value['value']);
            }
        echo '}';
    return ob_get_clean();
}

/**
 * Add field subtitle to post.
 */
add_action( 'edit_form_after_title', 'adsett_add_subtitle_field' );
function adsett_add_subtitle_field() {
	global $post;

	$screen = get_current_screen();

	if ( in_array( $screen->id, array( 'acm-post' ) ) ) {

		$value = get_post_meta( $post->ID, 'post_subtitle', true );

		echo '<div class="subtitle"><input type="text" name="post_subtitle" value="' . esc_attr( $value ) . '" id="subtitle" placeholder = "' . esc_attr__( 'Subtitle', 'adsett' ) . '" style="width: 100%;margin-top: 4px;"></div>';
	}
}
 

add_action( 'wp_head', 'adsett_inline_theme_option', 999 );
function adsett_inline_theme_option(){
    $dynamic_css = wp_strip_all_tags( adsett()->get_theme_opt( 'custom_css','' ) );
    $dynamic_js  = wp_strip_all_tags( adsett()->get_theme_opt( 'custom_js','' ) );
    if(!empty($dynamic_css))
        echo "<style id='adsett-custom-style-inline-css' type='text/css'>" . $dynamic_css . '</style>';

    if(!empty($dynamic_js))
        echo "<script id='adsett-custom-script' type='text/javascript'>" . $dynamic_js . '</script>';
}

add_action('wp_footer', 'adsett_backtotop',2);
function adsett_backtotop($args = []){
    $back_totop_on = adsett()->get_opt('back_totop_on', '0');
    if ($back_totop_on == '0') return;
    ?>
    <a href="javascript:void(0);" class="pxl-scroll-top" data-target="#pxl-page"><span class="pxl-icon pxli pxli-angle-up"></span></a>
<?php 
} 

add_action( 'pxltheme_anchor_target', 'adsett_cursor_render');
function adsett_cursor_render(){  
    
    $enable_cursor          = adsett()->get_opt('enable_cursor', '0');
    $hide_cursor_follower   = adsett()->get_theme_opt('hide_cursor_follower', '0');
    $none_follower = $hide_cursor_follower == '1' ? 'none-follower' : 'has-follower' ;
    if($enable_cursor == '0') return;
    ?>
    <div class="pxl-cursor pos-fix <?php echo esc_attr($none_follower) ?>"></div>
    <?php if($hide_cursor_follower != '1'): ?>
        <div class="pxl-cursor-follower pos-fix"></div>
    <?php endif; ?>
    <div class="pxl-cursor-arrow-prev pos-fix <?php echo esc_attr($none_follower) ?>"><span class="icon flaticon flaticon-right-chevron rotate-180"></span><span class="text"><?php echo esc_html__( 'Prev', 'adsett' ) ?></span></div>
    <div class="pxl-cursor-arrow-next pos-fix <?php echo esc_attr($none_follower) ?>"><span class="text"><?php echo esc_html__( 'Next', 'adsett' ) ?></span><span class="icon flaticon flaticon-right-chevron"></span></div>
    <div class="pxl-cursor-drag pos-fix <?php echo esc_attr($none_follower) ?>">
        <span class="pxl-overlay"></span>
        <span class="icon icon-left flaticon flaticon-right-chevron rotate-180"></span>
        <span class="text"><?php echo esc_html__( 'Drag', 'adsett' ) ?></span>
        <span class="icon icon-right flaticon flaticon-right-chevron"></span>
    </div>
    <div class="pxl-cursor-map pos-fix <?php echo esc_attr($none_follower) ?>"><?php echo esc_html__( 'Map', 'adsett' ) ?></div>
    <div class="pxl-cursor-text pos-fix <?php echo esc_attr($none_follower) ?>"></div>
    <div class="pxl-cursor-icon pos-fix <?php echo esc_attr($none_follower) ?>"></div>
    <?php 
}

add_action( 'pxltheme_anchor_target', 'adsett_hook_anchor_side_mobile_default');
function adsett_hook_anchor_side_mobile_default(){
    $header_mobile_layout = (int)adsett()->get_opt('header_mobile_layout'); 
    if( $header_mobile_layout > 0 ) return;
    ?>
    <nav class="pxl-hidden-template pos-left pxl-side-mobile mobile-default">
        <div class="pxl-panel-content custom_scroll">
            <span class="pxl-close" data-target=".pxl-side-mobile" title="<?php echo esc_attr__( 'Close', 'adsett' ) ?>"></span>
            <div class="menu-main-container-wrap">
                <div id="mobile-menu-container" class="menu-main-container">
                    <?php 
                        if ( has_nav_menu( 'primary' ) ){
                            wp_nav_menu( 
                                array(
                                    'theme_location' => 'primary',
                                    'container'      => '',
                                    'menu_id'        => 'pxl-mobile-menu',
                                    'menu_class'     => 'pxl-mobile-menu clearfix',
                                    'link_before'    => '<span class="pxl-menu-title">',
                                    'link_after'     => '</span>',  
                                    'walker'         => '',
                                ) 
                            );
                        }else{
                            printf(
                                '<ul class="pxl-mobile-menu pxl-primary-menu primary-menu-not-set"><li><a href="%1$s">%2$s</a></li></ul>',
                                esc_url( admin_url( 'nav-menus.php' ) ),
                                esc_html__( 'Create New Menu', 'adsett' )
                            );
                        }
                    ?>
                </div>
            </div>
        </div>
    </nav>
    <?php 
}

add_action( 'pxltheme_anchor_target', 'adsett_hook_anchor_templates_hidden_panel');
function adsett_hook_anchor_templates_hidden_panel(){

    $hidden_templates = adsett_get_templates_slug('hidden-panel');
    if(empty($hidden_templates)) return;

    foreach ($hidden_templates as $slug => $values){
        $args = [
            'slug' => $slug,
            'post_id' => $values['post_id'],
            'position' => !empty($values['position']) ? $values['position'] : 'custom-pos'
        ];
        if( did_action('pxl_anchor_target_hidden_panel_'.$values['post_id']) <= 0){  
            //can be assign from here: do_action( 'pxl_anchor_target_hidden_panel_'.$slug);
            do_action( 'pxl_anchor_target_hidden_panel_'.$values['post_id'], $args );  
        }
    } 
}

 
function adsett_hook_anchor_hidden_panel($args){  
    ?>
    <div class="pxl-hidden-template pxl-hidden-template-<?php echo esc_attr($args['post_id'])?> pos-<?php echo esc_attr($args['position']) ?>">
        <div class="pxl-hidden-template-wrap">
            <div class="pxl-panel-content custom_scroll">
                <span class="pxl-close" title="<?php echo esc_attr__( 'Close', 'adsett' ) ?>"></span>
               <?php echo Elementor\Plugin::$instance->frontend->get_builder_content_for_display( (int)$args['post_id']); ?>
            </div>
        </div>
    </div> 
    <?php 
    
}
 
 
function adsett_hook_anchor_custom(){
    return;
}


function adsett_header_popup_cart(){  
    if(!class_exists('Woocommerce')) return;
    ?>
    <div class="pxl-hidden-template pxl-side-cart">
        <div class="pxl-hidden-template-wrap">
            <div class="pxl-panel-header">
                <div class="panel-header-inner">
                    <span class="pxl-title h3"><?php echo esc_html__( 'Cart', 'adsett' ) ?></span>
                    <span class="pxl-close" title="<?php echo esc_attr__( 'Close', 'adsett' ) ?>"></span>
                </div>
            </div>
            <div class="pxl-panel-content widget_shopping_cart custom_scroll">
                <div class="widget_shopping_cart_content">
                    <?php woocommerce_mini_cart(); ?>
                </div>
            </div>
        </div>
 
    </div>
    <?php
}

add_filter('woocommerce_add_to_cart_fragments', 'adsett_woocommerce_add_to_cart_fragments', 10, 1 );
function adsett_woocommerce_add_to_cart_fragments( $fragments ) {
    if(!class_exists('WooCommerce')) return;
    ob_start();
    ?>
    <span class="header-count cart_total"><?php echo WC()->cart->cart_contents_count; ?></span>
    <?php
    $fragments['.cart_total'] = ob_get_clean();
    return $fragments;
}

function adsett_search_popup_normal(){
    ?>
    <div class="pxl-search-popup pxl-search-popup-normal pxl-modal-html pxl-transition">
        <a href="#" class="pxl-modal-close pxl-transition" title="<?php echo esc_attr__( 'Close', 'adsett' ) ?>"></a>
        <div class="pxl-search-popup-inner pxl-modal-inner container">
            <form role="search" method="get" class="search-form pxl-search-form-popup" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                <div class="text-search-wrap">
                    <input type="search" class="search-field" placeholder="<?php echo esc_attr__( 'Search Here...','adsett'); ?>" value="<?php echo get_search_query(); ?>" name="s" />
                    <button type="submit" class="search-submit" value=""><span class="kngi-search-400"></span></button>
                </div>
            </form>
        </div>
    </div>
    <?php
}

function adsett_search_popup_product(){
    ?>
    <div class="pxl-search-popup pxl-search-popup-product pxl-modal-html pxl-transition">
        <a href="#" class="pxl-modal-close pxl-transition" title="<?php echo esc_attr__( 'Close', 'adsett' ) ?>"></a>
        <div class="pxl-search-popup-inner pxl-modal-inner container">
            <form role="search" method="get" class="search-form pxl-search-form-popup" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                <input type="hidden" name="post_type" value="product"/>
                <div class="pxl-search-inner d-flex gutters-30">
                    <div class="cat-search-wrap col-auto">
                        <?php 
                        if(class_exists('Woocommerce')){
                            $args = array(
                                'show_option_all'    => esc_html__('All Categories','adsett'),
                                'orderby'            => 'ID',
                                'order'              => 'ASC',
                                'show_count'         => 0,
                                'hide_empty'         => 1,
                                'child_of'           => 0,
                                'exclude'            => '',
                                'include'            => '',
                                'echo'               => 1,
                                'selected'           => 0,
                                'hierarchical'       => 1,
                                'name'               => 'product_cat',
                                'id'                 => 'p_cat',
                                'class'              => 'postform woo_cat_search',
                                'depth'              => 0,
                                'tab_index'          => 0,
                                'taxonomy'           => 'product_cat',
                                'hide_if_empty'      => false,
                                'value_field'        => 'slug',
                            );
                            wp_dropdown_categories( $args );
                        }
                        ?>
                    </div>
                    <div class="text-search-wrap col">
                        <input type="search" class="search-field" placeholder="<?php echo esc_attr__( 'Search Here...','adsett'); ?>" value="<?php echo get_search_query(); ?>" name="s" />
                        <button type="submit" class="search-submit" value=""><span class="kngi-search-400"></span></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <?php
}

add_filter( 'pxl-e-font-icon-svg-force-inactive', 'adsett_feature_e_font_icon_svg_force_inactive');
function adsett_feature_e_font_icon_svg_force_inactive(){
    return false;
}

add_filter( 'pxl-feature-container-force-inactive', 'adsett_feature_container_force_inactive');
function adsett_feature_container_force_inactive(){
    return false;
}
 


