<?php
if (!class_exists('Adsett_Page')) {
    class Adsett_Page
    {
        public function get_site_loader(){

            $site_loader = adsett()->get_theme_opt( 'site_loader', false );
            $loading_img = adsett()->get_theme_opt( 'loading_img', [] );
            if($site_loader == '0') return;
            ?>
            <div id="pxl-loadding" class="pxl-loader style-<?php echo esc_attr($site_loader)?>">
            <?php 
            switch ($site_loader) {
                case '1':
                    ?>
                    <div class="loading-spinner">
                        <img src="<?php echo esc_url($loading_img['url'])?>" alt="<?php esc_attr_e('Loading','adsett');?>">
                    </div>
                    <?php 
                    break;
                case '2':
                    ?>
                    <div class="loading-spinner">
                        <div class="loading-dot1"></div>
                        <div class="loading-dot2"></div>
                    </div>
                    <?php 
                    break;
                case '3':
                    ?>
                    <div class="loading-charging"></div>
                    <?php 
                    break;
                case '4':
                    ?>
                    <div class="loading-2dot-rotate">
                        <div class="loading-4"></div>
                    </div>
                    <?php 
                    break;
            }
            ?>
            </div>
            <?php 
             
        }

        public function get_link_pages() {
            wp_link_pages( array(
                'before'      => '<div class="navigation page-links clearfix empty-none">',
                'after'       => '</div>',
                'link_before' => '<span>',
                'link_after'  => '</span>',
            ) ); 
        }

        public function get_pagination( $query = null, $ajax = false ){

            if($ajax){
                add_filter('paginate_links', [$this, 'get_ajax_paginate_links']);
            }

            $classes = array();

            if ( empty( $query ) )
            {
                $query = $GLOBALS['wp_query'];
            }

            if ( empty( $query->max_num_pages ) || ! is_numeric( $query->max_num_pages ) || $query->max_num_pages < 2 )
            {
                return;
            }

            $paged = $query->get( 'paged', '' );

            if ( ! $paged && is_front_page() && ! is_home() )
            {
                $paged = $query->get( 'page', '' );
            }

            $paged = $paged ? intval( $paged ) : 1;

            $pagenum_link = html_entity_decode( get_pagenum_link() );
            $query_args   = array();
            $url_parts    = explode( '?', $pagenum_link );

            if ( isset( $url_parts[1] ) )
            {
                wp_parse_str( $url_parts[1], $query_args );
            }

            $pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
            $pagenum_link = trailingslashit( $pagenum_link ) . '%_%';

            $html_prev = '<span class="pxli-long-arrow-left"></span>';
            $html_next = '<span class="pxli-long-arrow-right"></span>';
            $paginate_links_args = array(
                'base'     => $pagenum_link,
                'total'    => $query->max_num_pages,
                'current'  => $paged,
                'mid_size' => 1,
                'add_args' => array_map( 'urlencode', $query_args ),
                'prev_text' => $html_prev,
                'next_text' => $html_next,
            );
            if($ajax){
                $paginate_links_args['format'] = '?page=%#%';
            }
            $links = paginate_links( $paginate_links_args );
            if ( $links ):
            ?>
            <nav class="posts-pagination <?php echo esc_attr($ajax?'ajax':''); ?>">
                <div class="pagination-inner">
                    <?php printf($links); ?>
                </div>
            </nav>
            <?php
            endif;
        }
        
        function get_ajax_paginate_links($link){
            $parts = parse_url($link);
            if( !isset($parts['query']) ) return $link;
            parse_str($parts['query'], $query);
            if(isset($query['page']) && !empty($query['page'])){
                return '#' . $query['page'];
            }
            else{
                return '#1';
            }
        }

        public function get_page_static_template(){
            if(is_singular( 'page' )){
                $template_id_page = adsett()->get_theme_opt('template_id_page',[]);
                $template_id = adsett()->get_theme_opt('template_id','');
                
                if(!empty($template_id_page) && !empty($template_id) && (int)$template_id > 0 && in_array(get_the_ID(), $template_id_page)){
                    echo '<div class="pxl-content-static-template">';
                    echo Elementor\Plugin::$instance->frontend->get_builder_content_for_display( (int)$template_id);
                    echo '</div>';
                }
            }
            if(is_singular( 'portfolio' )){
                $project_single_on = adsett()->get_theme_opt('project_single_on','0');
                $template_id_project = adsett()->get_theme_opt('template_id_project','');
                if($project_single_on == '1' && !empty($template_id_project) && (int)$template_id_project > 0){
                    echo '<div class="pxl-content-static-template">';
                    echo Elementor\Plugin::$instance->frontend->get_builder_content_for_display( (int)$template_id_project);
                    echo '</div>';
                }
            }
        }
    }
}
 