<?php
if (!class_exists('Adsett_Page_Title')) {
    class Adsett_Page_Title
    {
        public function get_page_title(){
            if(is_404()) return;
            $pt_mode = adsett()->get_opt('pt_mode');
            if( $pt_mode == 'none' ) return;

            $ptitle_layout = (int)adsett()->get_opt('ptitle_layout');
            $titles = $this->get_title();

            $breadcrumb = new Adsett_Breadcrumb();
            $entries = $breadcrumb->get_entries();

            $pt_bg_parallax = adsett()->get_theme_opt('pt_bg_parallax');
            $data_parallax = $pll_cls = '';
            if( (isset($pt_bg_parallax) && $pt_bg_parallax) ){
                $data_parallax = json_encode([
                    adsett()->get_theme_opt('pt_parallax') => adsett()->get_theme_opt('pt_parallax_value')
                ]);
                $pll_cls = 'overflow-hidden';
            }
 
            $brc_divider = '<span class="br-divider">/</span>';
            if ($pt_mode == 'bd' && $ptitle_layout > 0 && class_exists('Pxltheme_Core') && is_callable( 'Elementor\Plugin::instance' )) {
                ?>
                <div id="pxl-pagetitle" class="pxl-pagetitle  layout-el relative <?php echo esc_attr($pll_cls) ?>">
                    <div class="pxl-page-title-bg pxl-absoluted" data-parallax='<?php echo esc_attr($data_parallax);?>'></div>
                    <div class="pxl-page-title-overlay"></div>
                    <?php echo Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $ptitle_layout);?>
                </div>
                <?php 
            } else {
                ?>
                <div id="pxl-pagetitle" class="pxl-pagetitle layout-df relative <?php echo esc_attr($pll_cls) ?>">
                    <div class="pxl-page-title-bg pxl-absoluted" data-parallax='<?php echo esc_attr($data_parallax);?>'></div>
                    <div class="pxl-page-title-overlay"></div>
                    <div class="container relative">
                        <div class="pxl-page-title-inner align-content-center text-center">
                            <?php if ( !empty( $entries ) ): ?>
                                <div class="pxl-brc-wrap d-flex justify-content-center">
                                    <div class="brc-inner">
                                        <?php 
                                            foreach ( $entries as $entry ){
                                                $entry = wp_parse_args( $entry, array(
                                                    'label' => '',
                                                    'url'   => ''
                                                ) );

                                                if ( empty( $entry['label'] ) ){
                                                    continue;
                                                }

                                                echo '<div class="br-item">';
                                                if ( ! empty( $entry['url'] ) ){
                                                    printf(
                                                        '<a class="br-link" href="%1$s">%2$s</a>%3$s',
                                                        esc_url( $entry['url'] ),
                                                        esc_attr( $entry['label'] ),
                                                        $brc_divider
                                                    );           
                                                }else{
                                                    printf( '<span class="br-text" >%s</span>%2$s', $entry['label'], $brc_divider );
                                                }
                                                echo '</div>';
                                            }
                                        ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="pxl-pt-wrap d-flex text-center">
                                <div class="pxl-page-title">
                                    <h1 class="main-title"><?php echo adsett_html($titles['title']) ?></h1>
                                    <?php if(!empty($titles['sub_title'])): ?>
                                        <div class="sub-title"><?php echo adsett_html($titles['sub_title']) ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php 
            } 
        } 
        
        public function get_title() {
            $title = $sub_title = '';     
            $post_title_on = adsett()->get_theme_opt('post_title_on','1');
            $post_sub_title_on = adsett()->get_theme_opt('post_sub_title_on','0');
            $disable_product_title = adsett()->get_theme_opt('disable_product_title','1');
            $sub_title = adsett()->get_theme_opt('custom_sub_title','');
            // Default titles
            if ( ! is_archive() ) {
                $custom_title_mode = adsett()->get_page_opt('custom_title_mode', '-1');
                if($custom_title_mode === 'custom')
                    $title  = adsett()->get_page_opt('custom_title','');
                
                $custom_sub_title_mode = adsett()->get_page_opt('custom_sub_title_mode', '-1');
                if($custom_sub_title_mode === 'custom')
                    $sub_title = adsett()->get_page_opt('custom_sub_page_title', '');
                
                // Posts page view
                if ( is_home() ) {
                    // Only available if posts page is set.
                    if ( ! is_front_page() && $page_for_posts = get_option( 'page_for_posts' ) ) {     
                        if ( $custom_title_mode == '-1') {
                            $title = get_the_title( $page_for_posts );
                        }
                    }
                    if ( is_front_page() ) {
                        $title = esc_html__( 'Blog', 'adsett' );
                    }
                } // Single page view
                elseif ( is_page() ) {
                    if ( $custom_title_mode == '-1') {
                        $title = get_the_title();
                    }
                     
                } elseif ( is_404() ) {
                    $title = esc_html__( '404', 'adsett' );
                } elseif ( is_search() ) {
                    $title = esc_html__( 'Search results', 'adsett' );
                } else {
                    if( is_singular('post') ){
                        if ( $custom_title_mode == '-1' ) {
                            if($post_title_on != '1'){
                                $title = '';
                            }else{
                                $title = get_the_title();
                            }
                        }else{
                            $title = $title; 
                        }
                        if ( $custom_sub_title_mode == '-1' ) {
                            if($post_sub_title_on != '1'){
                                $sub_title = '';
                            }else{
                                $sub_title = $sub_title;
                            }
                        }else{
                            $sub_title = $sub_title; 
                        }
                    }elseif ( is_singular('product') && $disable_product_title == '0' ) {
                        $title = '';
                        $sub_title = '';
                    } elseif ( $custom_title_mode == '-1' ) {
                        $title = get_the_title();
                    } else {
                        $title = $title; //get_the_title();
                    }
                }
                
            } elseif ( is_author() ) {  
                $title     = get_the_author();
                $sub_title = adsett()->get_theme_opt('archive_custom_sub_title', $sub_title);
            } else {
                $title = get_the_archive_title();
                
                if( class_exists( 'WooCommerce' ) && is_shop() ) {
                    $title = get_post_meta( wc_get_page_id('shop'), 'custom_title', true );
                    if(!$title) {
                        $title = get_the_title( get_option( 'woocommerce_shop_page_id' ) );
                    }
                }

                if ( get_post_type() === 'post' )
                    $sub_title = adsett()->get_theme_opt('archive_custom_sub_title', $sub_title);
                  
            }

            return array(
                'title' => $title,
                'sub_title' => $sub_title
            );
        }


    }
     
}
 
