<?php
if (!class_exists('Adsett_Header')) {
    class Adsett_Header
    {
        public function getHeader()
        {
            $disable_header = adsett()->get_page_opt('disable_header','0');
            if($disable_header == '1') return; 

            $header_layout        = (int)adsett()->get_opt('header_layout'); 
            $header_mobile_layout = (int)adsett()->get_opt('header_mobile_layout'); 

            $logo_desktop = adsett()->get_theme_opt( 'logo_d', ['url' => get_template_directory_uri().'/assets/images/logo.png', 'id' => '' ] );
            $logo_mobile = adsett()->get_theme_opt( 'logo_m', ['url' => get_template_directory_uri().'/assets/images/logo.png', 'id' => '' ] );
            
            $p_menu = adsett()->get_page_opt('p_menu');

            $header_type = $header_layout <=0 ? 'df' : 'el';
            $header_mobile_type = $header_mobile_layout <=0 ? 'df' : 'el';
             
            $classes = [
                'pxl-header',
                'header-type-'.$header_type,
                'header-layout-'.$header_layout,
                'header-mobile-type-'.$header_mobile_type
            ];
            $header_css_cls = implode(' ', $classes)

            ?>
            <header id="pxl-header" class="<?php echo esc_attr($header_css_cls); ?>">
                <?php if ($header_layout <= 0 || !class_exists('Pxltheme_Core') || !is_callable( 'Elementor\Plugin::instance' )): ?>
                    <div class="header-container container d-none d-xl-block">
                        <div class="row justify-content-between align-items-center gx-50">
                            <div class="pxl-header-logo col-auto">
                                <?php 
                                printf(
                                    '<a class="logo-default" href="%1$s" title="%2$s" rel="home"><img class="pxl-logo" src="%3$s" alt="%2$s"/></a>',
                                    esc_url( home_url( '/' ) ),
                                    esc_attr( get_bloginfo( 'name' ) ),
                                    esc_url( $logo_desktop['url'] )
                                );
                                ?>
                            </div>
                            <div class="pxl-navigation col d-none d-xl-block">
                                <div class="row align-items-center justify-content-center">
                                    <div class="col-12 col-xl-auto">
                                        <div class="row align-items-center">
                                            <div class="pxl-main-navigation col-12 col-xl-auto">
                                                <?php 
                                                if ( has_nav_menu( 'primary' ) ){
                                                    $attr_menu = array(
                                                        'theme_location' => 'primary',
                                                        'container'  => '',
                                                        'menu_id'    => 'pxl-primary-menu',
                                                        'menu_class' => 'pxl-primary-menu clearfix',
                                                        'link_before'     => '<span>',
                                                        'link_after'      => '</span>',
                                                        'walker'         => class_exists( 'PXL_Mega_Menu_Walker' ) ? new PXL_Mega_Menu_Walker : '',
                                                    );
                                                    if(isset($p_menu) && !empty($p_menu)) {
                                                        $attr_menu['menu'] = $p_menu;
                                                    }

                                                    wp_nav_menu( $attr_menu );
                                                }else{
                                                    printf(
                                                        '<ul class="pxl-primary-menu primary-menu-not-set"><li><a href="%1$s">%2$s</a></li></ul>',
                                                        esc_url( admin_url( 'nav-menus.php' ) ),
                                                        esc_html__( 'Create New Menu', 'adsett' )
                                                    );
                                                }
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col col-auto d-xl-none">
                                <div class="row align-items-center justify-content-end">
                                    <div id="main-menu-mobile" class="main-menu-mobile">
                                        <span class="btn-nav-mobile open-menu" data-target=".pxl-side-mobile" onclick="">
                                            <span></span>
                                            <span></span>
                                            <span></span>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <?php if(isset($header_layout) && $header_layout > 0) : ?>
                        <div class="pxl-header-desktop d-none d-xl-block">
                            <?php echo Elementor\Plugin::$instance->frontend->get_builder_content_for_display($header_layout); ?>         
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if ($header_mobile_layout <= 0 || !class_exists('Pxltheme_Core') || !is_callable( 'Elementor\Plugin::instance' )): ?>
                    <div class="pxl-header-mobile container d-xl-none">
                        <div class="row justify-content-between align-items-center gx-40">
                            <div class="pxl-header-logo col-auto">
                                <?php 
                                printf(
                                    '<a class="logo-default" href="%1$s" title="%2$s" rel="home"><img class="pxl-logo" src="%3$s" alt="%2$s"/></a>',
                                    esc_url( home_url( '/' ) ),
                                    esc_attr( get_bloginfo( 'name' ) ),
                                    esc_url( $logo_mobile['url'] )
                                );
                                ?>
                            </div>
                            <div class="col col-auto d-xl-none">
                                <div class="row align-items-center justify-content-end">
                                    <div id="main-menu-mobile" class="main-menu-mobile">
                                        <span class="btn-nav-mobile open-menu" data-target=".pxl-side-mobile" onclick="">
                                            <span class="hover top"></span>
                                            <span class="hover bottom"></span>
                                            <span class="default top"></span>
                                            <span class="default bottom"></span>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <?php if(isset($header_mobile_layout) && $header_mobile_layout > 0) : ?>
                        <div class="pxl-header-mobile d-xl-none"> 
                            <?php echo Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $header_mobile_layout); ?>      
                        </div> 
                    <?php endif; ?>
                <?php endif; ?>
            </header>
            <?php  
        }
         
        public function get_header_css_class($args = []){
            
            $args = wp_parse_args($args, [
                'class'                => '',
                'header_layout'        => (int)adsett()->get_opt('header_layout','0'), 
                'header_mobile_layout' => (int)adsett()->get_opt('header_mobile_layout'),
            ]);
             
            $header_type = $args['header_layout'] <=0 ? 'df' : 'el';
            $header_mobile_type = $args['header_mobile_layout'] <=0 ? 'df' : 'el';
             
            $classes = [
                'pxl-header',
                'header-type-'.$header_type,
                'header-layout-'.$args['header_layout'],
                'header-mobile-type-'.$header_mobile_type
            ];
        

            if(!empty($args['class'])) $classes[] = $args['class'];

            return implode(' ', $classes);
        }
         
    }
}
 
