<?php
if (!class_exists('Adsett_Blog')) {
    class Adsett_Blog
    {
        public function get_post_feature(){
             
            $post_feature_image_on = adsett()->get_theme_opt('post_feature_image_on', '1');
             
            $post_feature_image_type = adsett()->get_theme_opt('post_feature_image_type','cropped');
 
            if($post_feature_image_type == 'full'){ 
                $thumbnail_size = 'full'; 
            }else{
                $thumbnail_size = 'large';
            }
            if(has_post_format('video')){
                global $wp_embed;
                $featured_video = get_post_meta( get_the_ID(), 'featured-video-url', true );
                if (!empty($featured_video)) {
                    echo '<div class="post-featured feature-video">';
                        echo do_shortcode($wp_embed->autoembed($featured_video));
                    echo '</div>';
                }
            }elseif( has_post_format('audio') ){
                global $wp_embed;
                $audio_url = get_post_meta( get_the_ID(), 'featured-audio-url', true );
                if (!empty($audio_url) || has_post_thumbnail()) {
                    echo '<div class="post-featured feature-audio relative">';
                        echo do_shortcode($wp_embed->autoembed($audio_url));
                        if (has_post_thumbnail()) 
                            the_post_thumbnail($thumbnail_size);
                    echo '</div>';
                }  
            }elseif( has_post_format('gallery') ){
                $gallery_list = [];
                $gallery = get_post_meta( get_the_ID(), 'featured-gallery', true );
                if(!empty($gallery)):
                    $galleries = explode(',', $gallery);
                    if (!wp_script_is( 'swiper', 'enqueued' ))
                        wp_enqueue_script( 'swiper');
                    if (has_post_thumbnail()) {
                        $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), $thumbnail_size); 
                        $gallery_list[] = $featured_img_url;
                    }
                    foreach ($galleries as $gal_id) {
                        $gal_image_url = wp_get_attachment_image_url( $gal_id, $thumbnail_size );
                        $gallery_list[] = $gal_image_url;
                    }  
                    echo '<div class="post-featured feature-gallery relative">'; ?>
                        <div class="pxl-swiper-slider post-gallery-slider">
                            <div class="pxl-swiper-slider-wrap pxl-carousel-inner overflow-hidden">
                                <div class="pxl-swiper-container">
                                    <div class="pxl-swiper-wrapper swiper-wrapper">
                                        <?php foreach ($gallery_list as $value): ?>
                                            <div class="pxl-swiper-slide swiper-slide">
                                                <a href="<?php echo esc_url( get_permalink()); ?>">
                                                    <img src="<?php echo esc_url($value)?>" alt="gallery">
                                                </a>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="pxl-swiper-arrows">
                                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><span class="pxl-icon bi bi-arrow-left"></span></div>
                                <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><span class="pxl-icon bi bi-arrow-right"></span></div>
                            </div>
                        </div>
                    <?php echo '</div>'; ?>
                <?php elseif (has_post_thumbnail()):
                    echo '<div class="post-featured relative">'; ?>
                        <a href="<?php echo esc_url( get_permalink()); ?>">
                            <?php the_post_thumbnail($thumbnail_size); ?>
                        </a>
                    <?php echo '</div>';
                endif; 
            }else{
                if ( has_post_thumbnail() && $post_feature_image_on == '1'){  
                    echo '<div class="post-image post-featured '.$post_feature_image_type.'">';  
                        the_post_thumbnail($thumbnail_size);
                    echo '</div>';
                }
            }
            
        }

        public function get_archive_meta() {
            $archive_date = adsett()->get_theme_opt( 'archive_date', '1' );
            $archive_category = adsett()->get_theme_opt( 'archive_category', '1' );
            $archive_author = adsett()->get_theme_opt( 'archive_author', '0' );
            
            if($archive_date == '1' || $archive_category == '1' || $archive_author == '1') : ?>
                <div class="archive-metas">
                    <div class="meta-inner d-flex align-items-center">
                        <?php if($archive_date == '1') : ?>
                            <span class="post-date col-auto d-flex"><span><?php echo get_the_date(); ?></span></span>
                        <?php endif; ?>
                        <?php if($archive_author == '1') : ?>
                            <span class="post-author col-auto d-flex"><span><?php the_author_posts_link(); ?></span></span>
                        <?php endif; ?>
                        <?php if($archive_category == '1') : ?>
                            <span class="post-category col-auto d-flex"><span><?php the_terms( get_the_ID(), 'category', '', ', ', '' ); ?></span></span>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; 
        }

        public function get_excerpt( $length = 55 ){
            $post = get_post();
            $pxl_the_excerpt = get_the_excerpt();

            if(empty($pxl_the_excerpt)) {
                $content = apply_filters( 'the_content', strip_shortcodes( $post->post_content ) );
                $pxl_the_excerpt = str_replace( ']]>', ']]&gt;', $content );
            } 

            if ( post_password_required( $post ) ) {
                $pxl_the_excerpt = esc_html__( 'Post password required.', 'adsett' );
            }

            $excerpt_more = apply_filters( 'adsett_excerpt_more', '&hellip;' );
            $excerpt      = wp_trim_words( $pxl_the_excerpt, $length, $excerpt_more );
            echo wp_kses_post($excerpt);
        }
 
        public function get_post_metas(){
            $post_category = adsett()->get_theme_opt( 'post_category', '1' );
            $post_author = adsett()->get_theme_opt( 'post_author', '0' );
            $post_date = adsett()->get_theme_opt( 'post_date', '1' );
            if($post_author == '1' || $post_date == '1' || $post_category == '1') : ?>
                <div class="post-metas">
                    <div class="meta-inner d-flex-wrap align-items-center">
                        <?php if($post_date == '1') : ?>
                            <span class="post-date col-auto d-flex"><span><?php echo get_the_date(); ?></span></span>
                        <?php endif; ?>
                        <?php if($post_author == '1') : ?>
                            <span class="post-author col-auto d-flex"><span><?php echo esc_html__('by', 'adsett'); ?>&nbsp;<?php the_author_posts_link(); ?></span></span>
                        <?php endif; ?>
                        <?php if($post_category == '1') : ?>
                            <span class="post-category col-auto d-flex"><span><?php the_terms( get_the_ID(), 'category', '', ', ', '' ); ?></span></span>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; 
        }
        public function get_post_title(){
            $post_title_on = adsett()->get_theme_opt('post_title_on','1');
            if( $post_title_on == '1' ) return;
            ?>
            <h3 class="post-title">
                <a href="<?php echo esc_url( get_permalink()); ?>" title="<?php the_title_attribute(); ?>">
                    <?php the_title(); ?>
                </a>
            </h3>
            <?php 
        }
        public function adsett_set_post_views( $postID ) {
            $countKey = 'post_views_count';
            $count    = get_post_meta( $postID, $countKey, true );
            if ( $count == '' ) {
                $count = 0;
                delete_post_meta( $postID, $countKey );
                add_post_meta( $postID, $countKey, '0' );
            } else {
                $count ++;
                update_post_meta( $postID, $countKey, $count );
            }
        }
        public function get_post_content_foot(){
            echo '<div class="post-tags-share row justify-content-md-between empty-none">';
                $this->get_post_tags();
                $this->get_post_share();
            echo '</div>';
        }
        public function get_post_tags(){
            $post_tag = adsett()->get_theme_opt( 'post_tag', '0' );
            if($post_tag != '1') return;
            $tags_list = get_the_tag_list( '<span class="label">'.esc_attr__('Tags :', 'adsett'). '</span>', ' ' );
            if ( $tags_list ){
                echo '<div class="post-tags-wrap col-auto">';
                    echo '<div class="post-tags">';
                    printf('%2$s', '', $tags_list);
                    echo '</div>';
                echo '</div>';
            }
        }
          
        public function get_post_share() { 
            $post_social_share = adsett()->get_theme_opt( 'post_social_share', '0' );
            if($post_social_share != '1') return;
            $share_icons = adsett()->get_theme_opt( 'post_social_share_icon', [] );
            $img_url = '';
            if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false)) {
                $img_url = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false);
            }
            ?>
            <div class="post-share-wrap col-auto">
                <div class="post-shares">
                    <div class="col social-share">
                        <div class="row">
                            <div class="label col-auto"><?php echo esc_html__('Share :', 'adsett'); ?></div>
                            <?php if(in_array('facebook', $share_icons)): ?>
                            <div class="social-item col-auto">
                                <a title="<?php echo esc_attr__('Facebook', 'adsett'); ?>" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode(get_permalink()); ?>"><?php echo esc_html__('Facebook', 'adsett'); ?></a>
                            </div>
                            <?php endif; ?> 
                            <?php if(in_array('twitter', $share_icons)): ?>
                            <div class="social-item col-auto">
                                <a title="<?php echo esc_attr__('Twitter', 'adsett'); ?>" target="_blank" href="https://twitter.com/intent/tweet?original_referer=<?php echo urldecode(home_url('/')); ?>&url=<?php echo urlencode(get_permalink()); ?>&text=<?php the_title();?>%20"><?php echo esc_html__('Twitter', 'adsett'); ?></a>
                            </div>
                            <?php endif; ?> 
                            <?php if(in_array('linkedin', $share_icons)): ?>
                            <div class="social-item col-auto">
                                <a title="<?php echo esc_attr__('Linkedin', 'adsett'); ?>" target="_blank" href="https://www.linkedin.com/cws/share?url=<?php echo urlencode(get_permalink());?>"><?php echo esc_html__('Linkedin', 'adsett'); ?></a>
                            </div>
                            <?php endif; ?> 
                            <?php if(in_array('pinterest', $share_icons)): ?>
                                <div class="social-item col-auto">
                                    <a title="<?php echo esc_attr__('Pinterest', 'adsett'); ?>" target="_blank" href="http://pinterest.com/pin/create/button/?url=<?php echo urlencode(get_permalink()); ?>&media=<?php echo esc_attr($img_url); ?>&description=<?php the_title(); ?>"><?php echo esc_html__('Pinterest', 'adsett'); ?></a>
                                </div>
                            <?php endif; ?> 
                        </div>
                    </div>
                </div>
            </div>
            <?php
        }

        public function get_post_author_info(){
            $post_author_info = adsett()->get_theme_opt( 'post_author_info', false );
            if($post_author_info != '1') return;
            
            ?>
            <div class="post-author-info">
                <div class="author-post d-flex-wrap">
                    <div class="author-avatar col-12 col-sm-auto">
                        <?php echo get_avatar( get_the_author_meta( 'ID' ), 156 ); ?>
                    </div>
                    <div class="author-description col">
                        <h4 class="author-name"><?php echo esc_html__( 'About Admin', 'adsett' ) ?> </h4>
                        <div class="author-desc"><?php the_author_meta( 'description' ); ?></div>
                        <?php adsett_get_user_social(); ?>
                    </div>
                </div>
            </div>
            <?php 
        }

        public function get_post_nav() {
            $post_navigation = adsett()->get_theme_opt( 'post_navigation', false );
            if($post_navigation != '1') return;
            global $post;

            $previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
            $next     = get_adjacent_post( false, '', false );

            if ( ! $next && ! $previous )
                return;
            ?>
            <?php
            $next_post = get_next_post();
            $previous_post = get_previous_post();
            if(empty($previous_post) && empty($next_post)) return;

            ?>
            <div class="single-next-prev-nav row gx-0 justify-content-between align-items-center">
                <?php if(!empty($previous_post)): 
                    ?>
                    <div class="nav-next-prev prev col relative text-start">
                        <div class="nav-inner">
                            <?php previous_post_link('%link',''); ?>
                            <div class="nav-label-wrap d-flex align-items-center">
                                <span class="nav-icon pxli-long-arrow-left"></span>
                                <span class="nav-label"><?php echo is_singular( 'portfolio' ) ? esc_html__('Previous Project', 'adsett') : esc_html__('Previous Post', 'adsett'); ?></span>
                            </div>
                             
                        </div>
                    </div>
                <?php else: ?>
                    <?php if(is_singular( 'portfolio' )): ?>
                        <div class="nav-next-prev prev col relative text-start"></div>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if(is_singular( 'portfolio' )): 
                    $port_archive_link = adsett()->get_theme_opt('portfolio_archive_link', '');
                    $list_list = !empty($port_archive_link) ? $port_archive_link : get_post_type_archive_link('portfolio');
                    ?>
                    <div class="bak-home-list col-auto">
                        <a href="<?php echo esc_url($list_list)?>">
                        <svg version="1.0" width="512px" height="512px" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet">
                            <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)"
                            fill="#000000" stroke="none">
                                <path d="M0 3905 l0 -1215 1215 0 1215 0 0 1215 0 1215 -1215 0 -1215 0 0 -1215z m2110 0 l0 -895 -895 0 -895 0 0 895 0 895 895 0 895 0 0 -895z"/>
                                <path d="M2690 3905 l0 -1215 1215 0 1215 0 0 1215 0 1215 -1215 0 -1215 0 0 -1215z m2110 0 l0 -895 -895 0 -895 0 0 895 0 895 895 0 895 0 0 -895z"/>
                                <path d="M0 1215 l0 -1215 1215 0 1215 0 0 1215 0 1215 -1215 0 -1215 0 0 -1215z m2110 0 l0 -895 -895 0 -895 0 0 895 0 895 895 0 895 0 0 -895z"/>
                                <path d="M2690 1215 l0 -1215 1215 0 1215 0 0 1215 0 1215 -1215 0 -1215 0 0 -1215z m2110 0 l0 -895 -895 0 -895 0 0 895 0 895 895 0 895 0 0 -895z"/>
                            </g>
                        </svg>
                        </a>
                    </div>
                <?php endif; ?>
                <?php if(!empty($next_post)) : 
                    ?>
                    <?php if(is_singular( 'post' )): ?>
                        <div class="divider col-auto w-30"></div>
                    <?php endif; ?>
                    <div class="nav-next-prev next col relative text-end">
                        <div class="nav-inner">
                            <?php next_post_link('%link',''); ?>
                            <div class="nav-label-wrap d-flex align-items-center justify-content-end">
                                <span class="nav-label"><?php echo is_singular( 'portfolio' ) ? esc_html__('Next Project', 'adsett') :esc_html__('Next Post', 'adsett'); ?></span>
                                <span class="nav-icon pxli-long-arrow-right"></span>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <?php if(is_singular( 'portfolio' )): ?>
                        <div class="nav-next-prev next col relative text-end"></div>
                    <?php endif; ?>
                <?php endif; ?>
            </div> 
            <?php  
        }

        public function get_related_post(){
            $post_related_on = adsett()->get_theme_opt( 'post_related_on', false );

            if($post_related_on) {
                global $post;
                $current_id = $post->ID;
                $posttags = get_the_category($post->ID);
                if (empty($posttags)) return;

                $tags = array();

                foreach ($posttags as $tag) {

                    $tags[] = $tag->term_id;
                }
                $post_number = '6';
                $query_similar = new WP_Query(array('posts_per_page' => $post_number, 'post_type' => 'post', 'post_status' => 'publish', 'category__in' => $tags));
                if (count($query_similar->posts) > 1) {
                    wp_enqueue_script( 'swiper' );
                    wp_enqueue_script( 'adsett-swiper' );
                    $opts = [
                        'slide_direction'               => 'horizontal',
                        'slide_percolumn'               => '1', 
                        'slide_mode'                    => 'slide', 
                        'slides_to_show'                => 3, 
                        'slides_to_show_lg'             => 3, 
                        'slides_to_show_md'             => 2, 
                        'slides_to_show_sm'             => 2, 
                        'slides_to_show_xs'             => 1, 
                        'slides_to_scroll'              => 1, 
                        'slides_gutter'                 => 30, 
                        'arrow'                         => false,
                        'dots'                          => true,
                        'dots_style'                    => 'bullets'
                    ];
                    $data_settings = wp_json_encode($opts);
                    $dir           = is_rtl() ? 'rtl' : 'ltr';
                    ?>
                    <div class="pxl-related-post">
                        <h4 class="widget-title"><?php echo esc_html__('Related Posts', 'adsett'); ?></h4>
                        <div class="class" data-settings="<?php echo esc_attr($data_settings) ?>" data-rtl="<?php echo esc_attr($dir) ?>">
                            <div class="pxl-related-post-inner pxl-swiper-wrapper swiper-wrapper">
                            <?php foreach ($query_similar->posts as $post):
                                $thumbnail_url = '';
                                if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)) :
                                    $thumbnail_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'adsett-blog-small', false);
                                endif;
                                if ($post->ID !== $current_id) : ?>
                                    <div class="pxl-swiper-slide swiper-slide grid-item">
                                        <div class="grid-item-inner">
                                            <?php if (has_post_thumbnail()) { ?>
                                                <div class="item-featured">
                                                    <a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($thumbnail_url[0]); ?>" /></a>
                                                </div>
                                            <?php } ?>
                                            <h3 class="item-title">
                                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                            </h3>
                                        </div>
                                    </div>
                                <?php endif;
                            endforeach; ?>
                            </div>
                        </div>
                    </div>
                <?php }
            }

            wp_reset_postdata();
        }
    }
 
}