<?php
if ( ! $settings['wp_gallery'] ) {
    return;
}
use Elementor\Embed;
 
$layout                  = $widget->get_setting('layout');
$layout_mode             = $widget->get_setting('layout_mode', 'fitRows');
$item_animation          = $widget->get_setting('item_animation', '');  
$item_animation_duration = $widget->get_setting('item_animation_duration', 'normal');  
$item_animation_delay    = $widget->get_setting('item_animation_delay', '150');  
$col_xs                  = $widget->get_setting('col_xs', '2');
$col_sm                  = $widget->get_setting('col_sm', '2');  
$col_md                  = $widget->get_setting('col_md', '2'); 
$col_lg                  = $widget->get_setting('col_lg', '2');
$col_xl                  = $widget->get_setting('col_xl', '2');  
$col_xxl                 = $widget->get_setting('col_xxl', '2');  
$grid_custom_columns     = $widget->get_setting('grid_custom_columns');
$img_size                = $widget->get_setting('img_size','thumbnail');

$show_load_more = $widget->get_setting('show_load_more','false');

$randGallery = $settings['wp_gallery'];
if ($settings['gallery_rand'] == 'rand'){
    shuffle($randGallery);
}

$lightbox_id = isset($settings['_id']) ? $settings['_id'] : $settings['element_id'];

$widget->add_render_attribute( 'wrapper', [
    'id'               => $settings['element_id'],
    'class'            => trim('pxl-grid pxl-video-gallery-grid clearfix layout-'.$layout),
    'data-layout-mode' => $layout_mode,
    'data-total' => count($randGallery),
    'data-show' => $widget->get_setting('gallery_show', '8'),
    'data-loadmore' => $widget->get_setting('gallery_loadmore_show', '8'),
]);

if(count($randGallery) > (int)$settings['gallery_show'] && $show_load_more === 'true')
    $widget->add_render_attribute( 'wrapper', ['class' => 'has-loadmore']);

 
$grid_class = 'pxl-grid-inner pxl-grid-masonry row relative overflow-hidden';
 
$widget->add_render_attribute( 'grid', 'class', $grid_class);



$col_xxl = 'col-xxl-'.str_replace('.', '',12 / floatval( $col_xxl));
$col_xl  = 'col-xl-'.str_replace('.', '',12 / floatval( $col_xl));
$col_lg  = 'col-lg-'.str_replace('.', '',12 / floatval( $col_lg));
$col_md  = 'col-md-'.str_replace('.', '',12 / floatval( $col_md));
$col_sm  = 'col-sm-'.str_replace('.', '',12 / floatval( $col_sm)); 
$col_xs  = 'col-'.str_replace('.', '',12 / floatval( $col_xs)); 

$item_class = trim(implode(' ', ['grid-item', $col_xxl, $col_xl, $col_lg, $col_md, $col_sm, $col_xs]));

$data_settings = '';
$animate_cls = '';
if ( !empty( $item_animation ) ) {
    $animate_cls = ' pxl-animate pxl-invisible animated-'.$item_animation_duration;
    $data_animation =  json_encode([
        'animation'      => $item_animation,
        'animation_delay' => (float)$item_animation_delay
    ]);
    $data_settings = 'data-settings="'.esc_attr($data_animation).'"';
}
$item_sizer_cls = str_replace('grid-item', '', $item_class) ;
?>
<div <?php pxl_print_html($widget->get_render_attribute_string( 'wrapper' )) ?>>
    <div <?php pxl_print_html($widget->get_render_attribute_string('grid')); ?>> 
        <?php
        $remain_cls = [];
        $remain_image_size = [];
        $remain_anm_cls = [];
        $remain_data_setting = [];
        foreach ( $randGallery as $key => $value):
            $item_cls = $item_class;  
            $image_size = $img_size;
            $anm_cls = $animate_cls;
            $data_setting = $data_settings;
             
            if( !empty($grid_custom_columns[$key]) ){ 
                $col_xxl_c = 'col-xxl-'.str_replace('.', '',12 / floatval($grid_custom_columns[$key]['col_xxl_c']));
                $col_xl_c = 'col-xl-'.str_replace('.', '',12 / floatval( $grid_custom_columns[$key]['col_xl_c']));
                $col_lg_c = 'col-lg-'.str_replace('.', '',12 / floatval( $grid_custom_columns[$key]['col_lg_c']));
                $col_md_c = 'col-md-'.str_replace('.', '',12 / floatval( $grid_custom_columns[$key]['col_md_c']));
                $col_sm_c = 'col-sm-'.str_replace('.', '',12 / floatval( $grid_custom_columns[$key]['col_sm_c'])); 
                $col_xs_c = 'col-xs-'.str_replace('.', '',12 / floatval( $grid_custom_columns[$key]['col_xs_c'])); 
                 
                $item_cls = trim(implode(' ', ['grid-item', $col_xxl_c, $col_xl_c, $col_lg_c, $col_md_c, $col_sm_c, $col_xs_c]));
                $remain_cls[$key] = $item_cls;
                if( !empty($grid_custom_columns[$key]['img_size_c']) )
                    $image_size = $grid_custom_columns[$key]['img_size_c'];

                $remain_image_size[$key] = $image_size;
                
                if ( !empty( $grid_custom_columns[$key]['item_c_animation'] ) ) {
                    $anm_cls = 'pxl-animate pxl-invisible animated-'.$grid_custom_columns[$key]['item_c_animation_duration'];
                    $item_c_animation_delay = !empty($grid_custom_columns[$key]['item_c_animation_delay']) ? $grid_custom_columns[$key]['item_c_animation_delay'] : '150';
                    $data_animation =  json_encode([
                        'animation'      => $grid_custom_columns[$key]['item_c_animation'],
                        'animation_delay' => $item_c_animation_delay
                    ]);
                    $data_setting = 'data-settings="'.esc_attr($data_animation).'"';
                }
                $remain_anm_cls[$key] = $anm_cls;
                $remain_data_setting[$key] = $data_setting;
                 
            }else{
                if(!empty($grid_custom_columns[0]) && count($randGallery) > (int)$settings['gallery_show'] && $show_load_more === 'true' ){
                    $item_cls = $remain_cls[$key - (int)$settings['gallery_show']];
                    $image_size = $remain_image_size[$key - (int)$settings['gallery_show']];
                    $anm_cls = $remain_anm_cls[$key - (int)$settings['gallery_show']];
                    $data_setting = $remain_data_setting[$key - (int)$settings['gallery_show']];
                }
            }
           
            $img = pxl_get_image_by_size( array(
                'attach_id'  => $value['id'],
                'thumb_size' => $image_size,
                'class' => 'no-lazyload',
            ));
            $thumbnail = $img['thumbnail'];

            if($key === 0) $item_sizer_cls = str_replace('grid-item', '', $item_cls) ; 

            $video_link = '#';
            if(isset($settings['links']) && !empty($settings['links']) && count($settings['links'])){
                if(!empty( $settings['links'][$key] ))
                    $video_link = $settings['links'][$key]['link']['url'];
            }

            $video_atts = $embed_options = [];
            $embed_params = [
                'loop' => '0',
                'controls' => '1',
                'mute' => '0',
                'rel' => '0',
                'modestbranding' => '0'
            ];
             
            $video_atts[] = 'class="pxl-video-lightbox"';
            $video_atts[] = 'data-elementor-open-lightbox="yes"';
            $video_atts[] = 'data-elementor-lightbox="' . esc_attr(json_encode([
                'type' => 'video',
                'videoType' => 'youtube',
                'url' => Embed::get_embed_url($video_link, $embed_params, $embed_options),
                'modalOptions' => [
                    'id' => 'pxl-lightbox-' . $lightbox_id.'-'.$value['id'],
                    'entranceAnimation' => 'fadeInUp',
                    'entranceAnimation_tablet' => '',
                    'entranceAnimation_mobile' => '',
                    'videoAspectRatio' => '169'
                ]
            ])).'"';
            
            ?>

            <div class="<?php echo esc_attr($item_cls); ?>">
                <div class="grid-item-inner relative item-inner-wrap overflow-hidden <?php echo esc_attr($anm_cls) ?>" <?php pxl_print_html($data_setting); ?>>
                    <?php if (!empty( $thumbnail )): ?>
                        <?php echo wp_kses_post($thumbnail); ?>
                    <?php endif; ?>
                    <div class="pxl-overlay"></div>
                    <div class="btn-video-wrap absolute" <?php echo implode(' ', $video_atts); ?>>
                        <div class="pxl-video-btn text-center">
                            <span class="pxl-icon bi bi-play"></span>
                        </div>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
            if($layout_mode == 'masonry')
                echo '<div class="grid-sizer '.$item_sizer_cls.'"></div>';
        ?>

    </div>
    <?php if(count($randGallery) > (int)$settings['gallery_show'] && $show_load_more === 'true'): ?>
    <div class="text-center load-more-wrap">
        <a href="javascript:void(0);" class="pxl-btn pxl-gallery-load outline-under draw"><span class="draw-top-right"></span>
            <span class="draw-bottom-left"></span><?php pxl_print_html($widget->get_setting('load_more_text', 'Load More')); ?></a>
    </div>
    <?php endif; ?>
</div>