<?php
use Elementor\Embed;
$img_classes = [];

if (empty($settings['video_link']['url']) || $settings['video_link']['url'] === null) return;
 
$lightbox_id = isset($settings['_id']) ? $settings['_id'] : $settings['element_id'];

$classes = ['pxl-video-lightbox'];
$classes[] = isset($settings['video_animation_duration']) ? 'animated-' . $settings['video_animation_duration'] : '';
if (!empty($settings['video_animation'])) {
    $classes[] = 'pxl-animate pxl-invisible';
    $widget->add_render_attribute( 'video_atts', 'data-settings', 
        json_encode([
            'animation'      => $settings['video_animation'],
            'animation_delay' => !empty($settings['video_animation_delay']) ? $settings['video_animation_delay'] : 300
        ])
    );
}
$embed_params = [
    'loop' => '0',
    'controls' => '1',
    'mute' => '0',
    'rel' => '0',
    'modestbranding' => '0'
];

$widget->add_render_attribute( 'video_atts', 'class', $classes);
$widget->add_render_attribute( 'video_atts', 'data-elementor-open-lightbox', "yes");
$widget->add_render_attribute( 'video_atts', 'data-elementor-lightbox', 
    json_encode([
        'type' => 'video',
        'videoType' => 'youtube',
        'url' => Embed::get_embed_url($settings['video_link']['url'], $embed_params, []),
        'modalOptions' => [
            'id' => 'pxl-lightbox-' . $lightbox_id,
            'entranceAnimation' => 'fadeInUp',
            'entranceAnimation_tablet' => '',
            'entranceAnimation_mobile' => '',
            'videoAspectRatio' => '169'
        ]
    ])
);
 
$video_bt_style = !empty( $settings['video_bt_style']) ? $settings['video_bt_style'] : '';
?>
<div class="pxl-video-player layout-2 relative btn-style-<?php echo esc_attr($video_bt_style);?>">
    <div <?php pxl_print_html($widget->get_render_attribute_string( 'video_atts' )); ?>>
        <div class="btn-video-wrap d-flex-wrap align-items-center">
            <div class="pxl-video-btn text-center">
                <span class="pxl-icon pxli pxli-play"></span>
            </div>
            <?php if(!empty( $settings['video_text'] )): ?>
                <span class="video-text"><?php pxl_print_html($settings['video_text']) ?></span>
            <?php endif; ?>
        </div>
    </div>
     
</div>