<?php
use Elementor\Embed;
$img_classes = [];

if (empty($settings['video_link']['url']) || $settings['video_link']['url'] === null) return;
 
$lightbox_id = isset($settings['_id']) ? $settings['_id'] : $settings['element_id'];

$classes = ['pxl-video-lightbox'];
$classes[] = isset($settings['video_animation_duration']) ? 'animated-' . $settings['video_animation_duration'] : '';
if (!empty($settings['video_animation'])) {
    $classes[] = 'pxl-animate pxl-invisible';
    $widget->add_render_attribute( 'video_atts', 'data-settings', 
        json_encode([
            'animation'      => $settings['video_animation'],
            'animation_delay' => !empty($settings['video_animation_delay']) ? $settings['video_animation_delay'] : 300
        ])
    );
}
$embed_params = [
    'loop' => '0',
    'controls' => '1',
    'mute' => '0',
    'rel' => '0',
    'modestbranding' => '0'
];
 
$widget->add_render_attribute( 'video_atts', 'class', $classes);
$widget->add_render_attribute( 'video_atts', 'data-elementor-open-lightbox', "yes");
$widget->add_render_attribute( 'video_atts', 'data-elementor-lightbox', 
    json_encode([
        'type' => 'video',
        'videoType' => 'youtube',
        'url' => Embed::get_embed_url($settings['video_link']['url'], $embed_params, []),
        'modalOptions' => [
            'id' => 'pxl-lightbox-' . $lightbox_id,
            'entranceAnimation' => 'fadeInUp',
            'entranceAnimation_tablet' => '',
            'entranceAnimation_mobile' => '',
            'videoAspectRatio' => '169'
        ]
    ])
);

$bg_style = '';
if( !empty($settings['video_bg_image']['url'])){ 
    $bg_style = 'style="background-image: url('.esc_url($settings['video_bg_image']['url']).');"';
}

$video_bt_style = !empty( $settings['video_bt_style']) ? $settings['video_bt_style'] : '';
?>
<div class="pxl-video-player layout-1 relative btn-style-<?php echo esc_attr($video_bt_style);?> overflow-hidden">
    <?php if(!empty($bg_style)): ?> <div class="video-bg pxl-overlay" <?php pxl_print_html($bg_style) ?>></div><?php endif; ?>
    <div class="pxl-overlay"></div>
    <div class="btn-video-wrap d-flex-wrap align-item-center justify-content-center">
        <div <?php pxl_print_html($widget->get_render_attribute_string( 'video_atts' )); ?>>
            <div class="pxl-video-btn text-center <?php echo esc_attr($video_bt_style) == 'df'? 'progress-wrap' : '' ?>">
                <?php if( $video_bt_style == 'df'): ?>
                <svg class="progress-circle svg-content" viewBox="-1 -1 102 102">
                    <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 300ms linear 0s; stroke-dasharray: 0, 1000; stroke-dashoffset: 0;"></path>
                </svg>
                <?php endif; ?>
                <span class="pxl-icon pxli pxli-play"></span>
            </div>
        </div>
    </div>
     
</div>