<?php 
	extract($settings);
?>

<?php if(count($content_list) <=0) return; ?>

<div class="pxl-text-img-wrap">
	<div class="content-inner relative">
		<ul class="d-flex-wrap list-text-hover relative">
		    <?php foreach ($content_list as $key => $value):  ?>
		    	<?php 
		    		$link_attrs = [];
					if ( ! empty( $value['link']['url'] ) ) {
						$link_attrs['href'] = $value['link']['url'];
					}
				    if ( ! empty($value['link']['is_external'] )) {
				        $link_attrs['target'] = '_blank';
				    }
				    if ( ! empty($value['link']['nofollow'] )) {
				        $link_attrs['rel'] = 'nofollow';
				    }
				    
				    if( ! empty($value['link']['custom_attributes'])){
				    	$custom_attributes = explode('|', $value['link']['custom_attributes']);
				    	foreach ($custom_attributes as $atts_value) {
				    		$_custom_attributes = explode(':', $atts_value);
				    		$link_attrs[$_custom_attributes[0]] = $_custom_attributes[1];
				    	}
				    }
		    	?>
		    	<li class="d-flex-wrap text-hover-item relative" data-target=".item-img-<?php echo esc_attr($key)?>">
		    		<?php if(!empty($link_attrs)): ?>
		    			<a <?php echo Elementor\Utils::render_html_attributes( $link_attrs ) ?>>
		    		<?php endif; ?>
		    			<?php if(!empty($value['sub_title'])): ?>
		    				<span class="sub-title"><?php pxl_print_html($value['sub_title']) ?></span>
		    			<?php endif; ?>
		    			<span class="title"><?php pxl_print_html($value['title']) ?></span>
		    		<?php if(!empty($link_attrs)): ?>
		    			</a>
		    		<?php endif; ?>
		    	</li>
			<?php endforeach; ?> 
		</ul>
		<div class="pxl-imgs-hover absolute">
			<?php foreach ($content_list as $key => $value):  ?>
				<?php if(!empty($value['image']['url'])): ?>
				<div class="img-item pxl-absoluted overflow-hidden item-img-<?php echo esc_attr($key)?>">
					<div class="img-inner pxl-absoluted overflow-hidden">
						<img src="<?php echo esc_url($value['image']['url'])?>" class="img-hv-ac img-cover-center w-100 h-100" alt="image hover">
					</div>
				</div>
				<?php endif; ?>
			<?php endforeach; ?> 
		</div>
	</div>
</div>