<?php
extract($settings);

$arrows = $widget->get_setting('arrows','false');  
$dots = $widget->get_setting('dots','false');  
 
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_mode'                    => 'slide', 
    'slides_to_show_xxl'            => $widget->get_setting('col_xxl', '1'), 
    'slides_to_show'                => $widget->get_setting('col_xl', '1'), 
    'slides_to_show_lg'             => $widget->get_setting('col_lg', '1'), 
    'slides_to_show_md'             => $widget->get_setting('col_md', '1'), 
    'slides_to_show_sm'             => $widget->get_setting('col_sm', '1'), 
    'slides_to_show_xs'             => $widget->get_setting('col_xs', '1'), 
    'slides_to_scroll'              => $widget->get_setting('slides_to_scroll', '1'), 
    'slides_gutter'                 => (int)$widget->get_setting('gutter', '15'),
    'arrow'                         => $arrows,
    'dots'                          => $dots,
    'dots_style'                    => 'bullets',
    'autoplay'                      => $widget->get_setting('autoplay', 'false'),
    'pause_on_hover'                => $widget->get_setting('pause_on_hover', 'true'),
    'pause_on_interaction'          => 'true',
    'delay'                         => $widget->get_setting('autoplay_speed', '5000'),
    'loop'                          => $widget->get_setting('infinite','true'),
    //'loopedSlides'                  => 3,
    'speed'                         => $widget->get_setting('speed', '500'),
    'center_slide'                  => 'true'
];
  
$cursor_arrow = $widget->get_setting('cursor_arrow','false');   
$cursor_drag = $widget->get_setting('cursor_drag','false');   

$cursor_arrow_cls = $cursor_arrow == 'true' ? 'cursor-arrow' : '';
$cursor_drag_cls = $cursor_drag == 'true' ? 'cursor-drag' : 'none-drag';


$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container '. $cursor_drag_cls.'-area',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);

$arrows_on_hover_cls = $arrows_on_hover == 'true' ? 'arrow-on-hover' : ''; 
 
?>
<?php if(isset($content_list) && !empty($content_list) && count($content_list)): ?>
    <div class="pxl-swiper-slider pxl-testimonial-carousel layout-<?php echo esc_attr($settings['layout'])?>">
        <div class="pxl-swiper-slider-wrap pxl-carousel-inner overflow-hidden">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper swiper-wrapper">
                <?php foreach ($content_list as $key => $value):
                    $description = isset($value['description']) ? $value['description'] : '';
                    $image       = isset($value['image']) ? $value['image'] : [];
                    $title       = isset($value['title']) ? $value['title'] : '';
                    $position    = isset($value['position']) ? $value['position'] : '';
                    $thumbnail = '';
                    if(!empty($image['id'])) {
                        $img = pxl_get_image_by_size( array(
                            'attach_id'  => $image['id'],
                            'thumb_size' => '264x284',
                            'class' => 'no-lazyload',
                        ));
                        $thumbnail = $img['thumbnail'];
                        $thumbnail_url = $img['url'];
                    }  
                    ?>
                    <div class="pxl-swiper-slide swiper-slide">
                        <div class="item-inner relative">
                            <div class="quote-icon"><span class="fa fa-quote-left"></span></div>
                            <div class="item-content">
                                <div class="item-desc">
                                    <?php pxl_print_html($description); ?>
                                </div>
                                <div class="item-client-info d-flex-wrap align-items-center gxm-18 relative">
                                    <?php if(!empty($thumbnail)): ?>
                                    <div class="item-image pxl-pll-basic relative">
                                        <div class="parallax-inner" style="background-image: url(<?php echo esc_url($thumbnail_url) ?>)"></div>
                                    </div>
                                    <?php endif; ?>
                                    <div class="item-names">
                                        <h4 class="item-title"><?php echo esc_html($title); ?></h4>
                                        <div class="item-position"><?php echo esc_html($position); ?></div>
                                    </div>
                                </div>
                            </div>
                             
                        </div>
                    </div>
                <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php if($arrows !== 'false'): ?>
            <div class="pxl-swiper-arrows nav-out-vertical <?php echo esc_attr($arrows_on_hover_cls) ?>">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev <?php echo esc_attr($cursor_arrow_cls.'-prev') ?>"><span class="pxl-icon bi-chevron-left"></span></div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next <?php echo esc_attr($cursor_arrow_cls.'-next') ?>"><span class="pxl-icon bi-chevron-right"></span></div>
            </div>
        <?php endif; ?>
        <?php if($dots !== 'false'): ?>
            <div class="pxl-swiper-dots"></div>
        <?php endif; ?>

    </div>
<?php endif; ?>
