<?php
extract($settings);

$arrows = $widget->get_setting('arrows','false');  
$dots = $widget->get_setting('dots','false');  
 
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_mode'                    => 'slide', 
    'slides_to_show_xxl'            => $widget->get_setting('col_xxl', '2'), 
    'slides_to_show'                => $widget->get_setting('col_xl', '2'), 
    'slides_to_show_lg'             => $widget->get_setting('col_lg', '2'), 
    'slides_to_show_md'             => $widget->get_setting('col_md', '2'), 
    'slides_to_show_sm'             => $widget->get_setting('col_sm', '1'), 
    'slides_to_show_xs'             => $widget->get_setting('col_xs', '1'), 
    'slides_to_scroll'              => $widget->get_setting('slides_to_scroll', '1'), 
    'slides_gutter'                 => (int)$widget->get_setting('gutter', '175'),
    'slides_gutter_lg'              => 75, 
    'slides_gutter_md'              => 35, 
    'arrow'                         => $arrows,
    'dots'                          => $dots,
    'dots_style'                    => 'bullets',
    'autoplay'                      => $widget->get_setting('autoplay', 'false'),
    'pause_on_hover'                => $widget->get_setting('pause_on_hover', 'true'),
    'pause_on_interaction'          => 'true',
    'delay'                         => $widget->get_setting('autoplay_speed', '5000'),
    'loop'                          => $widget->get_setting('infinite','false'),
    'speed'                         => $widget->get_setting('speed', '500')
];
  
$cursor_arrow = $widget->get_setting('cursor_arrow','false');   
$cursor_drag = $widget->get_setting('cursor_drag','false');   

$cursor_arrow_cls = $cursor_arrow == 'true' ? 'cursor-arrow' : '';
$cursor_drag_cls = $cursor_drag == 'true' ? 'cursor-drag' : 'none-drag';


$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container '. $cursor_drag_cls.'-area',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);

$arrows_on_hover_cls = $arrows_on_hover == 'true' ? 'arrow-on-hover' : ''; 
 
?>
<?php if(isset($content_list) && !empty($content_list) && count($content_list)): ?>
    <div class="pxl-swiper-slider pxl-testimonial-carousel layout-<?php echo esc_attr($settings['layout'])?>">
        <div class="pxl-swiper-slider-wrap pxl-carousel-inner overflow-hidden-sm">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper swiper-wrapper">
                <?php foreach ($content_list as $key => $value):
                    $image       = isset($value['image']) ? $value['image'] : [];
                    $title       = isset($value['title']) ? $value['title'] : '';
                    $position    = isset($value['position']) ? $value['position'] : '';
                    $description = isset($value['description']) ? $value['description'] : '';
                    $thumbnail = '';
                    if(!empty($image['id'])) {
                        $img = pxl_get_image_by_size( array(
                            'attach_id'  => $image['id'],
                            'thumb_size' => '264x324',
                            'class' => 'no-lazyload',
                        ));
                        $thumbnail = $img['thumbnail'];
                    }  
                    
                    $phrase_array = explode(' ',$description);
                    if(count($phrase_array) > 14){
                        $phrase = implode(' ',array_slice($phrase_array, 0, 14));
                        $phrase1 = implode(' ',array_slice($phrase_array, 14));
                    }else{
                        $phrase = $description;
                        $phrase1 = '';
                    }
 
                    ?>
                    <div class="pxl-swiper-slide swiper-slide">
                        <div class="item-inner relative">
                            <span class="pxl-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="22" viewBox="0 0 25 22"><text transform="translate(-5.381 79.555) scale(3.802)">“</text></svg>
                            </span>
                            <div class="item-wrap">
                                <div class="item-content">
                                    <div class="item-desc relative">
                                        <div class="desc-top">
                                        <?php pxl_print_html($phrase); ?>
                                        </div>
                                        <div class="desc-inner">
                                        <?php if(!empty($thumbnail)) :?>
                                            <span class="item-image">
                                                <?php echo wp_kses_post($thumbnail); ?>
                                            </span>
                                        <?php endif; ?>
                                        <?php pxl_print_html($phrase1); ?>”
                                        </div>
                                    </div>
                                    <div class="item-info-wrap relative">
                                        <div class="item-title"><?php echo esc_html($title); ?></div>
                                        <div class="item-position"><?php echo esc_html($position); ?></div>
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
                </div>
            </div>
        </div>
         
        <?php if($arrows !== 'false'): ?>
            <div class="pxl-swiper-arrows nav-out-vertical <?php echo esc_attr($arrows_on_hover_cls) ?>">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev <?php echo esc_attr($cursor_arrow_cls.'-prev') ?>"><span class="pxl-icon bi-chevron-left"></span></div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next <?php echo esc_attr($cursor_arrow_cls.'-next') ?>"><span class="pxl-icon bi-chevron-right"></span></div>
            </div>
        <?php endif; ?>
        <?php if($dots !== 'false'): ?>
        <div class="pxl-swiper-dots"></div>
        <?php endif; ?>
    </div>
<?php endif; ?>
