<?php
extract($settings);
$thumbnail = '';
if(!empty($image['id'])) {
    $img = pxl_get_image_by_size( array(
        'attach_id'  => $image['id'],
        'thumb_size' => '100x100',
        'class' => 'no-lazyload',
    ));
    $thumbnail = $img['thumbnail'];
    $thumbnail_url = $img['url'];
} 
?>
 
<div class="pxl-testimonial layout-<?php echo esc_attr($layout); ?>">
    <div class="pxl-testi-inner">
        <?php 
            if(!empty($quote_icon['value']))
                \Elementor\Icons_Manager::render_icon( $quote_icon, [ 'aria-hidden' => 'true','class' => 'pxl-icon quote-icon' ], 'span' );
            else
                echo '<span class="pxl-icon"><img src="'.get_template_directory_uri() . '/assets/images/quote-icon.png"/></span>';
        ?>  
    	<div class="testi-content">
            <?php if(!empty($title)): ?>
                <h4 class="title"><?php pxl_print_html($title) ?></h4>
            <?php endif; ?>
            <?php if(!empty($desc)): ?>
                <div class="desc"><?php pxl_print_html(wpautop($desc)) ?></div>
            <?php endif; ?>
            <div class="item-client-info d-flex-wrap align-items-center gxm-18 relative">
                <?php if(!empty($thumbnail)): ?>
                <div class="item-image pxl-pll-basic relative">
                    <div class="parallax-inner" style="background-image: url(<?php echo esc_url($thumbnail_url) ?>)"></div>
                </div>
                <?php endif; ?>
                <div class="item-names">
                    <h4 class="item-title"><?php echo esc_html($name); ?></h4>
                    <div class="item-position"><?php echo esc_html($position); ?></div>
                </div>
            </div>
              
        </div>
   </div>
</div>
 
