<?php
use Elementor\Icons_Manager;
Icons_Manager::enqueue_shim();

extract($settings);

$img_size = !empty( $img_size ) ? $img_size : '570x724'; 

$arrows = $widget->get_setting('arrows','false');  
$dots = $widget->get_setting('dots','false');

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_mode'                    => 'slide', 
    'slides_to_show_xxl'            => $widget->get_setting('col_xxl', '3'), 
    'slides_to_show'                => $widget->get_setting('col_xl', '3'), 
    'slides_to_show_lg'             => $widget->get_setting('col_lg', '3'), 
    'slides_to_show_md'             => $widget->get_setting('col_md', '2'), 
    'slides_to_show_sm'             => $widget->get_setting('col_sm', '1'), 
    'slides_to_show_xs'             => $widget->get_setting('col_xs', '1'), 
    'slides_to_scroll'              => $widget->get_setting('slides_to_scroll', '1'), 
    'slides_gutter'                 => (int)$widget->get_setting('gutter', '45'), 
    'slides_gutter_lg'              => 30, 
    'arrow'                         => $arrows,
    'dots'                          => $dots,
    'dots_style'                    => 'bullets',
    'autoplay'                      => $widget->get_setting('autoplay', 'false'),
    'pause_on_hover'                => $widget->get_setting('pause_on_hover', 'true'),
    'pause_on_interaction'          => 'true',
    'delay'                         => $widget->get_setting('autoplay_speed', '5000'),
    'loop'                          => $widget->get_setting('infinite','false'),
    'speed'                         => $widget->get_setting('speed', '500')
];

$data_settings = $item_anm_cls = '';
if ( !empty( $item_animation) ) {
    $item_anm_cls= ' pxl-animate pxl-invisible animated-'.$item_animation_duration;
    $item_animation_delay = !empty($item_animation_delay) ? $item_animation_delay : '150';
    $data_animations = [
        'animation' => $item_animation,
        'animation_delay' => (float)$item_animation_delay
    ];
} 
  
$cursor_arrow = $widget->get_setting('cursor_arrow','false');   
$cursor_drag = $widget->get_setting('cursor_drag','false');   

$cursor_arrow_cls = $cursor_arrow == 'true' ? 'cursor-arrow' : '';
$cursor_drag_cls = $cursor_drag == 'true' ? 'cursor-drag' : 'none-drag';

$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container '.$cursor_drag_cls.'-area',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);

$arrows_on_hover_cls = $arrows_on_hover == 'true' ? 'arrow-on-hover' : ''; 

?>
<?php if(isset($content_list) && !empty($content_list) && count($content_list)): ?>
    <div class="pxl-swiper-slider pxl-team pxl-team-carousel layout-<?php echo esc_attr($settings['layout'])?>">
        <div class="pxl-swiper-slider-wrap pxl-carousel-inner overflow-hidden">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper swiper-wrapper">
                    <?php 
                    $i = 0;
                    foreach ($content_list as $key => $value):
                        $i = $i + 50;  
                        $title    = isset($value['title']) ? $value['title'] : '';
                        $position = isset($value['position']) ? $value['position'] : '';
                        $desc     = isset($value['desc']) ? $value['desc'] : '';
                        $image    = isset($value['image']) ? $value['image'] : [];
                        $link     = isset($value['link']) ? $value['link'] : '';  
                        $thumbnail = '';
                        if(!empty($image)) {
                            $img = pxl_get_image_by_size( array(
                                'attach_id'  => $image['id'],
                                'thumb_size' => $img_size,
                                'class' => 'no-lazyload',
                            ));
                            $thumbnail = $img['thumbnail'];
                        }

                        $social = isset($value['social']) ? $value['social'] : '';
                        $link_key = $widget->get_repeater_setting_key( 'link', 'content_list', $key );
                        if ( ! empty( $link['url'] ) ) {
                            $widget->add_render_attribute( $link_key, 'href', $link['url'] );

                            if ( $link['is_external'] ) {
                                $widget->add_render_attribute( $link_key, 'target', '_blank' );
                            }

                            if ( $link['nofollow'] ) {
                                $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                            }
                        }
                        $link_attributes = $widget->get_render_attribute_string( $link_key );

                        $data_animations['animation_delay'] = ((float)$item_animation_delay + $i);
                        $data_animation =  json_encode($data_animations);
                        $data_settings = 'data-settings="'.esc_attr($data_animation).'"';

                        ?>
                        <div class="pxl-swiper-slide swiper-slide">
                            <div class="item-inner relative">
                                <?php if(!empty($thumbnail)) { ?>
                                    <div class="item-image relative overflow-hidden">
                                        <?php echo wp_kses_post($thumbnail); ?>
                                        <?php if(!empty($social)): ?>
                                            <div class="item-social absolute">
                                            <?php 
                                                $team_social = json_decode($social, true);
                                                foreach ($team_social as $value): ?>
                                                    <a href="<?php echo esc_url($value['url']); ?>" target="_blank">
                                                        <i class="pxli <?php echo esc_attr($value['icon']); ?> inactive"></i>
                                                        <i class="pxli <?php echo esc_attr($value['icon']); ?> active"></i>
                                                    </a>
                                            <?php endforeach;?>
                                            </div>
                                        <?php endif; ?>  
                                        
                                        <?php if ( ! empty( $link['url'] ) ): ?><a class="com-link absolute" <?php echo implode( ' ', [ $link_attributes ] ); ?>><span class="pxl-icon pxli pxli-comment2"></span> </a><?php endif; ?>
                                    </div>
                                <?php } ?>
                                <div class="item-content relative">
                                    <div class="item-title">
                                        <?php if ( ! empty( $link['url'] ) ): ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php endif; ?>
                                        <?php pxl_print_html($title); ?>
                                        <?php if ( ! empty( $link['url'] ) ): ?></a><?php endif; ?>
                                    </div>
                                    <div class="item-position"><?php pxl_print_html($position); ?></div>
                                    <div class="item-desc"><?php pxl_print_html($desc); ?></div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>    
            </div>
        </div>
        <?php if($arrows !== 'false'): ?>
            <div class="pxl-swiper-arrows nav-out-vertical <?php echo esc_attr($arrows_on_hover_cls) ?>">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev <?php echo esc_attr($cursor_arrow_cls.'-prev') ?>"><span class="pxl-icon bi-chevron-left"></span></div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next <?php echo esc_attr($cursor_arrow_cls.'-next') ?>"><span class="pxl-icon bi-chevron-right"></span></div>
            </div>
        <?php endif; ?>
        <?php if($dots !== 'false'): ?>
        <div class="pxl-swiper-dots"></div>
        <?php endif; ?>
    </div>
<?php endif; ?>
