<?php
use Elementor\Icons_Manager;
Icons_Manager::enqueue_shim();
extract($settings);

$img_size = !empty( $img_size ) ? $img_size : '470x470'; 

if(!empty($pxl_parallax)){
    $parallax_settings = json_encode([
        $pxl_parallax => $parallax_value
    ]);
    $widget->add_render_attribute( 'data_parallax', 'data-parallax', $parallax_settings );
} 
?>
<div class="pxl-team-wg layout-2 text-center" <?php pxl_print_html($widget->get_render_attribute_string( 'data_parallax' )); ?>>
    <div class="pxl-team-inner relative">
        <?php 
            $thumbnail = '';
            if(!empty($image['id'])) {
    			$img = pxl_get_image_by_size( array(
                    'attach_id'  => $image['id'],
                    'thumb_size' => $img_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
                $thumbnail_url = $img['url'];
            }
 
            if ( ! empty( $link['url'] ) ) {
                $widget->add_render_attribute( 'link', 'href', $link['url'] );

                if ( $link['is_external'] ) {
                    $widget->add_render_attribute( 'link', 'target', '_blank' );
                }

                if ( $link['nofollow'] ) {
                    $widget->add_render_attribute( 'link', 'rel', 'nofollow' );
                }
            }
            if ( ! empty( $link['custom_attributes'] ) ) {
            // Custom URL attributes should come as a string of comma-delimited key|value pairs
                $custom_attributes = Elementor\Utils::parse_custom_attributes( $link['custom_attributes'] );
                $widget->add_render_attribute( 'link', $custom_attributes);
            }

            $link_attributes = $widget->get_render_attribute_string( 'link');
            
        	?>
        	<?php if(!empty($img['url'])) { ?>
                <div class="item-image relative">
                    <div class="pxl-parallax-background">
                    <div class="parallax-inner" style="background-image: url('<?php echo esc_url($img['url']) ?>');"></div>
                    </div>
                </div>
            <?php } ?>
            <div class="item-content">
                <div class="item-title">
                    <?php if ( ! empty( $link['url'] ) ) echo '<a '. $link_attributes .'>'; ?>  
                    <?php pxl_print_html($title); ?>
                    <?php if ( ! empty( $link['url'] ) ) echo '</a>'; ?>
                </div>
                <div class="item-position"><?php pxl_print_html($position); ?></div>
            </div>
    </div>
</div>
 
