<?php
use Elementor\Icons_Manager;
Icons_Manager::enqueue_shim();
extract($settings);

$img_size = !empty( $img_size ) ? $img_size : '405x540'; 

if(!empty($pxl_parallax)){
    $parallax_settings = json_encode([
        $pxl_parallax => $parallax_value
    ]);
    $widget->add_render_attribute( 'data_parallax', 'data-parallax', $parallax_settings );
}  
?>
<div class="pxl-team-wg layout-1" <?php pxl_print_html($widget->get_render_attribute_string( 'data_parallax' )); ?>>
    <div class="pxl-team-inner relative">
        <?php 
            $thumbnail = '';
            if(!empty($image['id'])) {
    			$img = pxl_get_image_by_size( array(
                    'attach_id'  => $image['id'],
                    'thumb_size' => $img_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            }
 
            if ( ! empty( $link['url'] ) ) {
                $widget->add_render_attribute( 'link', 'href', $link['url'] );

                if ( $link['is_external'] ) {
                    $widget->add_render_attribute( 'link', 'target', '_blank' );
                }

                if ( $link['nofollow'] ) {
                    $widget->add_render_attribute( 'link', 'rel', 'nofollow' );
                }
            }
            if ( ! empty( $link['custom_attributes'] ) ) {
            // Custom URL attributes should come as a string of comma-delimited key|value pairs
            $custom_attributes = Elementor\Utils::parse_custom_attributes( $link['custom_attributes'] );
            $widget->add_render_attribute( 'link', $custom_attributes);
        }

            $link_attributes = $widget->get_render_attribute_string( 'link');
            $link_title = !empty($link_title) ? $link_title : esc_html__( 'Team Member', 'adsett' )
        	?>
        	<?php if(!empty($thumbnail)) { ?>
                <div class="item-image relative">
                    <?php echo wp_kses_post($thumbnail); ?>
                    <div class="pxl-overlay">
                        <?php if(!empty($social)): ?>
                            <div class="item-social">
                            <?php 
                                $team_social = json_decode($social, true);
                                foreach ($team_social as $value): ?>
                                    <a href="<?php echo esc_url($value['url']); ?>" target="_blank">
                                        <i class="<?php echo esc_attr($value['icon']); ?>"></i>
                                    </a>
                            <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                        <?php if ( ! empty( $link['url'] ) ): ?>
                            <a class="pxl-btn outline-above draw in-dark" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                <span class="draw-top-right"></span>
                                <span class="draw-bottom-left"></span>
                                <span class="pxl-button-text"><?php pxl_print_html($link_title) ?></span>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php } ?>
            <div class="item-content">
                <div class="item-title">
                    <?php if ( ! empty( $link['url'] ) ): ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php endif; ?>
                    <?php pxl_print_html($title); ?>
                    <?php if ( ! empty( $link['url'] ) ): ?></a><?php endif; ?>
                </div>
                <div class="item-position"><?php pxl_print_html($position); ?></div>
            </div>
    </div>
</div>
 
