<?php
extract($settings);

$thumbnail = wp_get_attachment_image( $image['id'], 'full', false, ['class' => 'image-showcase'] );
if ( ! empty( $menu_link['url'] ) ) {
    $widget->add_render_attribute( 'menu_link', 'href', $menu_link['url'] );
    if ( $menu_link['is_external'] ) {
        $widget->add_render_attribute( 'menu_link', 'target', '_blank' );
    }

    if ( $menu_link['nofollow'] ) {
        $widget->add_render_attribute( 'menu_link', 'rel', 'nofollow' );
    }
}

if ( ! empty( $btn_link1['url'] ) ) {
    $widget->add_render_attribute( 'btn_link1', 'href', $btn_link1['url'] );
    if ( $btn_link1['is_external'] ) {
        $widget->add_render_attribute( 'btn_link1', 'target', '_blank' );
    }
    if ( $btn_link1['nofollow'] ) {
        $widget->add_render_attribute( 'btn_link1', 'rel', 'nofollow' );
    }
}


if ( ! empty( $btn_link2['url'] ) ) {
    $widget->add_render_attribute( 'btn_link2', 'href', $btn_link2['url'] );
    if ( $btn_link2['is_external'] ) {
        $widget->add_render_attribute( 'btn_link2', 'target', '_blank' );
    }
    if ( $btn_link2['nofollow'] ) {
        $widget->add_render_attribute( 'btn_link2', 'rel', 'nofollow' );
    }
}
$style_cls = !empty($style) ? $style : 'style1';
$coming_soon_cls = (isset($is_coming_soon) && $is_coming_soon == 'true') ? 'is-coming-soon' : '';

$res_cls = $style == 'style1' ? 'd-none d-xl-block' : '';
?>

<div class="pxl-showcase <?php echo esc_attr($style_cls) ?> <?php echo esc_attr($coming_soon_cls) ?>">
    <div class="showcase-desktop <?php echo esc_attr($res_cls) ?> relative">
        <div class="item-image <?php echo esc_attr($res_cls) ?>">
            <?php if ( ! empty( $image['url'] ) ) { echo wp_kses_post($thumbnail); } ?>
        </div>
        <div class="item-buttons">
            <?php if ( ! empty( $btn_link1['url'] ) ): ?>
                <a class="pxl-btn outline-under draw" <?php pxl_print_html($widget->get_render_attribute_string( 'btn_link1' )); ?>>
                    <span class="draw-top-right"></span>
                    <span class="draw-bottom-left"></span>
                    <span class="pxl-button-text"><?php echo esc_html($btn_text1); ?></span>
                </a>
            <?php endif; ?>
            <?php if ( ! empty( $btn_link2['url'] ) ): ?>
                <a class="pxl-btn outline-under draw" <?php pxl_print_html($widget->get_render_attribute_string( 'btn_link2' )); ?>>
                    <span class="draw-top-right"></span>
                    <span class="draw-bottom-left"></span>
                    <span class="pxl-button-text"><?php echo esc_html($btn_text2); ?></span>
                </a>
            <?php endif; ?>
            <?php if(isset($is_coming_soon) && $is_coming_soon == 'true'): ?>
                <h3 class="title-coming-soon"><?php echo esc_html__( 'Coming Soon', 'adsett' ) ?></h3>
            <?php endif; ?>
        </div>
        <span class="item-title"><?php echo esc_attr($title); ?></span>
    </div>
    <?php if($style == 'style1'): ?>
    <div class="showcase-mobile d-xl-none">
        <?php if ( ! empty( $btn_link1['url'] ) ): ?>
            <a class="menu-item" <?php pxl_print_html($widget->get_render_attribute_string( 'btn_link1' )); ?>><?php echo esc_attr($title); ?></a>
        <?php endif; ?>
        <?php if ( ! empty( $btn_link2['url'] ) ): ?>
            <a class="menu-item" <?php pxl_print_html($widget->get_render_attribute_string( 'btn_link2' )); ?>><?php echo esc_attr($title); ?> <?php echo esc_attr($btn_text2); ?></a>
        <?php endif; ?>
    </div>    
    <?php endif; ?>
</div>