<?php
extract($settings);

$layout                  = $widget->get_setting('layout');
$layout_mode             = $widget->get_setting('layout_mode', 'fitRows');
$item_animation          = $widget->get_setting('item_animation', '');  
$item_animation_duration = $widget->get_setting('item_animation_duration', 'normal');  
$item_animation_delay    = $widget->get_setting('item_animation_delay', '150');  
$col_xs                  = $widget->get_setting('col_xs', '1');
$col_sm                  = $widget->get_setting('col_sm', '2');  
$col_md                  = $widget->get_setting('col_md', '2'); 
$col_lg                  = $widget->get_setting('col_lg', '4');
$col_xl                  = $widget->get_setting('col_xl', '4');  
$col_xxl                 = $widget->get_setting('col_xxl', '4');  
$grid_custom_columns     = $widget->get_setting('grid_custom_columns');
$img_size                = $widget->get_setting('img_size','thumbnail');

$show_load_more = $widget->get_setting('show_load_more','false');
 
$widget->add_render_attribute( 'wrapper', [
    'id'               => $settings['element_id'],
    'class'            => trim('pxl-grid pxl-service-grid clearfix layout-'.$layout),
    'data-layout-mode' => $layout_mode,
    'data-total' => count($content_list2),
    'data-show' => $widget->get_setting('number_item_show', '8'),
    'data-loadmore' => $widget->get_setting('number_loadmore_show', '8'),
]);

if(count($content_list2) > (int)$settings['number_item_show'] && $show_load_more === 'true')
    $widget->add_render_attribute( 'wrapper', ['class' => 'has-loadmore']);

 
$grid_class = 'pxl-grid-inner pxl-grid-masonry row relative overflow-hidden';
 
$widget->add_render_attribute( 'grid', 'class', $grid_class);



$col_xxl = 'col-xxl-'.str_replace('.', '',12 / floatval( $col_xxl));
$col_xl  = 'col-xl-'.str_replace('.', '',12 / floatval( $col_xl));
$col_lg  = 'col-lg-'.str_replace('.', '',12 / floatval( $col_lg));
$col_md  = 'col-md-'.str_replace('.', '',12 / floatval( $col_md));
$col_sm  = 'col-sm-'.str_replace('.', '',12 / floatval( $col_sm)); 
$col_xs  = 'col-'.str_replace('.', '',12 / floatval( $col_xs)); 

$item_class = trim(implode(' ', ['grid-item', $col_xxl, $col_xl, $col_lg, $col_md, $col_sm, $col_xs]));

$data_settings = '';
$animate_cls = '';
if ( !empty( $item_animation ) ) {
    $animate_cls = ' pxl-animate pxl-invisible animated-'.$item_animation_duration;
    $data_animation =  json_encode([
        'animation'      => $item_animation,
        'animation_delay' => (float)$item_animation_delay
    ]);
    $data_settings = 'data-settings="'.esc_attr($data_animation).'"';
}
$item_sizer_cls = str_replace('grid-item', '', $item_class) ;

?>

<?php if(isset($content_list2) && !empty($content_list2) && count($content_list2)): ?>

    <div <?php pxl_print_html($widget->get_render_attribute_string( 'wrapper' )) ?>>
        <div <?php pxl_print_html($widget->get_render_attribute_string('grid')); ?>> 
            <?php
            $remain_cls = [];
            $remain_image_size = [];
            $remain_anm_cls = [];
            $remain_data_setting = [];
            foreach ( $content_list2 as $key => $value):
                $item_cls = $item_class;  
                $image_size = $img_size;
                $anm_cls = $animate_cls;
                $data_setting = $data_settings;
                 
                if( !empty($grid_custom_columns[$key]) ){ 
                    $col_xxl_c = 'col-xxl-'.str_replace('.', '',12 / floatval($grid_custom_columns[$key]['col_xxl_c']));
                    $col_xl_c = 'col-xl-'.str_replace('.', '',12 / floatval( $grid_custom_columns[$key]['col_xl_c']));
                    $col_lg_c = 'col-lg-'.str_replace('.', '',12 / floatval( $grid_custom_columns[$key]['col_lg_c']));
                    $col_md_c = 'col-md-'.str_replace('.', '',12 / floatval( $grid_custom_columns[$key]['col_md_c']));
                    $col_sm_c = 'col-sm-'.str_replace('.', '',12 / floatval( $grid_custom_columns[$key]['col_sm_c'])); 
                    $col_xs_c = 'col-xs-'.str_replace('.', '',12 / floatval( $grid_custom_columns[$key]['col_xs_c'])); 
                     
                    $item_cls = trim(implode(' ', ['grid-item', $col_xxl_c, $col_xl_c, $col_lg_c, $col_md_c, $col_sm_c, $col_xs_c]));
                    $remain_cls[$key] = $item_cls;
                    if( !empty($grid_custom_columns[$key]['img_size_c']) )
                        $image_size = $grid_custom_columns[$key]['img_size_c'];

                    $remain_image_size[$key] = $image_size;
                    
                    if ( !empty( $grid_custom_columns[$key]['item_c_animation'] ) ) {
                        $anm_cls = 'pxl-animate pxl-invisible animated-'.$grid_custom_columns[$key]['item_c_animation_duration'];
                        $item_c_animation_delay = !empty($grid_custom_columns[$key]['item_c_animation_delay']) ? $grid_custom_columns[$key]['item_c_animation_delay'] : '150';
                        $data_animation =  json_encode([
                            'animation'      => $grid_custom_columns[$key]['item_c_animation'],
                            'animation_delay' => $item_c_animation_delay
                        ]);
                        $data_setting = 'data-settings="'.esc_attr($data_animation).'"';
                    }
                    $remain_anm_cls[$key] = $anm_cls;
                    $remain_data_setting[$key] = $data_setting;
                     
                }else{
                    if(!empty($grid_custom_columns[0]) && count($content_list2) > (int)$settings['number_item_show'] && $show_load_more === 'true' ){
                        $item_cls = $remain_cls[$key - (int)$settings['number_item_show']];
                        $image_size = $remain_image_size[$key - (int)$settings['number_item_show']];
                        $anm_cls = $remain_anm_cls[$key - (int)$settings['number_item_show']];
                        $data_setting = $remain_data_setting[$key - (int)$settings['number_item_show']];
                    }
                }
                
                $title    = isset($value['title']) ? $value['title'] : '';
                $desc    = isset($value['desc']) ? $value['desc'] : '';
                $link_text     = isset($value['link_text']) ? $value['link_text'] : esc_html__('Read More', 'adsett');  
                $link     = isset($value['link']) ? $value['link'] : '';  
                $selected_icon    = isset($value['selected_icon']) ? $value['selected_icon'] : [];
                 
                $link_key = $widget->get_repeater_setting_key( 'link', 'content_list', $key );
                if ( ! empty( $link['url'] ) ) {
                    $widget->add_render_attribute( $link_key, 'href', $link['url'] );

                    if ( $link['is_external'] ) {
                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                    }

                    if ( $link['nofollow'] ) {
                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                    }
                }
                $link_attributes = $widget->get_render_attribute_string( $link_key );
                $num = $key + 1;
 
                if($key === 0) $item_sizer_cls = str_replace('grid-item', '', $item_cls) ; 
                
                ?>

                <div class="<?php echo esc_attr($item_cls); ?>">
                    <div class="grid-item-inner relative <?php echo esc_attr($anm_cls) ?>" <?php pxl_print_html($data_setting); ?>>
                        <div class="pxl-overlay"></div> 
                        <div class="item-content">
                            <span class="number-wrap">
                                <span class="number">/ <?php echo esc_html($num);?></span>
                                <span class="number-hover">/ <?php echo esc_html($num);?></span>
                            </span>
                            <span class="item-icon">
                            <?php if ( !empty( $selected_icon['value'] ) )
                                \Elementor\Icons_Manager::render_icon( $selected_icon, [ 'aria-hidden' => 'true', 'class' => 'pxl-icon' ], 'span' );
                            ?>
                            </span>
                            <div class="title"><?php pxl_print_html($title); ?></div>
                            <div class="item-content-inner">
                                <?php if(!empty($desc)): ?>
                                    <div class="desc">
                                        <?php pxl_print_html($desc); ?>
                                    </div>
                                <?php endif; ?>
                                <?php if ( ! empty( $link['url'] ) ): ?>
                                    <a class="pxl-btn outline-under transform icon-ps-right" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                        <span class="pxl-button-text"><?php pxl_print_html($link_text) ?></span>
                                    </a>
                                <?php endif; ?>
                            </div> 
                        </div>
                    </div>
                </div>
            <?php
            endforeach;
                if($layout_mode == 'masonry')
                    echo '<div class="grid-sizer '.$item_sizer_cls.'"></div>';
            ?>

        </div>
        <?php if(count($content_list2) > (int)$settings['number_item_show'] && $show_load_more === 'true'): ?>
        <div class="text-center load-more-wrap">
            <a href="javascript:void(0);" class="pxl-btn pxl-gallery-load outline-above draw"><span class="draw-top-right"></span>
                <span class="draw-bottom-left"></span><?php pxl_print_html($widget->get_setting('load_more_text', 'Load More')); ?></a>
        </div>
        <?php endif; ?>
    </div>
<?php endif; ?>