<?php
extract($settings);

$arrows = $widget->get_setting('arrows','false');  
$dots = $widget->get_setting('dots','false');

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_mode'                    => 'slide', 
    'slides_to_show_xxl'            => $widget->get_setting('col_xxl', '4'), 
    'slides_to_show'                => $widget->get_setting('col_xl', '4'), 
    'slides_to_show_lg'             => $widget->get_setting('col_lg', '3'), 
    'slides_to_show_md'             => $widget->get_setting('col_md', '3'), 
    'slides_to_show_sm'             => $widget->get_setting('col_sm', '2'), 
    'slides_to_show_xs'             => $widget->get_setting('col_xs', '1'), 
    'slides_to_scroll'              => $widget->get_setting('slides_to_scroll', '1'), 
    'slides_gutter'                 => (int)$widget->get_setting('gutter', '26'), 
    'arrow'                         => $arrows,
    'dots'                          => $dots,
    'dots_style'                    => 'bullets',
    'autoplay'                      => $widget->get_setting('autoplay', 'false'),
    'pause_on_hover'                => $widget->get_setting('pause_on_hover', 'true'),
    'pause_on_interaction'          => 'true',
    'delay'                         => $widget->get_setting('autoplay_speed', '5000'),
    'loop'                          => $widget->get_setting('infinite','false'),
    'speed'                         => $widget->get_setting('speed', '500')
];
  
$cursor_arrow = $widget->get_setting('cursor_arrow','false');   
$cursor_drag = $widget->get_setting('cursor_drag','false');   

$cursor_arrow_cls = $cursor_arrow == 'true' ? 'cursor-arrow' : '';
$cursor_drag_cls = $cursor_drag == 'true' ? 'cursor-drag' : 'none-drag';

$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container '.$cursor_drag_cls.'-area',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);

$arrows_on_hover_cls = $arrows_on_hover == 'true' ? 'arrow-on-hover' : ''; 

?>
<?php if(isset($content_list) && !empty($content_list) && count($content_list)): ?>
    <div class="pxl-swiper-slider pxl-service-carousel layout-<?php echo esc_attr($settings['layout'])?>">
        <div class="pxl-swiper-slider-wrap pxl-carousel-inner overflow-hidden">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper swiper-wrapper">
                    <?php foreach ($content_list as $key => $value):
                        $title    = isset($value['title']) ? $value['title'] : '';
                        $desc    = isset($value['desc']) ? $value['desc'] : '';
                        $link_text     = isset($value['link_text']) ? $value['link_text'] : esc_html__('Read More', 'adsett');  
                        $link     = isset($value['link']) ? $value['link'] : '';  
                        $selected_icon    = isset($value['selected_icon']) ? $value['selected_icon'] : [];
                         
                        $link_key = $widget->get_repeater_setting_key( 'link', 'content_list', $key );
                        if ( ! empty( $link['url'] ) ) {
                            $widget->add_render_attribute( $link_key, 'href', $link['url'] );

                            if ( $link['is_external'] ) {
                                $widget->add_render_attribute( $link_key, 'target', '_blank' );
                            }

                            if ( $link['nofollow'] ) {
                                $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                            }
                        }
                        $link_attributes = $widget->get_render_attribute_string( $link_key );
                        $num = $key + 1;
                        ?>
                        <div class="pxl-swiper-slide swiper-slide">
                            <div class="item-inner relative">
                                <div class="pxl-overlay"></div>
                                <div class="item-content">
                                    <span class="number-wrap">
                                        <span class="number">/ <?php echo esc_html($num);?></span>
                                        <span class="number-hover">/ <?php echo esc_html($num);?></span>
                                    </span>
                                    <?php if ( !empty( $selected_icon['value'] ) )
                                        \Elementor\Icons_Manager::render_icon( $selected_icon, [ 'aria-hidden' => 'true', 'class' => 'item-icon pxl-icon' ], 'span' );
                                    ?>
                                    <div class="item-title">
                                        <?php pxl_print_html($title); ?>
                                    </div>
                                    <div class="item-content-inner">
                                        <?php if(!empty($desc)): ?>
                                            <div class="desc">
                                                <?php pxl_print_html($desc); ?>
                                            </div>
                                        <?php endif; ?>
                                        <?php if ( ! empty( $link['url'] ) ): ?>
                                            <a class="pxl-btn outline-under transform icon-ps-right" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                                <span class="pxl-button-text"><?php pxl_print_html($link_text) ?></span>
                                            </a>
                                        <?php endif; ?>
                                    </div> 
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>    
            </div>
        </div>
         
        <?php if($arrows !== 'false'): ?>
            <div class="pxl-swiper-arrows nav-out-vertical <?php echo esc_attr($arrows_on_hover_cls) ?>">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev <?php echo esc_attr($cursor_arrow_cls.'-prev') ?>"><span class="pxl-icon bi-chevron-left"></span></div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next <?php echo esc_attr($cursor_arrow_cls.'-next') ?>"><span class="pxl-icon bi-chevron-right"></span></div>
            </div>
        <?php endif; ?>
        <?php if($dots !== 'false'): ?>
        <div class="pxl-swiper-dots"></div>
        <?php endif; ?>
    </div>
<?php endif; ?>
