<?php 
	$animate_cls = '';
    $data_animations = [];
    if ( !empty( $settings['item_animation'] ) ) {
        $animate_cls = 'pxl-animate pxl-invisible animated-'.$settings['item_animation_duration'];
        $item_animation_delay = !empty( $settings['item_animation_delay'] ) ? $settings['item_animation_delay'] : '200';
        $data_animations = ['animation' => $settings['item_animation'], 'animation_delay' => $item_animation_delay];
    }
?>
<div class="pxl-qc-wrap d-flex-wrap layout-2">
	<div class="qc-content-wrap">
		<div class="qc-desc-wrap">
			<?php foreach ($settings['contact_list'] as $key => $value): 
				$increase = $key + 1; 
		        $data_settings = '';
		        if ( !empty( $data_animations ) ) {
		            $data_animations['animation_delay'] = ((float)$item_animation_delay * $increase);
		            $data_settings = 'data-settings="'.esc_attr(json_encode($data_animations)).'"';
		        }
 
				?>
				<?php if(!empty($value['item_content'])): ?>
					<div class="qc-item row gx-10 <?php echo esc_attr($animate_cls); ?>" <?php pxl_print_html($data_settings); ?>> 
						<span class="col-auto pxl-icon">
						<?php if(!empty($value['pxl_icon']['value'])){
					        \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] );
						} ?>
						</span>
						<span class="col"><?php pxl_print_html(nl2br($value['item_content'])) ?></span>
					</div>
				<?php endif; ?>
			<?php endforeach; ?>
		</div>
	</div>
</div>