<?php 
$html_id = pxl_get_element_id($settings);
extract($settings);
  
$data_settings = json_encode([
    'circle_percent' => !empty($circle_percent['size']) ? (int)$circle_percent['size'] : 50,
    'circle_number' => !empty($circle_number) ? (int)$circle_number : 0,
    'prefix' => !empty($prefix) ? $prefix : '',
    'suffix' => !empty($suffix) ? $suffix : '',
    'speed' => !empty($circle_speed) ? (int)$circle_speed : 1000 
]);

$widget->add_render_attribute( 'data-setting', 'data-settings', $data_settings );
?>
<div id="<?php echo esc_attr($html_id) ?>" class="pxl-progressbar-container pxl-progressbar circle layout-4" <?php pxl_print_html($widget->get_render_attribute_string( 'data-setting' )); ?>>
	<div class="pxl-progressbar-inner relative">
		<div class="pxl-progressbar-circle-base"></div>
		<div class="pxl-progressbar-circle">
			<div class="pxl-progressbar-circle-left"></div>
			<div class="pxl-progressbar-circle-right"></div>
		</div>
		<div class="pxl-progressbar-circle-content">
			<?php if ( !empty($circle_number)) : ?>
				<div class="progress-percentage">0</div>
			<?php endif; ?>
			<div class="progress-title">
				<?php echo wp_kses_post( $circle_title ); ?>
			</div>
		</div>
	</div>
</div>