<?php

extract($settings);

if ( ! empty( $button_link['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $button_link['url'] );

    if ( $button_link['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $button_link['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
}
  
$button_text = !empty( $button_text ) ? $button_text : esc_html__( 'Try this Package', 'adsett' );
?>
<div class="pxl-pricing-single <?php echo esc_attr($item_highlight); ?>">
    <h4 class="pricing-title"><?php pxl_print_html($title); ?></h4>
    <div class="pricing-price">
        <?php if(!empty($price_prefix)): ?> <sup class="price-prefix"><?php pxl_print_html($price_prefix) ?></sup> <?php endif; ?>
        <span class="currency"><?php pxl_print_html($price_currency) ?></span> <span><?php pxl_print_html($price_value); ?></span></div>
    <div class="content-inner relative">
        <?php if(!empty($content_list_title)): ?> 
            <h5 class="content-list-title"><?php pxl_print_html($content_list_title); ?></h5>
        <?php endif; ?>
        <?php if(isset($settings['content_list']) && !empty($settings['content_list']) && count($settings['content_list'])): ?>
            <ul class="pricing-feature list-item">
                <?php foreach ($settings['content_list'] as $key => $pxl_list): 
                    $active_cls = $pxl_list['active'] == 'yes' ? 'active' : 'no-active';
                    ?>
                    <li class="<?php echo esc_attr($active_cls) ?>"><span class="pxl-icon pxli-check2"></span> <span><?php pxl_print_html($pxl_list['content'])?></span></li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
    </div>
    <?php if(!empty($button_link['url'])) : ?>
        <div class="pricing-button">
            <a class="btn in-dark" <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?>>
                <span><?php pxl_print_html($button_text); ?></span>
            </a>
        </div>
    <?php endif; ?>
</div>