<?php
extract($settings);

$tax = ['portfolio-category'];
$select_post_by = $widget->get_setting('select_post_by', 'term_selected');
$source = $post_ids = $post_ids_unselected = [];

if($select_post_by === 'post_selected'){
    $post_ids = $widget->get_setting('source_'.$settings['post_type'].'_post_ids', '');
}else{
    $source  = $widget->get_setting('source_'.$settings['post_type'], '');
    $post_ids_unselected  = $widget->get_setting('source_'.$settings['post_type'].'_post_ids_unselected', '');
}

 
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', -1);
 
$settings['layout']    = $settings['layout_'.$settings['post_type']];

extract(pxl_get_posts_of_grid(
    'portfolio', 
    ['source' => $source, 'orderby' => $orderby, 'order' => $order, 'limit' => $limit, 'post_ids' => $post_ids, 'post_not_in' => $post_ids_unselected], 
    $tax
));
 
$arrows = $widget->get_setting('arrows','false');  
$dots = $widget->get_setting('dots','false');  

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_mode'                    => 'slide', 
    'slides_to_show_xxl'            => $widget->get_setting('col_xxl', '1'), 
    'slides_to_show'                => $widget->get_setting('col_xl', '1'), 
    'slides_to_show_lg'             => $widget->get_setting('col_lg', '1'), 
    'slides_to_show_md'             => $widget->get_setting('col_md', '1'), 
    'slides_to_show_sm'             => $widget->get_setting('col_sm', '1'), 
    'slides_to_show_xs'             => $widget->get_setting('col_xs', '1'), 
    'slides_to_scroll'              => $widget->get_setting('slides_to_scroll', '1'), 
    'slides_gutter'                 => (int)$widget->get_setting('gutter', '43'),
    'slides_gutter_lg'              => 30, 
    'slides_gutter_md'              => 30, 
    'center_slide'                  => $widget->get_setting('center_slide', 'false'),
    'arrow'                         => $arrows,
    'dots'                          => $dots,
    'dots_style'                    => 'bullets',
    'autoplay'                      => $widget->get_setting('autoplay', 'false'),
    'pause_on_hover'                => $widget->get_setting('pause_on_hover', 'true'),
    'pause_on_interaction'          => 'true',
    'delay'                         => $widget->get_setting('autoplay_speed', '5000'),
    'loop'                          => $widget->get_setting('infinite','false'),
    'speed'                         => $widget->get_setting('speed', '500')
];
  
 

$img_size = !empty( $img_size ) ? $img_size : '1140x610';
$button_text = !empty( $button_text ) ? $button_text : esc_html__( 'Explore All', 'adsett' );

if ( ! empty( $settings['loadmore_link']['url'] ) ) {
    $widget->add_render_attribute( 'loadmore', 'href', $settings['loadmore_link']['url'] );
    if ( $settings['loadmore_link']['is_external'] ) {
        $widget->add_render_attribute( 'loadmore', 'target', '_blank' );
    }
    if ( $settings['loadmore_link']['nofollow'] ) {
        $widget->add_render_attribute( 'loadmore', 'rel', 'nofollow' );
    }
    $loadmore_text = !empty( $loadmore_text ) ? $loadmore_text : esc_html__( 'About Us', 'adsett' );
    $widget->add_render_attribute( 'loadmore', 'class', 'btn pxl-btn');
}

 
$data_settings = $item_anm_cls = '';
if ( !empty( $item_animation) ) {

    $item_anm_cls= ' pxl-animate pxl-invisible animated-'.$item_animation_duration;
    $item_animation_delay = !empty($item_animation_delay) ? $item_animation_delay : '150';
    $data_animations = [
        'animation' => $item_animation,
        'animation_delay' => (float)$item_animation_delay
    ];
} 

$cursor_arrow = $widget->get_setting('cursor_arrow','false');   
$cursor_drag = $widget->get_setting('cursor_drag','false');   
$cursor_arrow_cls = $cursor_arrow == 'true' ? 'cursor-arrow' : 'none-cursor';
$cursor_drag_cls = $cursor_drag == 'true' ? 'cursor-drag' : 'none-drag';
 
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container '.$cursor_drag_cls.'-area',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
?>
<?php if(!empty($posts) && count($posts)): ?>
    <div class="pxl-swiper-slider pxl-portfolio-carousel layout-<?php echo esc_attr($settings['layout']);?> center-mode-<?php echo esc_attr($opts['center_slide']);?>">
        <?php if ( ($select_post_by === 'term_selected' && $filter == "true") || ! empty( $settings['loadmore_link']['url'] )): ?>
        <div class="swiper-filter-outer">
            <?php if ($select_post_by === 'term_selected' && $filter == "true"): ?>
                <div class="swiper-filter-wrap">
                    <?php if(!empty($filter_default_title)): ?>
                        <span class="filter-item active" data-filter-target="all">
                            <span class="pxl-icon flaticon-world"></span>
                            <span class="cat-name"><?php echo esc_html($filter_default_title); ?></span>    
                        </span>
                    <?php endif; ?>
                    <?php foreach ($categories as $category): 
                        $category_arr = explode('|', $category);
                        $term = get_term_by('slug',$category_arr[0], $category_arr[1]); 
                        $term_icon = get_term_meta( $term->term_id, 'tax_portfolio_icon', true );
                         
                        ?>

                        <span class="filter-item" data-filter-target="<?php echo esc_attr($term->slug); ?>">
                            <?php if(!empty($term_icon)): ?>
                                <span class="pxl-icon <?php echo esc_attr($term_icon) ?>"></span>
                            <?php endif; ?>
                            <span class="cat-name"><?php echo esc_html($term->name); ?></span>
                        </span>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
            <?php if ( ! empty( $settings['loadmore_link']['url'] ) ): ?>
                <a <?php pxl_print_html($widget->get_render_attribute_string( 'loadmore' )); ?>>
                    <span class="pxl-button-text"><?php echo esc_html( $loadmore_text) ?></span>
                    <span class="pxl-icon pxli pxli-right-arrow1"></span> 
                </a>
            <?php endif; ?>
        </div>
        <?php endif; ?>
        <div class="pxl-swiper-slider-wrap pxl-carousel-inner overflow-hidden">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper swiper-wrapper">
                <?php 
                $i = 0;
                foreach ($posts as $post):
                    $i = $i + 50;  
                     
                    $thumbnail = '';
                    if (has_post_thumbnail($post->ID)){
                        $img = pxl_get_image_by_size( array(
                            'post_id'  => $post->ID ,
                            'thumb_size' => $img_size,
                            'class' => 'no-lazyload',
                        ));
                        $thumbnail = $img['thumbnail'];
                    }  

                    $filter_class = '';
                    if ($select_post_by === 'term_selected' && $filter == "true")
                        $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));

                    $data_animations['animation_delay'] = ((float)$item_animation_delay + $i);
                    $data_animation =  json_encode($data_animations);
                    $data_settings = 'data-settings="'.esc_attr($data_animation).'"';

                    $location = get_post_meta( $post->ID, 'location', true );
                    $date_start = get_post_meta( $post->ID, 'date_start', true );

                    ?>
                    <div class="pxl-swiper-slide swiper-slide" data-filter="<?php echo esc_attr($filter_class) ?>">
                        <div class="item-inner relative">
                            <?php if(!empty($thumbnail)) :?>
                                <div class="item-image">
                                    <?php echo wp_kses_post($thumbnail); ?>
                                </div>
                            <?php endif; ?>
                             
                            <div class="item-content">
                                <div class="content-inner <?php echo esc_attr($item_anm_cls) ?>" <?php echo pxl_print_html($data_settings) ?>>
                                    <h4 class="item-title"><?php echo esc_attr(get_the_title($post->ID)); ?></h4>
                                    <div class="item-excerpt">
                                        <?php
                                        $num_words = empty($num_words) ? 10 : $num_words;
                                            if(!empty($post->post_excerpt)){
                                                echo wp_trim_words( $post->post_excerpt, $num_words, null );
                                            } else{
                                                $content = strip_shortcodes( $post->post_content );
                                                $content = apply_filters( 'the_content', $content );
                                                $content = str_replace(']]>', ']]&gt;', $content);
                                                echo wp_trim_words( $content, $num_words, null );
                                            }
                                        ?> 
                                    </div>
                                    <div class="metas">
                                        <?php if( !empty($location) ): ?>
                                        <div class="meta-item"><span class="lbl"><?php echo esc_html__( 'Location', 'adsett' ) ?>:</span> <?php pxl_print_html($location) ?></div>
                                        <?php endif; ?>
                                        <?php if($show_category == 'true'): ?>
                                        <div class="meta-item"><span class="lbl"><?php echo esc_html__( 'Type', 'adsett' ) ?>:</span> <?php the_terms( $post->ID, 'portfolio-category', '', ' ' ); ?></div>
                                        <?php endif; ?>
                                        <div class="meta-item"><span class="lbl"><?php echo esc_html__( 'Date', 'adsett' ) ?>:</span> <?php pxl_print_html( date(get_option('date_format'), strtotime($date_start) )); ?></div>
                                    </div>
                                    
                                    <?php if( $show_link == 'true'): 
                                        $link_text = !empty($link_text) ? $link_text :  esc_html__( 'Discover', 'adsett' );
                                        ?>
                                        <a class="pxl-readmore-round-arrow" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                            <span class="pxli pxli-right-arrow1"></span>
                                            <span class="rm-text"><?php pxl_print_html($link_text) ?></span>
                                        </a>
                                    <?php endif; ?>
                                     
                                </div>
                            </div>
                             
                        </div>
                    </div>
                <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php if($arrows !== 'false'): 
            $arrows_position_cls = !empty( $arrows_position ) ? $arrows_position : 'nav-out-vertical';
            $arrows_on_hover_cls = $arrows_on_hover == 'true' ? 'arrow-on-hover' : ''; 
 
            $arrow_attrs['class'] = 'pxl-animate pxl-invisible';
            $arrow_attrs['data-settings'] = json_encode([
                'animation'      => 'fadeInUp',
                'animation_delay' => '300'
            ]);
             
            ?>
            <div class="pxl-swiper-arrows <?php echo esc_attr($arrows_position_cls) ?> <?php echo esc_attr($arrows_on_hover_cls) ?> <?php echo esc_attr($arrow_attrs['class']) ?>" data-settings="<?php echo esc_attr($arrow_attrs['data-settings']) ?>">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev <?php echo esc_attr($cursor_arrow_cls.'-prev') ?>"><span class="pxl-icon bi-chevron-left"></span></div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next <?php echo esc_attr($cursor_arrow_cls.'-next') ?>"><span class="pxl-icon bi-chevron-right"></span></div>
            </div>
        <?php endif; ?>
        <?php if($dots !== 'false'): ?>
        <div class="pxl-swiper-dots"></div>
        <?php endif; ?>
    </div>
<?php endif; ?>
